/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zaf;
import com.google.android.gms.common.internal.zag;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public abstract class GmsClient<T extends IInterface>
extends BaseGmsClient<T>
implements Api.Client,
GmsClientEventManager.GmsClientEventState {
    private final ClientSettings zaex;
    private final Set<Scope> mScopes;
    private final Account zax;

    @VisibleForTesting
    @KeepForSdk
    protected GmsClient(Context context, Handler handler, int n, ClientSettings clientSettings) {
        this(context, handler, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    @KeepForSdk
    protected GmsClient(Context context, Looper looper, int n, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, (ConnectionCallbacks)Preconditions.checkNotNull((Object)connectionCallbacks), (OnConnectionFailedListener)Preconditions.checkNotNull((Object)onConnectionFailedListener));
    }

    @Deprecated
    @KeepForSdk
    protected GmsClient(Context context, Looper looper, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, n, clientSettings, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
    }

    @KeepForSdk
    protected GmsClient(Context context, Looper looper, int n, ClientSettings clientSettings) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    @VisibleForTesting
    protected GmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zaa(connectionCallbacks), GmsClient.zaa(onConnectionFailedListener), clientSettings.getRealClientClassName());
        this.zaex = clientSettings;
        this.zax = clientSettings.getAccount();
        this.mScopes = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @VisibleForTesting
    protected GmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, gmsClientSupervisor, googleApiAvailability, n, clientSettings, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
    }

    @VisibleForTesting
    protected GmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        super(context, handler, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zaa(connectionCallbacks), GmsClient.zaa(onConnectionFailedListener));
        this.zaex = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings);
        this.zax = clientSettings.getAccount();
        this.mScopes = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @Deprecated
    @VisibleForTesting
    protected GmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, handler, gmsClientSupervisor, googleApiAvailability, n, clientSettings, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
    }

    private final Set<Scope> zaa(@NonNull Set<Scope> set) {
        Set<Scope> set2 = this.validateScopes(set);
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    @NonNull
    @KeepForSdk
    protected Set<Scope> validateScopes(@NonNull Set<Scope> set) {
        return set;
    }

    public final Account getAccount() {
        return this.zax;
    }

    @KeepForSdk
    protected final ClientSettings getClientSettings() {
        return this.zaex;
    }

    @KeepForSdk
    protected final Set<Scope> getScopes() {
        return this.mScopes;
    }

    @Override
    @KeepForSdk
    @NonNull
    public Set<Scope> getScopesForConnectionlessNonSignIn() {
        if (this.requiresSignIn()) {
            return this.mScopes;
        }
        return Collections.emptySet();
    }

    @Override
    @KeepForSdk
    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Nullable
    private static BaseGmsClient.BaseConnectionCallbacks zaa(ConnectionCallbacks connectionCallbacks) {
        if (connectionCallbacks == null) {
            return null;
        }
        return new zag(connectionCallbacks);
    }

    @Nullable
    private static BaseGmsClient.BaseOnConnectionFailedListener zaa(OnConnectionFailedListener onConnectionFailedListener) {
        if (onConnectionFailedListener == null) {
            return null;
        }
        return new zaf(onConnectionFailedListener);
    }

    @Override
    public int getMinApkVersion() {
        return super.getMinApkVersion();
    }
}

