/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaac;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.zab;
import com.google.android.gms.common.api.zac;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;

@KeepForSdk
public class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context mContext;
    @Nullable
    private final String zabj;
    private final Api<O> mApi;
    private final O zabk;
    private final ApiKey<O> zabl;
    private final Looper zabm;
    private final int mId;
    private final GoogleApiClient zabn;
    private final StatusExceptionMapper zabo;
    protected final GoogleApiManager zabp;

    @KeepForSdk
    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        Preconditions.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zabj = GoogleApi.zaa(context);
        this.mApi = api;
        this.zabk = null;
        this.zabm = looper;
        this.zabl = ApiKey.getUniqueApiKey(api);
        this.zabn = new zabp(this);
        this.zabp = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabp.zaba();
        this.zabo = new ApiExceptionMapper();
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, Looper looper, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o, new Settings.Builder().setLooper(looper).setMapper(statusExceptionMapper).build());
    }

    @MainThread
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, Api<O> api, @Nullable O o, Settings settings) {
        Preconditions.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zabj = GoogleApi.zaa(activity);
        this.mApi = api;
        this.zabk = o;
        this.zabm = settings.zabs;
        this.zabl = ApiKey.getSharedApiKey(this.mApi, this.zabk);
        this.zabn = new zabp(this);
        this.zabp = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabp.zaba();
        this.zabo = settings.zabr;
        if (!(activity instanceof GoogleApiActivity)) {
            zaac.zaa(activity, this.zabp, this.zabl);
        }
        this.zabp.zaa(this);
    }

    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, Settings settings) {
        Preconditions.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zabj = GoogleApi.zaa(context);
        this.mApi = api;
        this.zabk = o;
        this.zabm = settings.zabs;
        this.zabl = ApiKey.getSharedApiKey(this.mApi, this.zabk);
        this.zabn = new zabp(this);
        this.zabp = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabp.zaba();
        this.zabo = settings.zabr;
        this.zabp.zaa(this);
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, Api<O> api, @Nullable O o, StatusExceptionMapper statusExceptionMapper) {
        this(activity, api, o, new Settings.Builder().setMapper(statusExceptionMapper).setLooper(activity.getMainLooper()).build());
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o, new Settings.Builder().setMapper(statusExceptionMapper).build());
    }

    private final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zaa(int n, @NonNull T t) {
        t.zas();
        this.zabp.zaa(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.AnyClient> Task<TResult> zaa(int n, @NonNull TaskApiCall<A, TResult> taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zabp.zaa(this, n, taskApiCall, taskCompletionSource, this.zabo);
        return taskCompletionSource.getTask();
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@NonNull T t) {
        return this.zaa(0, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(0, taskApiCall);
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@NonNull T t) {
        return this.zaa(1, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(1, taskApiCall);
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@NonNull T t) {
        return this.zaa(2, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(2, taskApiCall);
    }

    @Deprecated
    @KeepForSdk
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@NonNull T t, U u) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(u);
        Preconditions.checkNotNull(t.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(u.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)t.getListenerKey().equals(u.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zabp.zaa(this, t, u, zac.zabq);
    }

    @KeepForSdk
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@NonNull RegistrationMethods<A, ?> registrationMethods) {
        Preconditions.checkNotNull(registrationMethods);
        Preconditions.checkNotNull(registrationMethods.zakb.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(registrationMethods.zakc.getListenerKey(), (Object)"Listener has already been released.");
        return this.zabp.zaa(this, registrationMethods.zakb, registrationMethods.zakc, registrationMethods.zakd);
    }

    @KeepForSdk
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zabp.zaa(this, listenerKey);
    }

    @KeepForSdk
    public <L> ListenerHolder<L> registerListener(@NonNull L l, String string2) {
        return ListenerHolders.createListenerHolder(l, this.zabm, string2);
    }

    @KeepForSdk
    protected Task<Boolean> disconnectService() {
        return this.zabp.zac(this);
    }

    @WorkerThread
    public Api.Client zaa(Looper looper, GoogleApiManager.zaa<O> zaa2) {
        ClientSettings clientSettings = this.createClientSettingsBuilder().build();
        return this.mApi.zai().buildClient(this.mContext, looper, clientSettings, this.zabk, zaa2, zaa2);
    }

    public final Api<O> getApi() {
        return this.mApi;
    }

    @KeepForSdk
    public O getApiOptions() {
        return this.zabk;
    }

    @Override
    public ApiKey<O> getApiKey() {
        return this.zabl;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    @KeepForSdk
    public GoogleApiClient asGoogleApiClient() {
        return this.zabn;
    }

    @KeepForSdk
    public Looper getLooper() {
        return this.zabm;
    }

    @KeepForSdk
    public Context getApplicationContext() {
        return this.mContext;
    }

    @KeepForSdk
    protected String getContextFeatureId() {
        return this.zabj;
    }

    @KeepForSdk
    protected ClientSettings.Builder createClientSettingsBuilder() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        Account account = googleApi.zabk instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zabk).getGoogleSignInAccount()) != null ? googleSignInAccount.getAccount() : (googleApi.zabk instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zabk).getAccount() : null);
        googleApi = this;
        return new ClientSettings.Builder().setAccount(account).addAllRequiredScopes(googleApi.zabk instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zabk).getGoogleSignInAccount()) != null ? googleSignInAccount.getRequestedScopes() : Collections.emptySet()).setRealClientClassName(this.mContext.getClass().getName()).setRealClientPackageName(this.mContext.getPackageName());
    }

    private static String zaa(Object object) {
        if (PlatformVersion.isAtLeastR()) {
            try {
                return (String)Context.class.getMethod("getFeatureId", new Class[0]).invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
        return null;
    }

    public zace zaa(Context context, Handler handler) {
        return new zace(context, handler, this.createClientSettingsBuilder().build());
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        public final StatusExceptionMapper zabr;
        public final Looper zabs;

        @KeepForSdk
        private Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper) {
            this.zabr = statusExceptionMapper;
            this.zabs = looper;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zab zab2) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zabo;
            private Looper zabm;

            @KeepForSdk
            public Builder() {
            }

            @KeepForSdk
            public Builder setMapper(StatusExceptionMapper statusExceptionMapper) {
                Preconditions.checkNotNull((Object)statusExceptionMapper, (Object)"StatusExceptionMapper must not be null.");
                this.zabo = statusExceptionMapper;
                return this;
            }

            @KeepForSdk
            public Builder setLooper(Looper looper) {
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zabm = looper;
                return this;
            }

            @KeepForSdk
            public Settings build() {
                if (this.zabo == null) {
                    this.zabo = new ApiExceptionMapper();
                }
                if (this.zabm == null) {
                    this.zabm = Looper.getMainLooper();
                }
                return new Settings(this.zabo, null, this.zabm, null);
            }
        }
    }
}

