/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaak;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaan;
import com.google.android.gms.common.api.internal.zaao;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zam;
import com.google.android.gms.signin.zad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaai
implements zabd {
    private final zabc zafy;
    private final Lock zaet;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zafc;
    private ConnectionResult zafl;
    private int zaga;
    private int zagb = 0;
    private int zagc;
    private final Bundle zagd = new Bundle();
    private final Set<Api.AnyClientKey> zage = new HashSet<Api.AnyClientKey>();
    private zad zagf;
    private boolean zagg;
    private boolean zagh;
    private boolean zagi;
    private IAccountAccessor zagj;
    private boolean zagk;
    private boolean zagl;
    private final ClientSettings zaex;
    private final Map<Api<?>, Boolean> zafa;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zaci;
    private ArrayList<Future<?>> zagm = new ArrayList();

    public zaai(zabc zabc2, ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zafy = zabc2;
        this.zaex = clientSettings;
        this.zafa = map;
        this.zafc = googleApiAvailabilityLight;
        this.zaci = abstractClientBuilder;
        this.zaet = lock;
        this.mContext = context;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void begin() {
        this.zafy.zaht.clear();
        this.zagh = false;
        this.zafl = null;
        this.zagb = 0;
        this.zagg = true;
        this.zagi = false;
        this.zagk = false;
        boolean bl = false;
        HashMap<Api.Client, zaak> hashMap = new HashMap<Api.Client, zaak>();
        for (Api<?> api : this.zafa.keySet()) {
            Api.Client client = this.zafy.zahd.get(api.getClientKey());
            bl |= api.zah().getPriority() == 1;
            boolean bl2 = this.zafa.get(api);
            if (client.requiresSignIn()) {
                this.zagh = true;
                if (bl2) {
                    this.zage.add(api.getClientKey());
                } else {
                    this.zagg = false;
                }
            }
            hashMap.put(client, new zaak(this, api, bl2));
        }
        if (bl) {
            this.zagh = false;
        }
        if (this.zagh) {
            this.zaex.setClientSessionId(System.identityHashCode(this.zafy.zaej));
            zaat zaat2 = new zaat(this, null);
            this.zagf = this.zaci.buildClient(this.mContext, ((GoogleApiClient)this.zafy.zaej).getLooper(), this.zaex, this.zaex.getSignInOptions(), zaat2, zaat2);
        }
        this.zagc = this.zafy.zahd.size();
        this.zagm.add(zabg.zabd().submit(new zaan(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zaam() {
        --this.zagc;
        if (this.zagc > 0) {
            return false;
        }
        if (this.zagc < 0) {
            Log.w((String)"GACConnecting", (String)this.zafy.zaej.zaaw());
            Log.wtf((String)"GACConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        if (this.zafl != null) {
            this.zafy.zahw = this.zaga;
            this.zae(this.zafl);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaa(zam zam2) {
        if (!this.zac(0)) {
            return;
        }
        ConnectionResult connectionResult = zam2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zam2.zacv();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GACConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zae(connectionResult2);
                return;
            }
            this.zagi = true;
            this.zagj = resolveAccountResponse.getAccountAccessor();
            this.zagk = resolveAccountResponse.getSaveDefaultAccount();
            this.zagl = resolveAccountResponse.isFromCrossClientAuth();
            this.zaan();
            return;
        }
        if (this.zad(connectionResult)) {
            this.zaap();
            this.zaan();
            return;
        }
        this.zae(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaan() {
        if (this.zagc != 0) {
            return;
        }
        if (!this.zagh || this.zagi) {
            zaai zaai2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zaai2.zagb = 1;
            zaai2.zagc = zaai2.zafy.zahd.size();
            for (Api.AnyClientKey<?> anyClientKey : zaai2.zafy.zahd.keySet()) {
                if (zaai2.zafy.zaht.containsKey(anyClientKey)) {
                    if (!zaai2.zaam()) continue;
                    zaai2.zaao();
                    continue;
                }
                arrayList.add(zaai2.zafy.zahd.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zaai2.zagm.add(zabg.zabd().submit(new zaao(zaai2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnected(Bundle bundle) {
        if (!this.zac(1)) {
            return;
        }
        if (bundle != null) {
            this.zagd.putAll(bundle);
        }
        if (this.zaam()) {
            this.zaao();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zac(1)) {
            return;
        }
        this.zab(connectionResult, api, bl);
        if (this.zaam()) {
            this.zaao();
        }
    }

    @GuardedBy(value="mLock")
    private final void zaao() {
        this.zafy.zaay();
        zabg.zabd().execute(new zaal(this));
        if (this.zagf != null) {
            if (this.zagk) {
                this.zagf.zaa(this.zagj, this.zagl);
            }
            this.zab(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zafy.zaht.keySet()) {
            this.zafy.zahd.get(anyClientKey).disconnect();
        }
        Bundle bundle = this.zagd.isEmpty() ? null : this.zagd;
        this.zafy.zahx.zab(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(T t) {
        this.zafy.zaej.zafg.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void connect() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final boolean disconnect() {
        this.zaaq();
        this.zab(true);
        this.zafy.zaf(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnectionSuspended(int n) {
        this.zae(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zah().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zafc.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zafl == null || var4_4 < var5_7.zaga) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zafl = var1_1;
            this.zaga = var4_4;
        }
        this.zafy.zaht.put(var2_2.getClientKey(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zaap() {
        this.zagh = false;
        this.zafy.zaej.zahe = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zage) {
            if (this.zafy.zaht.containsKey(anyClientKey)) continue;
            this.zafy.zaht.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zad(ConnectionResult connectionResult) {
        return this.zagg && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zae(ConnectionResult connectionResult) {
        this.zaaq();
        this.zab(!connectionResult.hasResolution());
        this.zafy.zaf(connectionResult);
        this.zafy.zahx.zac(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zab(boolean bl) {
        if (this.zagf != null) {
            if (this.zagf.isConnected() && bl) {
                this.zagf.zacu();
            }
            this.zagf.disconnect();
            if (this.zaex.isSignInClientDisconnectFixEnabled()) {
                this.zagf = null;
            }
            this.zagj = null;
        }
    }

    private final void zaaq() {
        ArrayList<Future<?>> arrayList = this.zagm;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zagm.clear();
    }

    private final Set<Scope> zaar() {
        if (this.zaex == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaex.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zaex.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            if (this.zafy.zaht.containsKey(api.getClientKey())) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zac(int n) {
        if (this.zagb != n) {
            Log.w((String)"GACConnecting", (String)this.zafy.zaej.zaaw());
            String string2 = String.valueOf(this);
            Log.w((String)"GACConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zagc;
            Log.w((String)"GACConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zaai.zad(this.zagb);
            String string4 = zaai.zad(n);
            Log.e((String)"GACConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zad(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zaa(zaai zaai2) {
        return zaai2.mContext;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zab(zaai zaai2) {
        return zaai2.zafc;
    }

    static /* synthetic */ Lock zac(zaai zaai2) {
        return zaai2.zaet;
    }

    static /* synthetic */ zabc zad(zaai zaai2) {
        return zaai2.zafy;
    }

    static /* synthetic */ void zaa(zaai zaai2, ConnectionResult connectionResult) {
        zaai2.zae(connectionResult);
    }

    static /* synthetic */ boolean zae(zaai zaai2) {
        return zaai2.zagh;
    }

    static /* synthetic */ zad zaf(zaai zaai2) {
        return zaai2.zagf;
    }

    static /* synthetic */ Set zag(zaai zaai2) {
        return zaai2.zaar();
    }

    static /* synthetic */ IAccountAccessor zah(zaai zaai2) {
        return zaai2.zagj;
    }

    static /* synthetic */ ClientSettings zai(zaai zaai2) {
        return zaai2.zaex;
    }

    static /* synthetic */ boolean zab(zaai zaai2, ConnectionResult connectionResult) {
        return zaai2.zad(connectionResult);
    }

    static /* synthetic */ void zaj(zaai zaai2) {
        zaai2.zaap();
    }

    static /* synthetic */ void zak(zaai zaai2) {
        zaai2.zaan();
    }

    static /* synthetic */ boolean zaa(zaai zaai2, int n) {
        return zaai2.zac(0);
    }

    static /* synthetic */ void zaa(zaai zaai2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaai2.zab(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zal(zaai zaai2) {
        return zaai2.zaam();
    }

    static /* synthetic */ void zaa(zaai zaai2, zam zam2) {
        zaai2.zaa(zam2);
    }
}

