/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zacn;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaau
extends GoogleApiClient
implements zabr {
    private final Lock zaet;
    private boolean zacl;
    private final GmsClientEventManager zagw;
    private zabs zagx = null;
    private final int zacf;
    private final Context mContext;
    private final Looper zabm;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafg = new LinkedList();
    private volatile boolean zagy;
    private long zagz = ClientLibraryUtils.isPackageSide() ? 10000L : 120000L;
    private long zaha = 5000L;
    private final zabb zahb;
    private final GoogleApiAvailability zach;
    @VisibleForTesting
    private zabo zahc;
    final Map<Api.AnyClientKey<?>, Api.Client> zahd;
    Set<Scope> zahe = new HashSet<Scope>();
    private final ClientSettings zaex;
    private final Map<Api<?>, Boolean> zafa;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zaci;
    private final ListenerHolders zahf = new ListenerHolders();
    private final ArrayList<zaq> zahg;
    private Integer zahh = null;
    Set<zacn> zahi = null;
    final zaco zahj;
    private final GmsClientEventManager.GmsClientEventState zahk = new zaax(this);

    public zaau(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zaq> arrayList, boolean bl) {
        this.mContext = context;
        this.zaet = lock;
        this.zacl = false;
        this.zagw = new GmsClientEventManager(looper, this.zahk);
        this.zabm = looper;
        this.zahb = new zabb(this, looper);
        this.zach = googleApiAvailability;
        this.zacf = n;
        if (this.zacf >= 0) {
            this.zahh = n2;
        }
        this.zafa = map;
        this.zahd = map2;
        this.zahg = arrayList;
        this.zahj = new zaco(this.zahd);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zagw.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zagw.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zaex = clientSettings;
        this.zaci = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zahd.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zaet.lock();
        try {
            if (this.zagx == null) {
                this.zafg.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zagx.enqueue(t);
            return (T)string2;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zahd.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zaet.lock();
        try {
            if (this.zagx == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zagy) {
                this.zafg.add(t);
                while (!this.zafg.isEmpty()) {
                    object = this.zafg.remove();
                    this.zahj.zab((BasePendingResult<? extends Result>)object);
                    ((BaseImplementation.ApiMethodImpl)object).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object = t;
                return (T)object;
            }
            object = this.zagx.execute(t);
            return (T)object;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zaet.lock();
        try {
            Looper looper = this.zabm;
            L l2 = l;
            ListenerHolder<L> listenerHolder = this.zahf.zaa(l2, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zahd.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zahd.containsKey(api.getClientKey());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zahd.get(api.getClientKey());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zaet.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zagy) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zahd.containsKey(api.getClientKey())) break block6;
                    connectionResult = this.zagx.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zagy) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zaet.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zaaw());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zaet.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zaet.lock();
        try {
            if (this.zacf >= 0) {
                Preconditions.checkState((this.zahh != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahh == null) {
                this.zahh = zaau.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zahh);
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zaet.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zae(n);
            this.zaas();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaet.lock();
        try {
            if (this.zacf >= 0) {
                Preconditions.checkState((this.zahh != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahh == null) {
                this.zahh = zaau.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahh);
            this.zagw.enableCallbacks();
            ConnectionResult connectionResult = this.zagx.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaet.lock();
        try {
            if (this.zahh == null) {
                this.zahh = zaau.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahh);
            this.zagw.enableCallbacks();
            ConnectionResult connectionResult = this.zagx.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zaet.lock();
        try {
            this.zahj.release();
            if (this.zagx != null) {
                this.zagx.disconnect();
            }
            this.zahf.release();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zafg) {
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zafg.clear();
            if (this.zagx == null) {
                return;
            }
            this.zaau();
            this.zagw.disableCallbacks();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zahh != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zahd.containsKey(Common.CLIENT_KEY)) {
            this.zaa(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zaaw zaaw2 = new zaaw(this, atomicReference, statusPendingResult);
            zaaz zaaz2 = new zaaz(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(Common.API).addConnectionCallbacks(zaaw2).addOnConnectionFailedListener(zaaz2).setHandler(this.zahb).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zaa(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zapy.zaa(googleApiClient).setResultCallback(new zaay(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zaau zaau2 = this;
        if (zaau2.zacf >= 0) {
            zai.zaa(lifecycleActivity).zaa(zaau2.zacf);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zagx != null && this.zagx.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zagx != null && this.zagx.isConnecting();
    }

    private final void zae(int n) {
        if (this.zahh == null) {
            this.zahh = n;
        } else if (this.zahh != n) {
            String string2 = zaau.zaf(n);
            String string3 = zaau.zaf(this.zahh);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zagx != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zahd.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zahh) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zacl) {
                    this.zagx = new zax(this.mContext, this.zaet, this.zabm, this.zach, this.zahd, this.zaex, this.zafa, this.zaci, this.zahg, this, true);
                    return;
                }
                this.zagx = zas.zaa(this.mContext, this, this.zaet, this.zabm, this.zach, this.zahd, this.zaex, this.zafa, this.zaci, this.zahg);
                return;
            }
        }
        if (this.zacl && !bl2) {
            this.zagx = new zax(this.mContext, this.zaet, this.zabm, this.zach, this.zahd, this.zaex, this.zafa, this.zaci, this.zahg, this, false);
            return;
        }
        this.zagx = new zabc(this.mContext, this, this.zaet, this.zabm, this.zach, this.zahd, this.zaex, this.zafa, this.zaci, this.zahg, this);
    }

    @GuardedBy(value="mLock")
    private final void zaas() {
        this.zagw.enableCallbacks();
        this.zagx.connect();
    }

    private final void resume() {
        this.zaet.lock();
        try {
            if (this.zagy) {
                this.zaas();
            }
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    private final void zaat() {
        this.zaet.lock();
        try {
            if (this.zaau()) {
                this.zaas();
            }
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zaau() {
        if (!this.zagy) {
            return false;
        }
        this.zagy = false;
        this.zahb.removeMessages(2);
        this.zahb.removeMessages(1);
        if (this.zahc != null) {
            this.zahc.unregister();
            this.zahc = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagw.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zagw.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagw.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagw.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zagw.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagw.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(Bundle bundle) {
        while (!this.zafg.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zafg.remove());
        }
        this.zagw.onConnectionSuccess(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac(ConnectionResult connectionResult) {
        if (!this.zach.isPlayServicesPossiblyUpdating(this.mContext, connectionResult.getErrorCode())) {
            this.zaau();
        }
        if (!this.zagy) {
            this.zagw.onConnectionFailure(connectionResult);
            this.zagw.disableCallbacks();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(int n, boolean bl) {
        if (n == 1 && !bl) {
            zaau zaau2 = this;
            if (!zaau2.zagy) {
                zaau2.zagy = true;
                if (zaau2.zahc == null && !ClientLibraryUtils.isPackageSide()) {
                    try {
                        zaau2.zahc = zaau2.zach.zaa(zaau2.mContext.getApplicationContext(), new zaba(zaau2));
                    }
                    catch (SecurityException securityException) {}
                }
                zaau2.zahb.sendMessageDelayed(zaau2.zahb.obtainMessage(1), zaau2.zagz);
                zaau2.zahb.sendMessageDelayed(zaau2.zahb.obtainMessage(2), zaau2.zaha);
            }
        }
        this.zahj.zabv();
        this.zagw.onUnintentionalDisconnection(n);
        this.zagw.disableCallbacks();
        if (n == 2) {
            this.zaas();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zabm;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zagx != null && this.zagx.maybeSignIn(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zagx != null) {
            this.zagx.maybeSignOut();
        }
    }

    @Override
    public final void zaa(zacn zacn2) {
        this.zaet.lock();
        try {
            if (this.zahi == null) {
                this.zahi = new HashSet<zacn>();
            }
            this.zahi.add(zacn2);
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void zab(zacn zacn2) {
        this.zaet.lock();
        try {
            if (this.zahi == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zahi.remove(zacn2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zaav()) {
                this.zagx.zau();
            }
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    final boolean zaav() {
        this.zaet.lock();
        try {
            if (this.zahi == null) {
                return false;
            }
            boolean bl = !this.zahi.isEmpty();
            return bl;
        }
        finally {
            this.zaet.unlock();
        }
    }

    final String zaaw() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zagy);
        printWriter.append(" mWorkQueue.size()=").print(this.zafg.size());
        PrintWriter printWriter2 = printWriter;
        zaco zaco2 = this.zahj;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zaco2.zale.size());
        if (this.zagx != null) {
            this.zagx.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zaa(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zaf(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zaa(zaau zaau2) {
        zaau2.resume();
    }

    static /* synthetic */ void zab(zaau zaau2) {
        zaau2.zaat();
    }

    static /* synthetic */ void zaa(zaau zaau2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaau2.zaa(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zac(zaau zaau2) {
        return zaau2.mContext;
    }
}

