/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.api.internal.zan;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zal
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean zadk;
    protected final AtomicReference<zak> zadl = new AtomicReference<Object>(null);
    private final Handler zadm = new zap(Looper.getMainLooper());
    protected final GoogleApiAvailability zach;

    protected zal(LifecycleFragment lifecycleFragment) {
        this(lifecycleFragment, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    private zal(LifecycleFragment lifecycleFragment, GoogleApiAvailability googleApiAvailability) {
        super(lifecycleFragment);
        this.zach = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zaa(new ConnectionResult(13, null), zal.zaa(this.zadl.get()));
        this.zap();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zak zak2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zak2 = new zak(connectionResult, n);
            } else {
                zak2 = null;
            }
            this.zadl.set(zak2);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zak zak2 = this.zadl.get();
        if (zak2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zak2.zao());
            bundle2.putInt("failed_status", zak2.getConnectionResult().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zak2.getConnectionResult().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.zadk = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zak zak2 = this.zadl.get();
        switch (n) {
            case 2: {
                int n3 = this.zach.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zak2 == null) {
                    return;
                }
                if (zak2.getConnectionResult().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                if (zak2 == null) {
                    return;
                }
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zak2 = new zak(new ConnectionResult(n4, null, zak2.getConnectionResult().toString()), zal.zaa(zak2));
                this.zadl.set(zak2);
            }
        }
        if (bl) {
            this.zap();
            return;
        }
        if (zak2 != null) {
            this.zaa(zak2.getConnectionResult(), zak2.zao());
        }
    }

    public void onStop() {
        super.onStop();
        this.zadk = false;
    }

    protected abstract void zaa(ConnectionResult var1, int var2);

    protected abstract void zam();

    protected final void zap() {
        this.zadl.set(null);
        this.zam();
    }

    public final void zab(ConnectionResult connectionResult, int n) {
        zak zak2 = new zak(connectionResult, n);
        if (this.zadl.compareAndSet(null, zak2)) {
            this.zadm.post((Runnable)new zan(this, zak2));
        }
    }

    private static int zaa(@Nullable zak zak2) {
        if (zak2 == null) {
            return -1;
        }
        return zak2.zao();
    }
}

