/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.util.VisibleForTesting;

@ShowFirstParty
@KeepForSdk
public abstract class FastSafeParcelableJsonResponse
extends FastJsonResponse
implements SafeParcelable {
    @KeepForSdk
    public FastSafeParcelableJsonResponse() {
    }

    @Override
    @VisibleForTesting
    @Nullable
    public Object getValueObject(String string2) {
        return null;
    }

    @Override
    @VisibleForTesting
    public boolean isPrimitiveFieldSet(String string2) {
        return false;
    }

    @KeepForSdk
    public byte[] toByteArray() {
        Parcel parcel = Parcel.obtain();
        this.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    public final int describeContents() {
        return 0;
    }

    public int hashCode() {
        int n = 0;
        for (FastJsonResponse.Field<?, ?> field : this.getFieldMappings().values()) {
            if (!this.isFieldSet(field)) continue;
            n = n * 31 + Preconditions.checkNotNull((Object)this.getFieldValue(field)).hashCode();
        }
        return n;
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        FastJsonResponse fastJsonResponse = (FastJsonResponse)object;
        for (FastJsonResponse.Field<?, ?> field : this.getFieldMappings().values()) {
            if (this.isFieldSet(field)) {
                if (fastJsonResponse.isFieldSet(field)) {
                    if (Objects.equal((Object)this.getFieldValue(field), (Object)fastJsonResponse.getFieldValue(field))) continue;
                    return false;
                }
                return false;
            }
            if (!fastJsonResponse.isFieldSet(field)) continue;
            return false;
        }
        return true;
    }
}

