/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zas;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zac;
import com.google.android.gms.signin.internal.zae;
import com.google.android.gms.signin.internal.zah;
import com.google.android.gms.signin.internal.zak;
import com.google.android.gms.signin.internal.zam;
import com.google.android.gms.signin.zad;

@KeepForSdk
public class SignInClientImpl
extends GmsClient<zae>
implements zad {
    private final boolean zaa;
    private final ClientSettings zab;
    private final Bundle zac;
    @Nullable
    private final Integer zad;

    public SignInClientImpl(Context context, Looper looper, boolean bl, ClientSettings clientSettings, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zaa = bl;
        this.zab = clientSettings;
        this.zac = bundle;
        this.zad = clientSettings.zad();
    }

    public SignInClientImpl(Context context, Looper looper, boolean bl, ClientSettings clientSettings, SignInOptions signInOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, clientSettings, SignInClientImpl.createBundleFromClientSettings(clientSettings), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public boolean requiresSignIn() {
        return this.zaa;
    }

    @Override
    public final void zaa(IAccountAccessor iAccountAccessor, boolean bl) {
        try {
            ((zae)this.getService()).zaa(iAccountAccessor, (Integer)Preconditions.checkNotNull((Object)this.zad), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zaa() {
        try {
            ((zae)this.getService()).zaa((Integer)Preconditions.checkNotNull((Object)this.zad));
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zaa(zac zac2) {
        Preconditions.checkNotNull((Object)zac2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            SignInClientImpl signInClientImpl = this;
            Account account = signInClientImpl.zab.getAccountOrDefault();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = Storage.getInstance(signInClientImpl.getContext()).getSavedDefaultGoogleSignInAccount();
            }
            zas zas2 = new zas(account, (Integer)Preconditions.checkNotNull((Object)signInClientImpl.zad), googleSignInAccount);
            ((zae)this.getService()).zaa(new zak(zas2), zac2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zac2.zaa(new zam(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected Bundle getGetServiceRequestExtraArgs() {
        String string2 = this.zab.getRealClientPackageName();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zac.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zab.getRealClientPackageName());
        }
        return this.zac;
    }

    @Override
    public final void zab() {
        this.connect((BaseGmsClient.ConnectionProgressReportCallbacks)new BaseGmsClient.LegacyClientCallbackAdapter((BaseGmsClient)this));
    }

    @KeepForSdk
    public static Bundle createBundleFromClientSettings(ClientSettings clientSettings) {
        SignInOptions signInOptions = clientSettings.zac();
        Integer n = clientSettings.zad();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)clientSettings.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (signInOptions != null) {
            Long l;
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", signInOptions.zaa());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", signInOptions.zab());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", signInOptions.zac());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", signInOptions.zad());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", signInOptions.zae());
            bundle.putString("com.google.android.gms.signin.internal.logSessionId", signInOptions.zaf());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", signInOptions.zag());
            Long l2 = signInOptions.zah();
            if (l2 != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", l2.longValue());
            }
            if ((l = signInOptions.zai()) != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", l.longValue());
            }
        }
        return bundle;
    }

    @Override
    public int getMinApkVersion() {
        return 12451000;
    }

    protected /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zae) {
            return (zae)iInterface;
        }
        return new zah(iBinder2);
    }
}

