/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import androidx.annotation.Nullable;

public final class Size {
    private final int zaa;
    private final int zab;

    public Size(int n, int n2) {
        this.zaa = n;
        this.zab = n2;
    }

    public final int getWidth() {
        return this.zaa;
    }

    public final int getHeight() {
        return this.zab;
    }

    public final boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Size) {
            Size size = (Size)object;
            return this.zaa == size.zaa && this.zab == size.zab;
        }
        return false;
    }

    public final String toString() {
        int n = this.zaa;
        int n2 = this.zab;
        return new StringBuilder(23).append(n).append("x").append(n2).toString();
    }

    private static NumberFormatException zaa(String string2) {
        throw new NumberFormatException(new StringBuilder(16 + String.valueOf(string2).length()).append("Invalid Size: \"").append(string2).append("\"").toString());
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        if (string2 == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw Size.zaa(string2);
        }
        try {
            return new Size(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.zaa(string2);
        }
    }

    public final int hashCode() {
        return this.zab ^ (this.zaa << 16 | this.zaa >>> 16);
    }
}

