/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.zaa;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final AbstractClientBuilder<?, O> zaa;
    private final ClientKey<?> zab;
    private final String zac;

    @KeepForSdk
    public <C extends Client> Api(@RecentlyNonNull String string2, @RecentlyNonNull AbstractClientBuilder<C, O> abstractClientBuilder, @RecentlyNonNull ClientKey<C> clientKey) {
        Preconditions.checkNotNull(abstractClientBuilder, (Object)"Cannot construct an Api with a null ClientBuilder");
        Preconditions.checkNotNull(clientKey, (Object)"Cannot construct an Api with a null ClientKey");
        this.zac = string2;
        this.zaa = abstractClientBuilder;
        this.zab = clientKey;
    }

    @RecentlyNonNull
    public final BaseClientBuilder<?, O> zaa() {
        return this.zaa;
    }

    @RecentlyNonNull
    public final AbstractClientBuilder<?, O> zab() {
        return this.zaa;
    }

    @RecentlyNonNull
    public final AnyClientKey<?> zac() {
        return this.zab;
    }

    @RecentlyNonNull
    public final String zad() {
        return this.zac;
    }

    @KeepForSdk
    public static interface Client
    extends AnyClient {
        @KeepForSdk
        public void connect(@RecentlyNonNull BaseGmsClient.ConnectionProgressReportCallbacks var1);

        @KeepForSdk
        public void disconnect(@RecentlyNonNull String var1);

        @KeepForSdk
        public void disconnect();

        @KeepForSdk
        public boolean isConnected();

        @KeepForSdk
        public boolean isConnecting();

        @KeepForSdk
        public void getRemoteService(@Nullable IAccountAccessor var1, @Nullable Set<Scope> var2);

        @KeepForSdk
        public boolean requiresSignIn();

        @KeepForSdk
        public void onUserSignOut(@RecentlyNonNull BaseGmsClient.SignOutCallbacks var1);

        @KeepForSdk
        public boolean requiresAccount();

        @KeepForSdk
        public boolean requiresGooglePlayServices();

        @KeepForSdk
        public boolean providesSignIn();

        @KeepForSdk
        @RecentlyNonNull
        public Intent getSignInIntent();

        @KeepForSdk
        public void dump(@RecentlyNonNull String var1, @Nullable FileDescriptor var2, @RecentlyNonNull PrintWriter var3, @Nullable String[] var4);

        @RecentlyNullable
        @KeepForSdk
        public IBinder getServiceBrokerBinder();

        @KeepForSdk
        @RecentlyNonNull
        public Feature[] getRequiredFeatures();

        @KeepForSdk
        @RecentlyNonNull
        public String getEndpointPackageName();

        @KeepForSdk
        public int getMinApkVersion();

        @KeepForSdk
        @RecentlyNonNull
        public Feature[] getAvailableFeatures();

        @KeepForSdk
        @NonNull
        public Set<Scope> getScopesForConnectionlessNonSignIn();

        @KeepForSdk
        @RecentlyNullable
        public String getLastDisconnectMessage();
    }

    @KeepForSdk
    public static interface AnyClient {
    }

    @VisibleForTesting
    @KeepForSdk
    public static final class ClientKey<C extends Client>
    extends AnyClientKey<C> {
    }

    @KeepForSdk
    public static class AnyClientKey<C extends AnyClient> {
    }

    public static interface ApiOptions {
        @RecentlyNonNull
        public static final NoOptions NO_OPTIONS = new NoOptions(null);

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }

            /* synthetic */ NoOptions(zaa zaa2) {
                this();
            }
        }

        public static interface HasGoogleSignInAccountOptions
        extends HasOptions {
            @RecentlyNullable
            public GoogleSignInAccount getGoogleSignInAccount();
        }

        public static interface HasAccountOptions
        extends HasOptions,
        NotRequiredOptions {
            @RecentlyNonNull
            public Account getAccount();
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class AbstractClientBuilder<T extends Client, O>
    extends BaseClientBuilder<T, O> {
        @Deprecated
        @KeepForSdk
        @RecentlyNonNull
        public T buildClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull O o, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.buildClient(context, looper, clientSettings, o, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
        }

        @KeepForSdk
        @RecentlyNonNull
        public T buildClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull O o, @RecentlyNonNull ConnectionCallbacks connectionCallbacks, @RecentlyNonNull OnConnectionFailedListener onConnectionFailedListener) {
            throw new UnsupportedOperationException("buildClient must be implemented");
        }
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class BaseClientBuilder<T extends AnyClient, O> {
        @KeepForSdk
        public static final int API_PRIORITY_GAMES = 1;
        @KeepForSdk
        public static final int API_PRIORITY_PLUS = 2;
        @KeepForSdk
        public static final int API_PRIORITY_OTHER = Integer.MAX_VALUE;

        @KeepForSdk
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @KeepForSdk
        @RecentlyNonNull
        public List<Scope> getImpliedScopes(@Nullable O o) {
            return Collections.emptyList();
        }
    }
}

