/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zach;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.common.api.internal.zae;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.api.internal.zay;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.service.zaq;
import com.google.android.gms.common.internal.service.zar;
import com.google.android.gms.common.internal.zaaa;
import com.google.android.gms.common.internal.zaac;
import com.google.android.gms.common.internal.zao;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.internal.base.zas;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

@KeepForSdk
@ShowFirstParty
public class GoogleApiManager
implements Handler.Callback {
    @RecentlyNonNull
    public static final Status zaa = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zab = new Status(4, "The user must be signed in to make this API call.");
    private long zac = 5000L;
    private long zad = 120000L;
    private long zae = 10000L;
    private boolean zaf = false;
    private static final Object zag = new Object();
    @Nullable
    private zaaa zah;
    @Nullable
    private zaac zai;
    @GuardedBy(value="lock")
    @Nullable
    private static GoogleApiManager zaj;
    private final Context zak;
    private final GoogleApiAvailability zal;
    private final com.google.android.gms.common.internal.zaj zam;
    private final AtomicInteger zan = new AtomicInteger(1);
    private final AtomicInteger zao = new AtomicInteger(0);
    private final Map<ApiKey<?>, zaa<?>> zap = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    @Nullable
    private zay zaq = null;
    @GuardedBy(value="lock")
    private final Set<ApiKey<?>> zar = new ArraySet();
    private final Set<ApiKey<?>> zas = new ArraySet();
    @NotOnlyInitialized
    private final Handler zat;
    private volatile boolean zau = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RecentlyNonNull
    public static GoogleApiManager zaa(@RecentlyNonNull Context context) {
        Object object = zag;
        synchronized (object) {
            if (zaj == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zaj = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RecentlyNonNull
    public static GoogleApiManager zaa() {
        Object object = zag;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zaj, (Object)"Must guarantee manager is non-null before using getInstance");
            return zaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = zag;
        synchronized (object) {
            if (zaj != null) {
                GoogleApiManager googleApiManager = zaj;
                googleApiManager.zao.incrementAndGet();
                googleApiManager.zat.sendMessageAtFrontOfQueue(googleApiManager.zat.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zak = context;
        this.zat = new zas(looper, this);
        this.zal = googleApiAvailability;
        this.zam = new com.google.android.gms.common.internal.zaj(googleApiAvailability);
        if (DeviceProperties.isAuto((Context)context)) {
            this.zau = false;
        }
        this.zat.sendMessage(this.zat.obtainMessage(6));
    }

    public final int zab() {
        return this.zan.getAndIncrement();
    }

    public final void zaa(@RecentlyNonNull @UnknownInitialization GoogleApi<?> googleApi) {
        this.zat.sendMessage(this.zat.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final zaa<?> zac(GoogleApi<?> googleApi) {
        ApiKey<?> apiKey = googleApi.getApiKey();
        zaa<?> zaa2 = this.zap.get(apiKey);
        if (zaa2 == null) {
            zaa2 = new zaa(googleApi);
            this.zap.put(apiKey, zaa2);
        }
        if (zaa2.zak()) {
            this.zas.add(apiKey);
        }
        zaa2.zai();
        return zaa2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(@NonNull zay zay2) {
        Object object = zag;
        synchronized (object) {
            if (this.zaq != zay2) {
                this.zaq = zay2;
                this.zar.clear();
            }
            this.zar.addAll((Collection<ApiKey<?>>)zay2.zac());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zab(@NonNull zay zay2) {
        Object object = zag;
        synchronized (object) {
            if (this.zaq == zay2) {
                this.zaq = null;
                this.zar.clear();
            }
            return;
        }
    }

    @Nullable
    final zaa zaa(ApiKey<?> apiKey) {
        return this.zap.get(apiKey);
    }

    @RecentlyNonNull
    public final Task<Map<ApiKey<?>, String>> zaa(@RecentlyNonNull Iterable<? extends HasApiKey<?>> iterable) {
        zaj zaj2 = new zaj(iterable);
        this.zat.sendMessage(this.zat.obtainMessage(2, (Object)zaj2));
        return zaj2.zab();
    }

    public final void zac() {
        this.zat.sendMessage(this.zat.obtainMessage(3));
    }

    @RecentlyNonNull
    public final Task<Boolean> zab(@RecentlyNonNull GoogleApi<?> googleApi) {
        zaz zaz2 = new zaz(googleApi.getApiKey());
        this.zat.sendMessage(this.zat.obtainMessage(14, (Object)zaz2));
        return zaz2.zab().getTask();
    }

    public final <O extends Api.ApiOptions> void zaa(@RecentlyNonNull GoogleApi<O> googleApi, int n, @RecentlyNonNull BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zaf2 = new zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.zat.sendMessage(this.zat.obtainMessage(4, (Object)new zabu(zaf2, this.zao.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(@RecentlyNonNull GoogleApi<O> googleApi, int n, @RecentlyNonNull TaskApiCall<Api.AnyClient, ResultT> taskApiCall, @RecentlyNonNull TaskCompletionSource<ResultT> taskCompletionSource, @RecentlyNonNull StatusExceptionMapper statusExceptionMapper) {
        this.zaa(taskCompletionSource, taskApiCall.zab(), googleApi);
        zah<ResultT> zah2 = new zah<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.zat.sendMessage(this.zat.obtainMessage(4, (Object)new zabu(zah2, this.zao.get(), googleApi)));
    }

    @WorkerThread
    final boolean zad() {
        if (this.zaf) {
            return false;
        }
        RootTelemetryConfiguration rootTelemetryConfiguration = RootTelemetryConfigManager.getInstance().getConfig();
        if (rootTelemetryConfiguration != null && !rootTelemetryConfiguration.getMethodInvocationTelemetryEnabled()) {
            return false;
        }
        int n = this.zam.zaa(this.zak, 203390000);
        return n == -1 || n == 0;
    }

    @RecentlyNonNull
    public final <O extends Api.ApiOptions> Task<Void> zaa(@RecentlyNonNull GoogleApi<O> googleApi, @RecentlyNonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @RecentlyNonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod, @RecentlyNonNull Runnable runnable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaa(taskCompletionSource, registerListenerMethod.zab(), googleApi);
        zae zae2 = new zae(new zabv(registerListenerMethod, unregisterListenerMethod, runnable), (TaskCompletionSource<Void>)taskCompletionSource);
        this.zat.sendMessage(this.zat.obtainMessage(8, (Object)new zabu(zae2, this.zao.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @RecentlyNonNull
    public final <O extends Api.ApiOptions> Task<Boolean> zaa(@RecentlyNonNull GoogleApi<O> googleApi, @RecentlyNonNull ListenerHolder.ListenerKey<?> listenerKey, int n) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaa(taskCompletionSource, n, googleApi);
        zag zag2 = new zag(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.zat.sendMessage(this.zat.obtainMessage(13, (Object)new zabu(zag2, this.zao.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    private final <T> void zaa(TaskCompletionSource<T> taskCompletionSource, int n, GoogleApi<?> googleApi) {
        zabr zabr2;
        if (n != 0 && (zabr2 = zabr.zaa(this, n, googleApi.getApiKey())) != null) {
            Task task = taskCompletionSource.getTask();
            Handler handler = this.zat;
            handler.getClass();
            task.addOnCompleteListener(zabc.zaa(handler), zabr2);
        }
    }

    @WorkerThread
    public boolean handleMessage(@RecentlyNonNull Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zae = bl ? 10000L : 300000L;
                googleApiManager.zat.removeMessages(12);
                for (ApiKey<?> apiKey : googleApiManager.zap.keySet()) {
                    googleApiManager.zat.sendMessageDelayed(googleApiManager.zat.obtainMessage(12, apiKey), googleApiManager.zae);
                }
                break;
            }
            case 2: {
                zaj zaj2 = (zaj)message.obj;
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : zaj2.zaa()) {
                    ConnectionResult connectionResult;
                    zaa<?> zaa2 = googleApiManager.zap.get(apiKey);
                    if (zaa2 == null) {
                        connectionResult = new ConnectionResult(13);
                        zaj2.zaa(apiKey, connectionResult, null);
                        break block0;
                    }
                    if (zaa2.zaj()) {
                        zaj2.zaa(apiKey, ConnectionResult.RESULT_SUCCESS, zaa2.zab().getEndpointPackageName());
                        continue;
                    }
                    connectionResult = zaa2.zae();
                    if (connectionResult != null) {
                        zaj2.zaa(apiKey, connectionResult, null);
                        continue;
                    }
                    zaa2.zaa(zaj2);
                    zaa2.zai();
                }
                break;
            }
            case 3: {
                for (zaa<?> zaa3 : this.zap.values()) {
                    zaa3.zad();
                    zaa3.zai();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zabu zabu2 = (zabu)message.obj;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa4 = googleApiManager.zap.get(zabu2.zac.getApiKey());
                if (zaa4 == null) {
                    zaa4 = googleApiManager.zac(zabu2.zac);
                }
                if (zaa4.zak() && googleApiManager.zao.get() != zabu2.zab) {
                    zabu2.zaa.zaa(zaa);
                    zaa4.zaa();
                    break;
                }
                zaa4.zaa(zabu2.zaa);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa5 = null;
                for (zaa<?> zaa6 : googleApiManager.zap.values()) {
                    if (zaa6.zal() != n) continue;
                    zaa5 = zaa6;
                    break;
                }
                if (zaa5 != null) {
                    if (connectionResult.getErrorCode() == 13) {
                        zaa<?> zaa6;
                        String string2 = googleApiManager.zal.getErrorString(connectionResult.getErrorCode());
                        zaa6 = connectionResult.getErrorMessage();
                        ((zaa)zaa5).zaa(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zaa6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zaa6)).toString()));
                        break;
                    }
                    ((zaa)zaa5).zaa(GoogleApiManager.zab(((zaa)zaa5).zad, connectionResult));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!(googleApiManager.zak.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zak.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabd(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zae = 300000L;
                break;
            }
            case 7: {
                this.zac((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zap.containsKey(message.obj)) break;
                this.zap.get(message.obj).zaf();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : googleApiManager.zas) {
                    zaa<?> zaa7 = googleApiManager.zap.remove(apiKey);
                    if (zaa7 == null) continue;
                    zaa7.zaa();
                }
                googleApiManager.zas.clear();
                break;
            }
            case 11: {
                if (!this.zap.containsKey(message.obj)) break;
                this.zap.get(message.obj).zag();
                break;
            }
            case 12: {
                if (!this.zap.containsKey(message.obj)) break;
                this.zap.get(message.obj).zah();
                break;
            }
            case 14: {
                zaz zaz2 = (zaz)message.obj;
                GoogleApiManager googleApiManager = this;
                ApiKey<?> apiKey = zaz2.zaa();
                if (!googleApiManager.zap.containsKey(apiKey)) {
                    zaz2.zab().setResult((Object)false);
                    break;
                }
                boolean bl = ((zaa)googleApiManager.zap.get(apiKey)).zaa(false);
                zaz2.zab().setResult((Object)bl);
                break;
            }
            case 15: {
                zab zab2 = (zab)message.obj;
                if (!this.zap.containsKey(zab2.zaa)) break;
                ((zaa)this.zap.get(zab2.zaa)).zaa(zab2);
                break;
            }
            case 16: {
                zab zab3 = (zab)message.obj;
                if (!this.zap.containsKey(zab3.zaa)) break;
                ((zaa)this.zap.get(zab3.zaa)).zab(zab3);
                break;
            }
            case 18: {
                List<zao> list;
                zabq zabq2 = (zabq)message.obj;
                GoogleApiManager googleApiManager = this;
                if (zabq2.zac == 0L) {
                    zaaa zaaa2 = new zaaa(zabq2.zab, Arrays.asList(zabq2.zaa));
                    googleApiManager.zah().zaa(zaaa2);
                    break;
                }
                if (googleApiManager.zah != null) {
                    list = googleApiManager.zah.zab();
                    if (googleApiManager.zah.zaa() != zabq2.zab || list != null && list.size() >= zabq2.zad) {
                        googleApiManager.zat.removeMessages(17);
                        googleApiManager.zag();
                    } else {
                        googleApiManager.zah.zaa(zabq2.zaa);
                    }
                }
                if (googleApiManager.zah != null) break;
                list = new ArrayList<zao>();
                ((ArrayList)list).add(zabq2.zaa);
                googleApiManager.zah = new zaaa(zabq2.zab, list);
                googleApiManager.zat.sendMessageDelayed(googleApiManager.zat.obtainMessage(17), zabq2.zac);
                break;
            }
            case 17: {
                this.zag();
                break;
            }
            case 19: {
                this.zaf = false;
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final boolean zaa(ConnectionResult connectionResult, int n) {
        return this.zal.zaa(this.zak, connectionResult, n);
    }

    public final void zab(@RecentlyNonNull ConnectionResult connectionResult, int n) {
        if (!this.zaa(connectionResult, n)) {
            this.zat.sendMessage(this.zat.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static Status zab(ApiKey<?> apiKey, ConnectionResult connectionResult) {
        String string2 = apiKey.zaa();
        String string3 = String.valueOf(connectionResult);
        return new Status(connectionResult, new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("API: ").append(string2).append(" is not available on this device. Connection failed with: ").append(string3).toString());
    }

    final void zaa(zao zao2, int n, long l, int n2) {
        this.zat.sendMessage(this.zat.obtainMessage(18, (Object)new zabq(zao2, n, l, n2)));
    }

    @WorkerThread
    private final void zag() {
        zaaa zaaa2 = this.zah;
        if (zaaa2 != null) {
            if (zaaa2.zaa() > 0 || this.zad()) {
                this.zah().zaa(zaaa2);
            }
            this.zah = null;
        }
    }

    @WorkerThread
    private final zaac zah() {
        if (this.zai == null) {
            Context context = this.zak;
            this.zai = new zaq(context);
        }
        return this.zai;
    }

    static /* synthetic */ boolean zaa(GoogleApiManager googleApiManager, boolean bl) {
        googleApiManager.zaf = true;
        return true;
    }

    private static final class zab {
        private final ApiKey<?> zaa;
        private final Feature zab;

        private zab(ApiKey<?> apiKey, Feature feature) {
            this.zaa = apiKey;
            this.zab = feature;
        }

        public final boolean equals(@Nullable Object object) {
            if (object != null && object instanceof zab) {
                zab zab2 = (zab)object;
                return Objects.equal(this.zaa, zab2.zaa) && Objects.equal((Object)this.zab, (Object)zab2.zab);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zaa, this.zab});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zaa).add("feature", (Object)this.zab).toString();
        }

        /* synthetic */ zab(ApiKey apiKey, Feature feature, zabd zabd2) {
            this(apiKey, feature);
        }
    }

    private final class zac
    implements zach,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zab;
        private final ApiKey<?> zac;
        @Nullable
        private IAccountAccessor zad = null;
        @Nullable
        private Set<Scope> zae = null;
        private boolean zaf = false;

        public zac(Api.Client client, ApiKey<?> apiKey) {
            this.zab = client;
            this.zac = apiKey;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.zat.post((Runnable)new zabj(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zaa(ConnectionResult connectionResult) {
            zaa zaa2 = (zaa)GoogleApiManager.this.zap.get(this.zac);
            if (zaa2 != null) {
                zaa2.zaa(connectionResult);
            }
        }

        @Override
        @WorkerThread
        public final void zaa(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zaa(new ConnectionResult(4));
                return;
            }
            this.zad = iAccountAccessor;
            this.zae = set;
            this.zaa();
        }

        @WorkerThread
        private final void zaa() {
            if (this.zaf && this.zad != null) {
                this.zab.getRemoteService(this.zad, this.zae);
            }
        }

        static /* synthetic */ ApiKey zaa(zac zac2) {
            return zac2.zac;
        }

        static /* synthetic */ boolean zaa(zac zac2, boolean bl) {
            zac2.zaf = true;
            return true;
        }

        static /* synthetic */ Api.Client zab(zac zac2) {
            return zac2.zab;
        }

        static /* synthetic */ void zac(zac zac2) {
            zac2.zaa();
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zap {
        private final Queue<com.google.android.gms.common.api.internal.zab> zab = new LinkedList<com.google.android.gms.common.api.internal.zab>();
        @NotOnlyInitialized
        private final Api.Client zac;
        private final ApiKey<O> zad;
        private final zav zae;
        private final Set<zaj> zaf = new HashSet<zaj>();
        private final Map<ListenerHolder.ListenerKey<?>, zabv> zag = new HashMap();
        private final int zah;
        @Nullable
        private final zace zai;
        private boolean zaj;
        private final List<zab> zak = new ArrayList<zab>();
        @Nullable
        private ConnectionResult zal = null;
        private int zam = 0;

        @WorkerThread
        public zaa(GoogleApi<O> googleApi) {
            this.zac = googleApi.zaa(GoogleApiManager.this.zat.getLooper(), this);
            this.zad = googleApi.getApiKey();
            this.zae = new zav();
            this.zah = googleApi.zaa();
            if (this.zac.requiresSignIn()) {
                this.zai = googleApi.zaa(GoogleApiManager.this.zak, GoogleApiManager.this.zat);
                return;
            }
            this.zai = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.zao();
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabf(this));
        }

        @WorkerThread
        private final void zao() {
            this.zad();
            this.zac(ConnectionResult.RESULT_SUCCESS);
            this.zaq();
            Iterator<zabv> iterator = this.zag.values().iterator();
            while (iterator.hasNext()) {
                zabv zabv2 = iterator.next();
                if (this.zaa(zabv2.zaa.getRequiredFeatures()) != null) {
                    iterator.remove();
                    continue;
                }
                try {
                    zabv2.zaa.registerListener(this.zac, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(3);
                    this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                    break;
                }
                catch (RemoteException remoteException) {
                    iterator.remove();
                }
            }
            this.zap();
            this.zar();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.zaa(n);
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabe(this, n));
        }

        @WorkerThread
        private final void zaa(int n) {
            this.zad();
            this.zaj = true;
            this.zae.zaa(n, this.zac.getLastDisconnectMessage());
            GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)9, this.zad), GoogleApiManager.this.zac);
            GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)11, this.zad), GoogleApiManager.this.zad);
            GoogleApiManager.this.zam.zaa();
            Iterator<zabv> iterator = this.zag.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().zac.run();
            }
        }

        @WorkerThread
        public final void zaa(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            String string2 = this.zac.getClass().getName();
            String string3 = String.valueOf(connectionResult);
            this.zac.disconnect(new StringBuilder(25 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("onSignInFailed for ").append(string2).append(" with ").append(string3).toString());
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zab(@NonNull ConnectionResult connectionResult) {
            Object object = zag;
            synchronized (object) {
                if (GoogleApiManager.this.zaq != null && GoogleApiManager.this.zar.contains(this.zad)) {
                    GoogleApiManager.this.zaq.zab(connectionResult, this.zah);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabh(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zaa(connectionResult, null);
        }

        @WorkerThread
        private final void zaa(@NonNull ConnectionResult connectionResult, @Nullable Exception exception) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zai != null) {
                this.zai.zaa();
            }
            this.zad();
            GoogleApiManager.this.zam.zaa();
            this.zac(connectionResult);
            if (this.zac instanceof zar) {
                GoogleApiManager.zaa(GoogleApiManager.this, true);
                GoogleApiManager.this.zat.sendMessageDelayed(GoogleApiManager.this.zat.obtainMessage(19), 300000L);
            }
            if (connectionResult.getErrorCode() == 4) {
                this.zaa(zab);
                return;
            }
            if (this.zab.isEmpty()) {
                this.zal = connectionResult;
                return;
            }
            if (exception != null) {
                Exception exception2 = exception;
                zaa zaa2 = this;
                Preconditions.checkHandlerThread((Handler)zaa2.GoogleApiManager.this.zat);
                zaa2.zaa(null, exception2, false);
                return;
            }
            if (!GoogleApiManager.this.zau) {
                this.zaa(this.zad(connectionResult));
                return;
            }
            this.zaa(this.zad(connectionResult), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zab(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zaa(connectionResult, this.zah)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaj = true;
                }
                if (this.zaj) {
                    GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)9, this.zad), GoogleApiManager.this.zac);
                    return;
                }
                this.zaa(this.zad(connectionResult));
            }
        }

        @WorkerThread
        private final void zap() {
            ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zab);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zab zab2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zab zab3 = zab2;
                if (!this.zac.isConnected()) break;
                if (!this.zab(zab3)) continue;
                this.zab.remove(zab3);
            }
        }

        @WorkerThread
        public final void zaa(com.google.android.gms.common.api.internal.zab zab2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zac.isConnected()) {
                if (this.zab(zab2)) {
                    this.zar();
                    return;
                }
                this.zab.add(zab2);
                return;
            }
            this.zab.add(zab2);
            if (this.zal != null && this.zal.hasResolution()) {
                this.onConnectionFailed(this.zal);
                return;
            }
            this.zai();
        }

        @WorkerThread
        public final void zaa() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            this.zaa(zaa);
            this.zae.zab();
            for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
                this.zaa(new zag(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zac(new ConnectionResult(4));
            if (this.zac.isConnected()) {
                this.zac.onUserSignOut(new zabg(this));
            }
        }

        public final Api.Client zab() {
            return this.zac;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabv> zac() {
            return this.zag;
        }

        @WorkerThread
        public final void zad() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            this.zal = null;
        }

        @WorkerThread
        @Nullable
        public final ConnectionResult zae() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            return this.zal;
        }

        @WorkerThread
        private final boolean zab(com.google.android.gms.common.api.internal.zab zab2) {
            if (!(zab2 instanceof zad)) {
                this.zac(zab2);
                return true;
            }
            zad zad2 = (zad)zab2;
            Feature feature = this.zaa(zad2.zac(this));
            if (feature == null) {
                this.zac(zab2);
                return true;
            }
            String string2 = this.zac.getClass().getName();
            String string3 = feature.getName();
            long l = feature.getVersion();
            Log.w((String)"GoogleApiManager", (String)new StringBuilder(77 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" could not execute call because it requires feature (").append(string3).append(", ").append(l).append(").").toString());
            if (GoogleApiManager.this.zau && zad2.zad(this)) {
                Feature feature2 = feature;
                zaa zaa2 = this;
                zab zab3 = new zab(zaa2.zad, feature2, null);
                int n = zaa2.zak.indexOf(zab3);
                if (n >= 0) {
                    zab zab4 = zaa2.zak.get(n);
                    zaa2.GoogleApiManager.this.zat.removeMessages(15, (Object)zab4);
                    zaa2.GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zat, (int)15, (Object)zab4), zaa2.GoogleApiManager.this.zac);
                } else {
                    zaa2.zak.add(zab3);
                    zaa2.GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zat, (int)15, (Object)zab3), zaa2.GoogleApiManager.this.zac);
                    zaa2.GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.zat, (int)16, (Object)zab3), zaa2.GoogleApiManager.this.zad);
                    ConnectionResult connectionResult = new ConnectionResult(2, null);
                    if (!zaa2.zab(connectionResult)) {
                        zaa2.GoogleApiManager.this.zaa(connectionResult, zaa2.zah);
                    }
                }
                return false;
            }
            zad2.zaa((Exception)new UnsupportedApiCallException(feature));
            return true;
        }

        @WorkerThread
        private final void zac(com.google.android.gms.common.api.internal.zab zab2) {
            zab2.zaa(this.zae, this.zak());
            try {
                zab2.zaa(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
                return;
            }
            catch (Throwable throwable) {
                String string2 = String.format("Error in GoogleApi implementation for client %s.", this.zac.getClass().getName());
                throw new IllegalStateException(string2, throwable);
            }
        }

        @WorkerThread
        private final void zaa(@Nullable Status status, @Nullable Exception exception, boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (status == null == (exception == null)) {
                throw new IllegalArgumentException("Status XOR exception should be null");
            }
            Iterator iterator = this.zab.iterator();
            while (iterator.hasNext()) {
                com.google.android.gms.common.api.internal.zab zab2 = (com.google.android.gms.common.api.internal.zab)iterator.next();
                if (bl && zab2.zaa != 2) continue;
                if (status != null) {
                    zab2.zaa(status);
                } else {
                    zab2.zaa(exception);
                }
                iterator.remove();
            }
        }

        @WorkerThread
        private final void zaa(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            this.zaa(status, null, false);
        }

        @WorkerThread
        public final void zaf() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zaj) {
                this.zai();
            }
        }

        @WorkerThread
        private final void zaq() {
            if (this.zaj) {
                GoogleApiManager.this.zat.removeMessages(11, this.zad);
                GoogleApiManager.this.zat.removeMessages(9, this.zad);
                this.zaj = false;
            }
        }

        @WorkerThread
        public final void zag() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zaj) {
                this.zaq();
                Status status = GoogleApiManager.this.zal.isGooglePlayServicesAvailable(GoogleApiManager.this.zak) == 18 ? new Status(21, "Connection timed out waiting for Google Play services update to complete.") : new Status(22, "API failed to connect while resuming due to an unknown error.");
                this.zaa(status);
                this.zac.disconnect("Timing out connection while resuming.");
            }
        }

        private final void zar() {
            GoogleApiManager.this.zat.removeMessages(12, this.zad);
            GoogleApiManager.this.zat.sendMessageDelayed(GoogleApiManager.this.zat.obtainMessage(12, this.zad), GoogleApiManager.this.zae);
        }

        @WorkerThread
        public final boolean zah() {
            return this.zaa(true);
        }

        @WorkerThread
        private final boolean zaa(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zac.isConnected() && this.zag.size() == 0) {
                if (this.zae.zaa()) {
                    if (bl) {
                        this.zar();
                    }
                    return false;
                }
                this.zac.disconnect("Timing out service connection.");
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void zai() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                int n = GoogleApiManager.this.zam.zaa(GoogleApiManager.this.zak, this.zac);
                if (n != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n, null);
                    String string2 = this.zac.getClass().getName();
                    String string3 = String.valueOf(connectionResult);
                    Log.w((String)"GoogleApiManager", (String)new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("The service for ").append(string2).append(" is not available: ").append(string3).toString());
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, illegalStateException);
                return;
            }
            zac zac2 = new zac(this.zac, this.zad);
            if (this.zac.requiresSignIn()) {
                ((zace)Preconditions.checkNotNull((Object)this.zai)).zaa(zac2);
            }
            try {
                this.zac.connect(zac2);
                return;
            }
            catch (SecurityException securityException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, securityException);
                return;
            }
        }

        @WorkerThread
        public final void zaa(zaj zaj2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.zat);
            this.zaf.add(zaj2);
        }

        @WorkerThread
        private final void zac(ConnectionResult connectionResult) {
            for (zaj zaj2 : this.zaf) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zac.getEndpointPackageName();
                }
                zaj2.zaa(this.zad, connectionResult, string2);
            }
            this.zaf.clear();
        }

        final boolean zaj() {
            return this.zac.isConnected();
        }

        public final boolean zak() {
            return this.zac.requiresSignIn();
        }

        public final int zal() {
            return this.zah;
        }

        @WorkerThread
        @Nullable
        private final Feature zaa(@Nullable Feature[] featureArray) {
            Feature feature;
            int n;
            if (featureArray == null || featureArray.length == 0) {
                return null;
            }
            Feature[] featureArray2 = this.zac.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                Long l = (Long)arrayMap.get(feature.getName());
                if (l != null && l >= feature.getVersion()) continue;
                return feature;
            }
            return null;
        }

        @WorkerThread
        private final void zaa(zab zab2) {
            if (!this.zak.contains(zab2)) {
                return;
            }
            if (!this.zaj) {
                if (!this.zac.isConnected()) {
                    this.zai();
                    return;
                }
                this.zap();
            }
        }

        @WorkerThread
        private final void zab(zab zab2) {
            if (this.zak.remove(zab2)) {
                GoogleApiManager.this.zat.removeMessages(15, (Object)zab2);
                GoogleApiManager.this.zat.removeMessages(16, (Object)zab2);
                Feature feature = zab2.zab;
                zaa zaa2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(zaa2.zab.size());
                for (com.google.android.gms.common.api.internal.zab zab3 : zaa2.zab) {
                    Object[] objectArray;
                    if (!(zab3 instanceof zad) || (objectArray = ((zad)zab3).zac(zaa2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zab3);
                }
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zab zab3;
                    Object e = arrayList2.get(i);
                    zab3 = (com.google.android.gms.common.api.internal.zab)e;
                    zaa2.zab.remove(zab3);
                    zab3.zaa((Exception)new UnsupportedApiCallException(feature));
                }
            }
        }

        @WorkerThread
        final int zam() {
            return this.zam;
        }

        @WorkerThread
        final void zan() {
            ++this.zam;
        }

        private final Status zad(ConnectionResult connectionResult) {
            return GoogleApiManager.zab(this.zad, connectionResult);
        }

        static /* synthetic */ void zab(zaa zaa2) {
            zaa2.zao();
        }

        static /* synthetic */ void zaa(zaa zaa2, int n) {
            zaa2.zaa(n);
        }

        static /* synthetic */ Api.Client zac(zaa zaa2) {
            return zaa2.zac;
        }
    }
}

