/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public final class NonGmsServiceBrokerClient
implements Api.Client,
ServiceConnection {
    private static final String zaa = NonGmsServiceBrokerClient.class.getSimpleName();
    @Nullable
    private final String zab;
    @Nullable
    private final String zac;
    @Nullable
    private final ComponentName zad;
    private final Context zae;
    private final ConnectionCallbacks zaf;
    private final Handler zag;
    private final OnConnectionFailedListener zah;
    @Nullable
    private IBinder zai;
    private boolean zaj;
    @Nullable
    private String zak;
    @Nullable
    private String zal;

    @KeepForSdk
    public NonGmsServiceBrokerClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull ConnectionCallbacks connectionCallbacks, @RecentlyNonNull OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, string2, string3, null, connectionCallbacks, onConnectionFailedListener);
    }

    @KeepForSdk
    public NonGmsServiceBrokerClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull ComponentName componentName, @RecentlyNonNull ConnectionCallbacks connectionCallbacks, @RecentlyNonNull OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, null, null, componentName, connectionCallbacks, onConnectionFailedListener);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private NonGmsServiceBrokerClient(Context object, Looper looper, @Nullable String string2, @Nullable String string3, @Nullable ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        void var1_4;
        void var4_8;
        void var3_7;
        block4: {
            void var5_9;
            block5: {
                block3: {
                    block2: {
                        void var7_11;
                        void var6_10;
                        void var2_6;
                        ((NonGmsServiceBrokerClient)object2).zaj = false;
                        ((NonGmsServiceBrokerClient)object2).zak = null;
                        ((NonGmsServiceBrokerClient)object2).zae = object;
                        zap zap2 = new zap((Looper)var2_6);
                        ((NonGmsServiceBrokerClient)object2).zag = zap2;
                        ((NonGmsServiceBrokerClient)object2).zaf = var6_10;
                        ((NonGmsServiceBrokerClient)object2).zah = var7_11;
                        if (var3_7 == null || var4_8 == null) break block2;
                        if (var5_9 != null) break block3;
                        Object var1_3 = null;
                        break block4;
                    }
                    if (var5_9 != null) break block5;
                }
                Object object2 = new AssertionError((Object)"Must specify either package or component, but not both");
                throw object2;
            }
            void var1_5 = var5_9;
        }
        ((NonGmsServiceBrokerClient)object2).zab = var3_7;
        ((NonGmsServiceBrokerClient)object2).zac = var4_8;
        ((NonGmsServiceBrokerClient)object2).zad = var1_4;
    }

    public final void onServiceConnected(@RecentlyNonNull ComponentName componentName, @RecentlyNonNull IBinder iBinder) {
        componentName = this.zag;
        zabz zabz2 = new zabz(this, iBinder);
        componentName.post((Runnable)zabz2);
    }

    public final void onServiceDisconnected(@RecentlyNonNull ComponentName componentName) {
        componentName = this.zag;
        zaca zaca2 = new zaca(this);
        componentName.post((Runnable)zaca2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void connect(@RecentlyNonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        block8: {
            OnConnectionFailedListener onConnectionFailedListener;
            ComponentName componentName;
            this.zad();
            this.zae("Connect started.");
            if (this.isConnected()) {
                try {
                    this.disconnect("connect() called when already connected");
                }
                catch (Exception exception) {}
            }
            try {
                boolean bl;
                connectionProgressReportCallbacks = new Intent();
                componentName = this.zad;
                if (componentName != null) {
                    connectionProgressReportCallbacks.setComponent(componentName);
                } else {
                    connectionProgressReportCallbacks.setPackage(this.zab).setAction(this.zac);
                }
                componentName = this.zae;
                this.zaj = bl = componentName.bindService((Intent)connectionProgressReportCallbacks, (ServiceConnection)this, GmsClientSupervisor.getDefaultBindFlags());
                if (bl) break block8;
                this.zai = null;
                onConnectionFailedListener = this.zah;
            }
            catch (SecurityException securityException) {
                this.zaj = false;
                this.zai = null;
                throw securityException;
            }
            componentName = new ConnectionResult(16);
            onConnectionFailedListener.onConnectionFailed((ConnectionResult)componentName);
        }
        this.zae("Finished connect.");
    }

    @Override
    @WorkerThread
    public final void disconnect(@RecentlyNonNull String string2) {
        this.zad();
        this.zak = string2;
        this.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void disconnect() {
        this.zad();
        this.zae("Disconnect called.");
        try {
            this.zae.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.zaj = false;
        this.zai = null;
    }

    @Override
    @WorkerThread
    public final boolean isConnected() {
        this.zad();
        return this.zai != null;
    }

    @Override
    @WorkerThread
    public final boolean isConnecting() {
        this.zad();
        return this.zaj;
    }

    @Override
    public final void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
    }

    @Override
    public final boolean requiresSignIn() {
        return false;
    }

    @Override
    public final void onUserSignOut(@RecentlyNonNull BaseGmsClient.SignOutCallbacks signOutCallbacks) {
    }

    @Override
    public final boolean requiresAccount() {
        return false;
    }

    @Override
    public final boolean requiresGooglePlayServices() {
        return false;
    }

    @Override
    public final boolean providesSignIn() {
        return false;
    }

    @Override
    @RecentlyNonNull
    public final Intent getSignInIntent() {
        NonGmsServiceBrokerClient nonGmsServiceBrokerClient = new Intent();
        return nonGmsServiceBrokerClient;
    }

    @Override
    public final void dump(@RecentlyNonNull String string2, @Nullable FileDescriptor fileDescriptor, @RecentlyNonNull PrintWriter printWriter, @Nullable String[] stringArray) {
    }

    @Override
    @RecentlyNullable
    public final IBinder getServiceBrokerBinder() {
        return null;
    }

    @Override
    @RecentlyNonNull
    public final Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Override
    @RecentlyNonNull
    public final String getEndpointPackageName() {
        String string2 = this.zab;
        if (string2 != null) {
            return string2;
        }
        Preconditions.checkNotNull((Object)this.zad);
        return this.zad.getPackageName();
    }

    @Override
    public final int getMinApkVersion() {
        return 0;
    }

    @Override
    @RecentlyNonNull
    public final Feature[] getAvailableFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final Set<Scope> getScopesForConnectionlessNonSignIn() {
        return Collections.emptySet();
    }

    @Override
    @RecentlyNullable
    public final String getLastDisconnectMessage() {
        return this.zak;
    }

    @WorkerThread
    @RecentlyNullable
    @KeepForSdk
    public IBinder getBinder() {
        this.zad();
        return this.zai;
    }

    @WorkerThread
    private final void zad() {
        if (Thread.currentThread() != ((NonGmsServiceBrokerClient)object).zag.getLooper().getThread()) {
            Object object = new IllegalStateException("This method should only run on the NonGmsServiceBrokerClient's handler thread.");
            throw object;
        }
    }

    private final void zae(String string2) {
        Object object = ((NonGmsServiceBrokerClient)object).zai;
        object = String.valueOf(object);
        string2.length();
        String.valueOf(object).length();
    }

    public final void zaa(@Nullable String string2) {
        this.zal = string2;
    }

    final /* synthetic */ void zab() {
        this.zaj = false;
        this.zai = null;
        this.zae("Disconnected.");
        this.zaf.onConnectionSuspended(1);
    }

    final /* synthetic */ void zac(IBinder iBinder) {
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zaj = false;
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zai = iBinder;
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zae("Connected.");
        ConnectionCallbacks connectionCallbacks = ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zaf;
        iBinder = new Bundle();
        connectionCallbacks.onConnected((Bundle)iBinder);
    }
}

