/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zacv;
import com.google.android.gms.common.api.internal.zacx;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.internal.service.zae;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaaz
extends GoogleApiClient
implements zabt {
    private final Lock zaj;
    private final com.google.android.gms.common.internal.zak zak;
    @Nullable
    private zabu zal = null;
    private final int zam;
    private final Context zan;
    private final Looper zao;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zaa;
    private volatile boolean zap;
    private long zaq;
    private long zar;
    private final zaax zas;
    private final GoogleApiAvailability zat;
    @Nullable
    @VisibleForTesting
    zabr zab;
    final Map<Api.AnyClientKey<?>, Api.Client> zac;
    Set<Scope> zad;
    final ClientSettings zae;
    final Map<Api<?>, Boolean> zaf;
    final Api.AbstractClientBuilder<? extends com.google.android.gms.signin.zae, SignInOptions> zag;
    private final ListenerHolders zau;
    private final ArrayList<zas> zav;
    private Integer zaw;
    @Nullable
    Set<zacv> zah;
    final zacx zai;
    private final zaj zax;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public zaaz(Context object, Lock object2, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends com.google.android.gms.signin.zae, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zas> arrayList) {
        void var9_15;
        void var8_14;
        void var13_19;
        void var10_16;
        void var7_13;
        void var11_17;
        void var5_11;
        void var3_9;
        LinkedList linkedList = new LinkedList();
        this.zaa = linkedList;
        long l = true != ClientLibraryUtils.isPackageSide() ? 120000L : 10000L;
        this.zaq = l;
        this.zar = 5000L;
        Object object3 = new HashSet();
        this.zad = object3;
        this.zau = object3 = new ListenerHolders();
        this.zaw = null;
        this.zah = null;
        this.zax = object3 = new zaat(this);
        this.zan = object;
        this.zaj = object2;
        this.zak = object = new com.google.android.gms.common.internal.zak((Looper)var3_9, this.zax);
        this.zao = var3_9;
        super(this, (Looper)var3_9);
        this.zas = object;
        this.zat = var5_11;
        this.zam = var11_17;
        if (var11_17 >= 0) {
            void var12_18;
            this.zaw = (int)var12_18;
        }
        this.zaf = var7_13;
        this.zac = var10_16;
        this.zav = var13_19;
        super();
        this.zai = object;
        for (Object e : var8_14) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)e;
            this.zak.zaf(connectionCallbacks);
        }
        object = var9_15.iterator();
        while (true) {
            if (!object.hasNext()) {
                void var6_12;
                void var4_10;
                this.zae = var4_10;
                this.zag = var6_12;
                return;
            }
            Object e = object.next();
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = (GoogleApiClient.OnConnectionFailedListener)e;
            this.zak.zai(onConnectionFailedListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Object object = t.getApi();
        boolean bl = this.zac.containsKey(t.getClientKey());
        object = object != null ? ((Api)object).zad() : "the API";
        String string2 = String.valueOf(object);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 65);
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.zaj.lock();
        try {
            object = this.zal;
            if (object == null) {
                this.zaa.add(t);
                return t;
            }
            t = object.zab(t);
            return t;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T object) {
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        String string2 = String.valueOf(object2);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 65);
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.zaj.lock();
        try {
            object2 = this.zal;
            if (object2 != null) {
                boolean bl2;
                bl = this.zap;
                if (!bl) {
                    Object object3 = object2.zac(object);
                    return (T)object3;
                }
                this.zaa.add((BaseImplementation.ApiMethodImpl<?, ?>)object);
                while (!(bl2 = this.zaa.isEmpty())) {
                    object2 = this.zaa.remove();
                    this.zai.zaa((BasePendingResult<? extends Result>)object2);
                    ((BaseImplementation.ApiMethodImpl)object2).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                return (T)object;
            }
            IllegalStateException illegalStateException = new IllegalStateException("GoogleApiClient is not connected yet.");
            throw illegalStateException;
        }
        finally {
            this.zaj.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L object) {
        this.zaj.lock();
        try {
            ListenerHolders listenerHolders = this.zau;
            Looper looper = this.zao;
            object = listenerHolders.zaa(object, looper, "NO_TYPE");
        }
        finally {
            this.zaj.unlock();
        }
        return object;
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = ((zaaz)((Object)client)).zac.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zac.containsKey(api.zac());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((zaaz)((Object)client)).isConnected()) {
            return false;
        }
        Api.Client client = ((zaaz)((Object)client)).zac.get(api.zac());
        return client != null && client.isConnected();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> object) {
        this.zaj.lock();
        try {
            boolean bl = this.isConnected();
            if (bl || (bl = this.zap)) {
                bl = this.zac.containsKey(((Api)object).zac());
                if (!bl) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(((Api)object).zad()).concat(" was never registered with GoogleApiClient"));
                    throw illegalArgumentException;
                }
                zabu zabu2 = this.zal;
                if ((zabu2 = ((zabu)Preconditions.checkNotNull((Object)zabu2)).zad((Api<?>)object)) != null) return zabu2;
                boolean bl2 = this.zap;
                if (bl2) {
                    object = ConnectionResult.RESULT_SUCCESS;
                    return object;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zae());
                object = ((Api)object).zad();
                object = String.valueOf(object);
                object = ((String)object).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map");
                Exception exception = new Exception();
                Log.wtf((String)"GoogleApiClientImpl", (String)object, (Throwable)exception);
                object = new ConnectionResult(8, null);
                return object;
            }
            object = new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            throw object;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect() {
        block16: {
            boolean bl;
            int n;
            block12: {
                block17: {
                    block14: {
                        Integer n2;
                        block15: {
                            block13: {
                                this.zaj.lock();
                                n = this.zam;
                                if (n < 0) break block13;
                                Integer n3 = this.zaw;
                                boolean bl2 = n3 != null;
                                String string2 = "Sign-in mode should have been set explicitly by auto-manage.";
                                Preconditions.checkState((boolean)bl2, (Object)string2);
                                break block14;
                            }
                            n2 = this.zaw;
                            if (n2 != null) break block15;
                            this.zaw = zaaz.zaf(this.zac.values(), false);
                            break block14;
                        }
                        int n4 = n2;
                        if (n4 == 2) break block16;
                    }
                    Integer n5 = this.zaw;
                    n = (Integer)Preconditions.checkNotNull((Object)n5);
                    this.zaj.lock();
                    if (n == 3) break block17;
                    if (n != 1) {
                        if (n == 2) {
                            n = 2;
                            bl = true;
                            break block12;
                        } else {
                            bl = false;
                        }
                        break block12;
                    } else {
                        bl = true;
                    }
                    break block12;
                }
                bl = true;
            }
            try {
                CharSequence charSequence = new StringBuilder(33);
                charSequence.append("Illegal sign-in mode: ");
                charSequence.append(n);
                charSequence = charSequence.toString();
                Preconditions.checkArgument((boolean)bl, (Object)charSequence);
                this.zam(n);
                this.zan();
                return;
            }
            finally {
                this.zaj.unlock();
            }
        }
        IllegalStateException illegalStateException = new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
        throw illegalStateException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect(int n) {
        boolean bl;
        block7: {
            block8: {
                this.zaj.lock();
                if (n == 3) break block8;
                if (n != 1) {
                    if (n == 2) {
                        n = 2;
                        bl = true;
                        break block7;
                    } else {
                        bl = false;
                    }
                    break block7;
                } else {
                    bl = true;
                }
                break block7;
            }
            bl = true;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(33);
            stringBuilder.append("Illegal sign-in mode: ");
            stringBuilder.append(n);
            String string2 = stringBuilder.toString();
            Preconditions.checkArgument((boolean)bl, (Object)string2);
            this.zam(n);
            this.zan();
            return;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect() {
        int n = Looper.myLooper() != Looper.getMainLooper() ? 1 : 0;
        Preconditions.checkState(n != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaj.lock();
        try {
            n = this.zam;
            if (n >= 0) {
                Integer n2 = this.zaw;
                boolean bl = n2 != null;
                Preconditions.checkState((boolean)bl, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else {
                Integer n3 = this.zaw;
                if (n3 == null) {
                    this.zaw = zaaz.zaf(this.zac.values(), false);
                } else {
                    int n4 = n3;
                    if (n4 == 2) {
                        IllegalStateException illegalStateException = new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                        throw illegalStateException;
                    }
                }
            }
            this.zam((Integer)Preconditions.checkNotNull((Object)this.zaw));
            this.zak.zab();
            ConnectionResult connectionResult = ((zabu)Preconditions.checkNotNull((Object)this.zal)).zaf();
            this.zaj.unlock();
            return connectionResult;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit object) {
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState((boolean)bl, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)object, (Object)"TimeUnit must not be null");
        this.zaj.lock();
        try {
            Integer n = this.zaw;
            if (n == null) {
                this.zaw = zaaz.zaf(this.zac.values(), false);
            } else {
                int n2 = n;
                if (n2 == 2) {
                    IllegalStateException illegalStateException = new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                    throw illegalStateException;
                }
            }
            this.zam((Integer)Preconditions.checkNotNull((Object)this.zaw));
            this.zak.zab();
            ConnectionResult connectionResult = ((zabu)Preconditions.checkNotNull((Object)this.zal)).zag(l, (TimeUnit)((Object)object));
            return connectionResult;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void disconnect() {
        boolean bl;
        this.zaj.lock();
        this.zai.zab();
        Object object = this.zal;
        if (object != null) {
            object.zah();
        }
        this.zau.zab();
        object = this.zaa.iterator();
        while (bl = object.hasNext()) {
            BaseImplementation.ApiMethodImpl apiMethodImpl = (BaseImplementation.ApiMethodImpl)object.next();
            apiMethodImpl.zan(null);
            apiMethodImpl.cancel();
        }
        this.zaa.clear();
        object = this.zal;
        if (object == null) {
            this.zaj.unlock();
            return;
        }
        this.zad();
        this.zak.zaa();
        return;
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((zaaz)googleApiClient).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Integer n = ((zaaz)googleApiClient).zaw;
        boolean bl = n != null ? n != 2 : true;
        Preconditions.checkState((boolean)bl, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(googleApiClient);
        if (((zaaz)googleApiClient).zac.containsKey(Common.CLIENT_KEY)) {
            ((zaaz)googleApiClient).zal(googleApiClient, statusPendingResult, false);
            return statusPendingResult;
        }
        AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
        zaau zaau2 = new zaau((zaaz)googleApiClient, atomicReference, statusPendingResult);
        zaav zaav2 = new zaav((zaaz)googleApiClient, statusPendingResult);
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder(((zaaz)googleApiClient).zan);
        builder.addApi(Common.API);
        builder.addConnectionCallbacks(zaau2);
        builder.addOnConnectionFailedListener(zaav2);
        builder.setHandler(((zaaz)googleApiClient).zas);
        GoogleApiClient googleApiClient = builder.build();
        atomicReference.set(googleApiClient);
        googleApiClient.connect();
        return statusPendingResult;
    }

    private final void zal(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Object object = Common.zaa;
        object = ((zae)object).zaa(googleApiClient);
        zaaw zaaw2 = new zaaw(this, statusPendingResult, bl, googleApiClient);
        ((PendingResult)object).setResultCallback(zaaw2);
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        if (((zaaz)object).zam < 0) {
            Object object = new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
            throw object;
        }
        com.google.android.gms.common.api.internal.zak.zaa(lifecycleActivity).zac(((zaaz)object).zam);
    }

    @Override
    public final boolean isConnected() {
        zabu zabu2 = ((zaaz)((Object)zabu2)).zal;
        return zabu2 != null && zabu2.zai();
    }

    @Override
    public final boolean isConnecting() {
        zabu zabu2 = ((zaaz)((Object)zabu2)).zal;
        return zabu2 != null && zabu2.zaj();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zam(int n) {
        int n2;
        Object object;
        Integer n3 = ((zaaz)object).zaw;
        if (n3 == null) {
            ((zaaz)object).zaw = n;
        } else if (n3 != n) {
            String string2 = zaaz.zag(n);
            object = zaaz.zag(((zaaz)object).zaw);
            int n4 = string2.length();
            int n5 = ((String)object).length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 51 + n5);
            stringBuilder.append("Cannot use sign-in mode: ");
            stringBuilder.append(string2);
            stringBuilder.append(". Mode was already set to ");
            stringBuilder.append((String)object);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        if (((zaaz)object).zal != null) {
            return;
        }
        Iterator<Api.Client> iterator = ((zaaz)object).zac.values().iterator();
        n = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            Api.Client client = iterator.next();
            n = client.requiresSignIn() | n;
            n2 = client.providesSignIn() | n2;
        }
        switch (((zaaz)object).zaw) {
            case 1: {
                if (n == 0) {
                    object = new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                    throw object;
                }
                if (n2 == false) break;
                object = new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
                throw object;
            }
            case 2: {
                if (n == 0) break;
                ((zaaz)object).zal = com.google.android.gms.common.api.internal.zax.zaa(((zaaz)object).zan, (zaaz)object, ((zaaz)object).zaj, ((zaaz)object).zao, ((zaaz)object).zat, ((zaaz)object).zac, ((zaaz)object).zae, ((zaaz)object).zaf, ((zaaz)object).zag, ((zaaz)object).zav);
                return;
            }
        }
        zabd zabd2 = new zabd(((zaaz)object).zan, (zaaz)object, ((zaaz)object).zaj, ((zaaz)object).zao, ((zaaz)object).zat, ((zaaz)object).zac, ((zaaz)object).zae, ((zaaz)object).zaf, ((zaaz)object).zag, ((zaaz)object).zav, (zabt)object);
        ((zaaz)object).zal = zabd2;
    }

    @GuardedBy(value="mLock")
    private final void zan() {
        this.zak.zab();
        ((zabu)Preconditions.checkNotNull((Object)this.zal)).zae();
    }

    @GuardedBy(value="mLock")
    final boolean zad() {
        if (!this.zap) {
            return false;
        }
        this.zap = false;
        this.zas.removeMessages(2);
        this.zas.removeMessages(1);
        zabr zabr2 = this.zab;
        if (zabr2 != null) {
            zabr2.zab();
            this.zab = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zaf(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zak.zag(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zah(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zai(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zak.zaj(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zak(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(@Nullable Bundle bundle) {
        while (!this.zaa.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zaa.remove());
        }
        this.zak.zac(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(ConnectionResult connectionResult) {
        if (!this.zat.isPlayServicesPossiblyUpdating(this.zan, connectionResult.getErrorCode())) {
            this.zad();
        }
        if (!this.zap) {
            this.zak.zae(connectionResult);
            this.zak.zaa();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GuardedBy(value="mLock")
    public final void zac(int n, boolean n2) {
        block5: {
            block4: {
                block6: {
                    block7: {
                        if (n != 1) break block5;
                        if (n2 != 0) break block6;
                        if (!this.zap) break block7;
                        n = 1;
                        break block5;
                    }
                    this.zap = true;
                    if (this.zab != null || ClientLibraryUtils.isPackageSide()) break block4;
                    try {
                        GoogleApiAvailability googleApiAvailability = this.zat;
                        Context context = this.zan;
                        context = context.getApplicationContext();
                        zaay zaay2 = new zaay(this);
                        this.zab = googleApiAvailability.zae(context, zaay2);
                        break block4;
                    }
                    catch (SecurityException securityException) {}
                }
                n = 1;
                break block5;
            }
            zaax zaax2 = this.zas;
            zaax2.sendMessageDelayed(zaax2.obtainMessage(1), this.zaq);
            zaax2 = this.zas;
            zaax2.sendMessageDelayed(zaax2.obtainMessage(2), this.zar);
            n = 1;
        }
        BasePendingResult[] basePendingResultArray = this.zai.zab.toArray(new BasePendingResult[0]);
        int n3 = basePendingResultArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            basePendingResultArray[n2].forceFailureUnlessReady(zacx.zaa);
        }
        this.zak.zad(n);
        this.zak.zaa();
        if (n == 2) {
            this.zan();
            return;
        }
    }

    @Override
    public final Context getContext() {
        return this.zan;
    }

    @Override
    public final Looper getLooper() {
        return this.zao;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        zabu zabu2 = ((zaaz)((Object)zabu2)).zal;
        return zabu2 != null && zabu2.zak(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        zabu zabu2 = ((zaaz)((Object)zabu2)).zal;
        if (zabu2 != null) {
            zabu2.zam();
            return;
        }
    }

    @Override
    public final void zao(zacv zacv2) {
        this.zaj.lock();
        try {
            HashSet<zacv> hashSet = this.zah;
            if (hashSet == null) {
                hashSet = new HashSet<zacv>();
                this.zah = hashSet;
            }
            this.zah.add(zacv2);
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zap(zacv object) {
        zabu zabu2;
        block12: {
            Set<zacv> set;
            block11: {
                this.zaj.lock();
                Set<zacv> set2 = this.zah;
                if (set2 == null) {
                    object = new Exception();
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)object);
                    return;
                }
                boolean bl = set2.remove(object);
                if (!bl) {
                    Exception exception = new Exception();
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)exception);
                    return;
                }
                this.zaj.lock();
                set = this.zah;
                if (set != null) break block11;
                {
                    catch (Throwable throwable) {
                        this.zaj.unlock();
                        throw throwable;
                    }
                }
                this.zaj.unlock();
                break block12;
            }
            boolean bl = set.isEmpty();
            bl ^= true;
            this.zaj.unlock();
            if (bl) return;
        }
        if ((zabu2 = this.zal) == null) return;
        zabu2.zal();
        return;
        finally {
            this.zaj.unlock();
        }
    }

    final String zae() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dump("", null, printWriter, null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(((zaaz)((Object)zabu2)).zan);
        printWriter.append(string2).append("mResuming=").print(((zaaz)((Object)zabu2)).zap);
        printWriter.append(" mWorkQueue.size()=").print(((zaaz)((Object)zabu2)).zaa.size());
        zacx zacx2 = ((zaaz)((Object)zabu2)).zai;
        printWriter.append(" mUnconsumedApiCalls.size()=").println(zacx2.zab.size());
        zabu zabu2 = ((zaaz)((Object)zabu2)).zal;
        if (zabu2 != null) {
            zabu2.zan(string2, fileDescriptor, printWriter, stringArray);
            return;
        }
    }

    public static int zaf(Iterable<Api.Client> iterable, boolean bl) {
        Iterator<Api.Client> iterator = iterable.iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            Api.Client client = iterator.next();
            bl2 = client.requiresSignIn() | bl2;
            bl3 = client.providesSignIn() | bl3;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zag(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
            case 1: 
        }
        return "SIGN_IN_MODE_REQUIRED";
    }

    static /* synthetic */ void zah(zaaz zaaz2) {
        block4: {
            zaaz2.zaj.lock();
            boolean bl = zaaz2.zap;
            if (!bl) break block4;
            try {
                zaaz2.zan();
            }
            finally {
                zaaz2.zaj.unlock();
            }
        }
    }

    static /* synthetic */ void zai(zaaz zaaz2) {
        block4: {
            zaaz2.zaj.lock();
            boolean bl = zaaz2.zad();
            if (!bl) break block4;
            try {
                zaaz2.zan();
            }
            finally {
                zaaz2.zaj.unlock();
            }
        }
    }

    static /* synthetic */ void zaj(zaaz zaaz2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaaz2.zal(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zak(zaaz zaaz2) {
        return zaaz2.zan;
    }
}

