/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabi;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zacc;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabl<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zat {
    private final Queue<zai> zab;
    @NotOnlyInitialized
    private final Api.Client zac;
    private final ApiKey<O> zad;
    private final zaaa zae;
    private final Set<zal> zaf;
    private final Map<ListenerHolder.ListenerKey<?>, zacc> zag;
    private final int zah;
    @Nullable
    private final zaco zai;
    private boolean zaj;
    private final List<zabm> zak;
    @Nullable
    private ConnectionResult zal;
    private int zam;
    final /* synthetic */ GoogleApiManager zaa;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zabl(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        this.zaa = googleApiManager;
        Object object = new LinkedList();
        this.zab = object;
        this.zaf = object;
        super();
        this.zag = object;
        super();
        this.zak = object;
        this.zal = null;
        this.zam = 0;
        this.zac = googleApi.zaa(GoogleApiManager.zas(googleApiManager).getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = object = new zaaa();
        this.zah = googleApi.zab();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(GoogleApiManager.zat(googleApiManager), GoogleApiManager.zas(googleApiManager));
            return;
        }
        this.zai = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle object) {
        if (Looper.myLooper() == GoogleApiManager.zas(this.zaa).getLooper()) {
            this.zaB();
            return;
        }
        object = this.zaa;
        object = GoogleApiManager.zas((GoogleApiManager)object);
        zabh zabh2 = new zabh(this);
        object.post((Runnable)zabh2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaB() {
        this.zah();
        this.zaM(ConnectionResult.RESULT_SUCCESS);
        this.zaJ();
        Iterator<zacc> iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.zaN(((zacc)object).zaa.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                object = ((zacc)object).zaa;
                Api.Client client = this.zac;
                TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
                ((RegisterListenerMethod)object).registerListener(client, (TaskCompletionSource<Void>)taskCompletionSource);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException remoteException) {
                iterator.remove();
            }
        }
        this.zaE();
        this.zaK();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == GoogleApiManager.zas(this.zaa).getLooper()) {
            this.zaC(n);
            return;
        }
        GoogleApiManager googleApiManager = this.zaa;
        googleApiManager = GoogleApiManager.zas(googleApiManager);
        zabi zabi2 = new zabi(this, n);
        googleApiManager.post(zabi2);
    }

    @WorkerThread
    private final void zaC(int n) {
        ((zabl)((Object)iterator)).zah();
        ((zabl)((Object)iterator)).zaj = true;
        ((zabl)((Object)iterator)).zae.zae(n, ((zabl)((Object)iterator)).zac.getLastDisconnectMessage());
        GoogleApiManager.zas(((zabl)((Object)iterator)).zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(((zabl)((Object)iterator)).zaa), (int)9, ((zabl)((Object)iterator)).zad), GoogleApiManager.zau(((zabl)((Object)iterator)).zaa));
        GoogleApiManager.zas(((zabl)((Object)iterator)).zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(((zabl)((Object)iterator)).zaa), (int)11, ((zabl)((Object)iterator)).zad), GoogleApiManager.zav(((zabl)((Object)iterator)).zaa));
        GoogleApiManager.zaw(((zabl)((Object)iterator)).zaa).zac();
        Iterator<zacc> iterator = ((zabl)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zacc)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zab(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        String string4 = String.valueOf(string2);
        int n = string4.length();
        String string5 = String.valueOf(string3);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 25 + n2);
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zac(connectionResult, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaD(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zax();
        synchronized (object) {
            zaab zaab2 = GoogleApiManager.zay(this.zaa);
            if (zaab2 == null) return false;
            boolean bl = GoogleApiManager.zaz(this.zaa).contains(this.zad);
            if (!bl) return false;
            GoogleApiManager.zay(this.zaa).zaf(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        throw null;
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zac(connectionResult, null);
    }

    @WorkerThread
    public final void zac(@NonNull ConnectionResult connectionResult, @Nullable Exception exception) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        zaco zaco2 = this.zai;
        if (zaco2 != null) {
            zaco2.zad();
        }
        this.zah();
        GoogleApiManager.zaw(this.zaa).zac();
        this.zaM(connectionResult);
        if (this.zac instanceof zap && connectionResult.getErrorCode() != 24) {
            GoogleApiManager.zaA(this.zaa, true);
            GoogleApiManager.zas(this.zaa).sendMessageDelayed(GoogleApiManager.zas(this.zaa).obtainMessage(19), 300000L);
        }
        if (connectionResult.getErrorCode() == 4) {
            this.zaI(GoogleApiManager.zaB());
            return;
        }
        if (this.zab.isEmpty()) {
            this.zal = connectionResult;
            return;
        }
        if (exception != null) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
            this.zaH(null, exception, false);
            return;
        }
        if (GoogleApiManager.zaC(this.zaa)) {
            this.zaH(GoogleApiManager.zaF(this.zad, connectionResult), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zaD(connectionResult)) {
                return;
            }
            if (!this.zaa.zap(connectionResult, this.zah)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaj = true;
                }
                if (this.zaj) {
                    GoogleApiManager.zas(this.zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(this.zaa), (int)9, this.zad), GoogleApiManager.zau(this.zaa));
                    return;
                }
                this.zaI(GoogleApiManager.zaF(this.zad, connectionResult));
                return;
            }
            return;
        }
        this.zaI(GoogleApiManager.zaF(this.zad, connectionResult));
    }

    @WorkerThread
    private final void zaE() {
        ArrayList<zai> arrayList = new ArrayList<zai>(this.zab);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaF(zai2)) {
                this.zab.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    public final void zad(zai zai2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        if (this.zac.isConnected()) {
            if (this.zaF(zai2)) {
                this.zaK();
                return;
            }
            this.zab.add(zai2);
            return;
        }
        this.zab.add(zai2);
        zai2 = this.zal;
        if (zai2 != null && zai2.hasResolution()) {
            this.zac(this.zal, null);
            return;
        }
        this.zam();
    }

    @WorkerThread
    public final void zae() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        this.zaI(GoogleApiManager.zaa);
        this.zae.zad();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            zah zah2 = new zah(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
            this.zad(zah2);
        }
        Object object = new ConnectionResult(4);
        this.zaM((ConnectionResult)object);
        if (this.zac.isConnected()) {
            object = this.zac;
            zabk zabk2 = new zabk(this);
            object.onUserSignOut(zabk2);
            return;
        }
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    public final Map<ListenerHolder.ListenerKey<?>, zacc> zag() {
        return this.zag;
    }

    @WorkerThread
    public final void zah() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        this.zal = null;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zai() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        return this.zal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final boolean zaF(zai object) {
        if (!(object instanceof zac)) {
            zabl2.zaG((zai)object);
            return true;
        }
        zac zac2 = (zac)object;
        Feature feature = zabl2.zaN(zac2.zaa(zabl2));
        if (feature == null) {
            zabl2.zaG((zai)object);
            return true;
        }
        object = zabl2.zac.getClass().getName();
        String string2 = feature.getName();
        long l = feature.getVersion();
        String string3 = String.valueOf(object);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 77 + n2);
        stringBuilder.append((String)object);
        stringBuilder.append(" could not execute call because it requires feature (");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        Log.w((String)"GoogleApiManager", (String)stringBuilder.toString());
        if (GoogleApiManager.zaC(zabl2.zaa) && zac2.zab(zabl2)) {
            object = new zabm(zabl2.zad, feature, null);
            int n3 = zabl2.zak.indexOf(object);
            if (n3 >= 0) {
                object = zabl2.zak.get(n3);
                GoogleApiManager.zas(zabl2.zaa).removeMessages(15, object);
                GoogleApiManager.zas(zabl2.zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(zabl2.zaa), (int)15, (Object)object), GoogleApiManager.zau(zabl2.zaa));
                return false;
            }
            zabl2.zak.add((zabm)object);
            GoogleApiManager.zas(zabl2.zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(zabl2.zaa), (int)15, (Object)object), GoogleApiManager.zau(zabl2.zaa));
            GoogleApiManager.zas(zabl2.zaa).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zas(zabl2.zaa), (int)16, (Object)object), GoogleApiManager.zav(zabl2.zaa));
            object = new ConnectionResult(2, null);
            if (zabl2.zaD((ConnectionResult)object)) return false;
            zabl2.zaa.zap((ConnectionResult)object, zabl2.zah);
            return false;
        }
        zabl zabl2 = new UnsupportedApiCallException(feature);
        zac2.zad((Exception)((Object)zabl2));
        return true;
    }

    @WorkerThread
    private final void zaG(zai zai2) {
        zai2.zae(((zabl)((Object)string2)).zae, ((zabl)((Object)string2)).zap());
        try {
            zai2.zaf((zabl<?>)((Object)string2));
            return;
        }
        catch (Throwable throwable) {
            Object object = new Object[]{((zabl)((Object)string2)).zac.getClass().getName()};
            String string2 = String.format("Error in GoogleApi implementation for client %s.", object);
            object = new IllegalStateException(string2, throwable);
            throw object;
        }
        catch (DeadObjectException deadObjectException) {
            ((zabl)((Object)string2)).onConnectionSuspended(1);
            ((zabl)((Object)string2)).zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaH(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Iterator iterator;
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(((zabl)((Object)iterator)).zaa));
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            iterator = new Iterator("Status XOR exception should be null");
            throw iterator;
        }
        iterator = ((zabl)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zac(status);
            } else {
                zai2.zad(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaI(Status status) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        this.zaH(status, null, false);
    }

    @WorkerThread
    public final void zaj() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        if (this.zaj) {
            this.zam();
            return;
        }
    }

    @WorkerThread
    private final void zaJ() {
        if (this.zaj) {
            GoogleApiManager.zas(this.zaa).removeMessages(11, this.zad);
            GoogleApiManager.zas(this.zaa).removeMessages(9, this.zad);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zak() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        if (!this.zaj) {
            return;
        }
        this.zaJ();
        Status status = GoogleApiManager.zaD(this.zaa).isGooglePlayServicesAvailable(GoogleApiManager.zat(this.zaa)) == 18 ? new Status(21, "Connection timed out waiting for Google Play services update to complete.") : new Status(22, "API failed to connect while resuming due to an unknown error.");
        this.zaI(status);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    private final void zaK() {
        GoogleApiManager.zas(this.zaa).removeMessages(12, this.zad);
        GoogleApiManager.zas(this.zaa).sendMessageDelayed(GoogleApiManager.zas(this.zaa).obtainMessage(12, this.zad), GoogleApiManager.zaE(this.zaa));
    }

    @WorkerThread
    public final boolean zal() {
        return this.zaL(true);
    }

    @WorkerThread
    private final boolean zaL(boolean bl) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        if (this.zac.isConnected() && this.zag.size() == 0) {
            if (this.zae.zac()) {
                if (bl) {
                    this.zaK();
                }
                return false;
            }
            this.zac.disconnect("Timing out service connection.");
            return true;
        }
        return false;
    }

    @WorkerThread
    public final void zam() {
        block9: {
            ConnectionResult connectionResult;
            int n;
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                n = GoogleApiManager.zaw(this.zaa).zaa(GoogleApiManager.zat(this.zaa), this.zac);
                if (n == 0) break block9;
            }
            catch (IllegalStateException illegalStateException) {
                connectionResult = new ConnectionResult(10);
                this.zac(connectionResult, illegalStateException);
                return;
            }
            connectionResult = new ConnectionResult(n, null);
            String string2 = "GoogleApiManager";
            String string3 = this.zac.getClass().getName();
            String string4 = String.valueOf(connectionResult);
            int n2 = String.valueOf(string3).length();
            n2 += 35;
            int n3 = String.valueOf(string4).length();
            n2 += n3;
            StringBuilder stringBuilder = new StringBuilder(n2);
            stringBuilder.append("The service for ");
            stringBuilder.append(string3);
            stringBuilder.append(" is not available: ");
            stringBuilder.append(string4);
            Log.w((String)string2, (String)stringBuilder.toString());
            this.zac(connectionResult, null);
            return;
        }
        zabo zabo2 = new zabo(this.zaa, this.zac, this.zad);
        if (this.zac.requiresSignIn()) {
            ((zaco)Preconditions.checkNotNull((Object)this.zai)).zac(zabo2);
        }
        try {
            this.zac.connect(zabo2);
            return;
        }
        catch (SecurityException securityException) {
            ConnectionResult connectionResult = new ConnectionResult(10);
            this.zac(connectionResult, securityException);
            return;
        }
    }

    @WorkerThread
    public final void zan(zal zal2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zas(this.zaa));
        this.zaf.add(zal2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaM(ConnectionResult connectionResult) {
        Iterator<zal> iterator = this.zaf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zaf.clear();
                return;
            }
            zal zal2 = iterator.next();
            String string2 = Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    final boolean zao() {
        return this.zac.isConnected();
    }

    public final boolean zap() {
        return this.zac.requiresSignIn();
    }

    public final int zaq() {
        return this.zah;
    }

    @WorkerThread
    @Nullable
    private final Feature zaN(@Nullable Feature[] featureArray) {
        Object object;
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        int n = featureArray2.length;
        ArrayMap arrayMap = new ArrayMap(n);
        for (int i = 0; i < n; ++i) {
            object = featureArray2[i];
            arrayMap.put(object.getName(), object.getVersion());
        }
        for (Feature feature : featureArray) {
            object = (Long)arrayMap.get(feature.getName());
            if (object != null && (Long)object >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    @WorkerThread
    final int zar() {
        return this.zam;
    }

    @WorkerThread
    final void zas() {
        ++this.zam;
    }

    static /* synthetic */ boolean zat(zabl zabl2, boolean bl) {
        return zabl2.zaL(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zau(zabl zabl2, zabm zabm2) {
        if (!zabl2.zak.contains(zabm2) || zabl2.zaj) {
            return;
        }
        if (!zabl2.zac.isConnected()) {
            zabl2.zam();
            return;
        }
        zabl2.zaE();
    }

    static /* synthetic */ void zav(zabl zabl2, zabm object) {
        if (zabl2.zak.remove(object)) {
            Object[] objectArray;
            GoogleApiManager.zas(zabl2.zaa).removeMessages(15, object);
            GoogleApiManager.zas(zabl2.zaa).removeMessages(16, object);
            Feature feature = zabm.zab((zabm)object);
            ArrayList<zai> arrayList = new ArrayList<zai>(zabl2.zab.size());
            for (zai zai2 : zabl2.zab) {
                if (!(zai2 instanceof zac) || (objectArray = ((zac)zai2).zaa(zabl2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                objectArray = (zai)arrayList.get(i);
                zabl2.zab.remove(objectArray);
                UnsupportedApiCallException unsupportedApiCallException = new UnsupportedApiCallException(feature);
                objectArray.zad((Exception)unsupportedApiCallException);
            }
        }
    }

    static /* synthetic */ void zaw(zabl zabl2, Status status) {
        zabl2.zaI(status);
    }

    static /* synthetic */ ApiKey zax(zabl zabl2) {
        return zabl2.zad;
    }

    static /* synthetic */ void zay(zabl zabl2) {
        zabl2.zaB();
    }

    static /* synthetic */ void zaz(zabl zabl2, int n) {
        zabl2.zaC(n);
    }

    static /* synthetic */ Api.Client zaA(zabl zabl2) {
        return zabl2.zac;
    }
}

