/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zat;
import com.google.android.gms.signin.internal.zae;
import com.google.android.gms.signin.internal.zaf;
import com.google.android.gms.signin.internal.zai;
import com.google.android.gms.signin.internal.zak;

@KeepForSdk
public class SignInClientImpl
extends GmsClient<zaf>
implements com.google.android.gms.signin.zae {
    private final boolean zab;
    private final ClientSettings zac;
    private final Bundle zad;
    @Nullable
    private final Integer zae;
    public static final /* synthetic */ int zaa;

    public SignInClientImpl(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, boolean bl, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull Bundle bundle, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zab = true;
        this.zac = clientSettings;
        this.zad = bundle;
        this.zae = clientSettings.zad();
    }

    @Override
    public final boolean requiresSignIn() {
        return this.zab;
    }

    @RecentlyNonNull
    protected final String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    @RecentlyNonNull
    protected final String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    @RecentlyNonNull
    protected final Bundle getGetServiceRequestExtraArgs() {
        Object object = this.zac;
        object = ((ClientSettings)object).getRealClientPackageName();
        if (!this.getContext().getPackageName().equals(object)) {
            this.zad.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zac.getRealClientPackageName());
        }
        return this.zad;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Bundle createBundleFromClientSettings(@RecentlyNonNull ClientSettings clientSettings) {
        clientSettings.zac();
        Integer n = clientSettings.zad();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)clientSettings.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", false);
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", false);
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
        bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", false);
        bundle.putString("com.google.android.gms.signin.internal.hostedDomain", null);
        bundle.putString("com.google.android.gms.signin.internal.logSessionId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", false);
        return bundle;
    }

    @Override
    public final int getMinApkVersion() {
        return 12451000;
    }

    @Override
    public final void zab(@RecentlyNonNull IAccountAccessor iAccountAccessor, boolean bl) {
        try {
            zaf zaf2 = (zaf)n.getService();
            Integer n = ((SignInClientImpl)((Object)n)).zae;
            zaf2.zaf(iAccountAccessor, (Integer)Preconditions.checkNotNull((Object)n), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zac() {
        try {
            zaf zaf2 = (zaf)n.getService();
            Integer n = ((SignInClientImpl)((Object)n)).zae;
            zaf2.zae((Integer)Preconditions.checkNotNull((Object)n));
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zaa(zae zae2) {
        Preconditions.checkNotNull((Object)zae2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            void var2_8;
            Account account = ((SignInClientImpl)((Object)zaf2)).zac.getAccountOrDefault();
            boolean bl = "<<default account>>".equals(account.name);
            if (bl) {
                Context context = zaf2.getContext();
                GoogleSignInAccount googleSignInAccount = Storage.getInstance(context).getSavedDefaultGoogleSignInAccount();
            } else {
                Object var2_10 = null;
            }
            Integer n = ((SignInClientImpl)((Object)zaf2)).zae;
            zat zat2 = new zat(account, (Integer)Preconditions.checkNotNull((Object)n), (GoogleSignInAccount)var2_8);
            zaf zaf2 = (zaf)zaf2.getService();
            zai zai2 = new zai(1, zat2);
            zaf2.zag(zai2, zae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                zak zak2 = new zak(1, connectionResult, null);
                zae2.zab(zak2);
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    @Override
    public final void zad() {
        BaseGmsClient.LegacyClientCallbackAdapter legacyClientCallbackAdapter = new BaseGmsClient.LegacyClientCallbackAdapter((BaseGmsClient)this);
        this.connect((BaseGmsClient.ConnectionProgressReportCallbacks)legacyClientCallbackAdapter);
    }
}

