/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaj;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zae;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabi
implements zaca,
zau {
    private final Lock zai;
    private final Condition zaj;
    private final Context zak;
    private final GoogleApiAvailabilityLight zal;
    private final zabh zam;
    final Map<Api.AnyClientKey<?>, Api.Client> zaa;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zab;
    @Nullable
    final ClientSettings zac;
    final Map<Api<?>, Boolean> zad;
    @Nullable
    final Api.AbstractClientBuilder<? extends zae, SignInOptions> zae;
    @NotOnlyInitialized
    private volatile zabf zan;
    @Nullable
    private ConnectionResult zao;
    int zaf;
    final zabe zag;
    final zabz zah;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zab() {
        zabi zabi2;
        zabi2.zaq();
        while (zabi2.zan instanceof zaaw) {
            try {
                zabi2.zaj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (zabi2.zan instanceof zaaj) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabi2 = zabi2.zao;
        if (zabi2 == null) return new ConnectionResult(13, null);
        return zabi2;
    }

    /*
     * Loose catch block
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zac(long l, TimeUnit timeUnit) {
        zabi zabi2;
        zabi2.zaq();
        long l2 = timeUnit.toNanos(l);
        while (zabi2.zan instanceof zaaw) {
            long l3;
            if (l2 <= 0L) {
                zabi2.zar();
                zabi2 = new ConnectionResult(14, null);
                return zabi2;
            }
            l2 = l3 = zabi2.zaj.awaitNanos(l2);
        }
        if (zabi2.zan instanceof zaaj) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabi2 = zabi2.zao;
        if (zabi2 != null) {
            return zabi2;
        }
        zabi2 = new ConnectionResult(13, null);
        return zabi2;
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zabi2 = new ConnectionResult(15, null);
            return zabi2;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult zad(@NonNull Api<?> object) {
        if (this.zaa.containsKey(object = ((Api)object).zab())) {
            if (this.zaa.get(object).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zab.containsKey(object)) {
                return this.zab.get(object);
            }
        }
        return null;
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zae(@NonNull T t) {
        t.zak();
        this.zan.zaa(t);
        return t;
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zaf(@NonNull T t) {
        t.zak();
        return this.zan.zab(t);
    }

    static /* bridge */ /* synthetic */ zabf zag(zabi zabi2) {
        return zabi2.zan;
    }

    static /* bridge */ /* synthetic */ Lock zah(zabi zabi2) {
        return zabi2.zai;
    }

    public zabi(Context context, zabe zabe2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, @Nullable ClientSettings clientSettings, Map<Api<?>, Boolean> map2, @Nullable Api.AbstractClientBuilder<? extends zae, SignInOptions> abstractClientBuilder, ArrayList<zat> arrayList, zabz zabz2) {
        Object object;
        HashMap hashMap = new HashMap();
        this.zab = hashMap;
        this.zao = null;
        this.zak = context;
        this.zai = lock;
        this.zal = googleApiAvailabilityLight;
        this.zaa = map;
        this.zac = clientSettings;
        this.zad = map2;
        this.zae = abstractClientBuilder;
        this.zag = zabe2;
        this.zah = zabz2;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((zat)arrayList.get(i)).zaa(this);
        }
        this.zam = object = new zabh(this, looper);
        this.zaj = lock.newCondition();
        super(this);
        this.zan = object;
    }

    final void zai() {
        this.zai.lock();
        try {
            this.zag.zak();
            zaaj zaaj2 = new zaaj(this);
            this.zan = zaaj2;
            this.zan.zad();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zaj() {
        this.zai.lock();
        try {
            zaaw zaaw2 = new zaaw(this, this.zac, this.zad, this.zal, this.zae, this.zai, this.zak);
            this.zan = zaaw2;
            this.zan.zad();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zak(@Nullable ConnectionResult object) {
        this.zai.lock();
        try {
            this.zao = object;
            object = new zaax(this);
            this.zan = object;
            this.zan.zad();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaq() {
        this.zan.zae();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zar() {
        if (this.zan.zaj()) {
            this.zab.clear();
            return;
        }
    }

    @Override
    public final void zas(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zan);
        for (Api<?> api : this.zad.keySet()) {
            printWriter.append(string2).append(api.zad()).println(":");
            ((Api.Client)Preconditions.checkNotNull((Object)this.zaa.get(api.zab()))).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zat() {
        if (this.zan instanceof zaaj) {
            ((zaaj)this.zan).zaf();
            return;
        }
    }

    @Override
    public final void zau() {
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zai.lock();
        try {
            this.zan.zag(bundle);
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zai.lock();
        try {
            this.zan.zah(connectionResult, api, bl);
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zai.lock();
        try {
            this.zan.zai(n);
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zal(zabg zabg2) {
        zabh zabh2 = this.zam;
        zabg2 = zabh2.obtainMessage(1, zabg2);
        this.zam.sendMessage((Message)zabg2);
    }

    final void zam(RuntimeException runtimeException) {
        zabh zabh2 = this.zam;
        runtimeException = zabh2.obtainMessage(2, runtimeException);
        this.zam.sendMessage((Message)runtimeException);
    }

    @Override
    public final boolean zaw() {
        return this.zan instanceof zaaj;
    }

    @Override
    public final boolean zax() {
        return this.zan instanceof zaaw;
    }

    @Override
    public final boolean zay(SignInConnectionListener signInConnectionListener) {
        return false;
    }
}

