/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.internal.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class AvailabilityException
extends Exception {
    private final ArrayMap zaa;

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull GoogleApi<? extends Api.ApiOptions> api) {
        ApiKey<? extends Api.ApiOptions> apiKey = api.getApiKey();
        Object object = this.zaa.get(apiKey);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The given API (");
        stringBuilder.append(apiKey.zaa());
        stringBuilder.append(") was not part of the availability request.");
        String string2 = stringBuilder.toString();
        boolean bl = object != null;
        Preconditions.checkArgument((boolean)bl, (Object)string2);
        return (ConnectionResult)Preconditions.checkNotNull((Object)((ConnectionResult)this.zaa.get(apiKey)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull HasApiKey<? extends Api.ApiOptions> api) {
        ApiKey<? extends Api.ApiOptions> apiKey = api.getApiKey();
        Object object = this.zaa.get(apiKey);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The given API (");
        stringBuilder.append(apiKey.zaa());
        stringBuilder.append(") was not part of the availability request.");
        String string2 = stringBuilder.toString();
        boolean bl = object != null;
        Preconditions.checkArgument((boolean)bl, (Object)string2);
        return (ConnectionResult)Preconditions.checkNotNull((Object)((ConnectionResult)this.zaa.get(apiKey)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNull
    public String getMessage() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = ((AvailabilityException)serializable).zaa.keySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ApiKey apiKey = (ApiKey)iterator.next();
            ConnectionResult connectionResult = (ConnectionResult)Preconditions.checkNotNull((Object)((ConnectionResult)((AvailabilityException)serializable).zaa.get((Object)apiKey)));
            boolean bl2 = (connectionResult.isSuccess() ^ true) & bl;
            String string2 = apiKey.zaa();
            String string3 = String.valueOf(connectionResult);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(": ");
            stringBuilder.append(string3);
            arrayList.add(stringBuilder.toString());
            bl = bl2;
        }
        Serializable serializable = new StringBuilder();
        if (bl) {
            ((StringBuilder)serializable).append("None of the queried APIs are available. ");
        } else {
            ((StringBuilder)serializable).append("Some of the queried APIs are unavailable. ");
        }
        ((StringBuilder)serializable).append(TextUtils.join((CharSequence)"; ", arrayList));
        return ((StringBuilder)serializable).toString();
    }

    public AvailabilityException(@NonNull ArrayMap arrayMap) {
        this.zaa = arrayMap;
    }
}

