/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.internal.zacf;
import com.google.android.gms.common.api.internal.zacg;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zau;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public final class NonGmsServiceBrokerClient
implements Api.Client,
ServiceConnection {
    private static final String zaa = NonGmsServiceBrokerClient.class.getSimpleName();
    @Nullable
    private final String zab;
    @Nullable
    private final String zac;
    @Nullable
    private final ComponentName zad;
    private final Context zae;
    private final ConnectionCallbacks zaf;
    private final Handler zag;
    private final OnConnectionFailedListener zah;
    @Nullable
    private IBinder zai;
    private boolean zaj;
    @Nullable
    private String zak;
    @Nullable
    private String zal;

    @Override
    public final int getMinApkVersion() {
        return 0;
    }

    @Override
    @NonNull
    public final Intent getSignInIntent() {
        return new Intent();
    }

    @WorkerThread
    @Nullable
    @KeepForSdk
    public IBinder getBinder() {
        this.zad();
        return this.zai;
    }

    @Override
    @Nullable
    public final IBinder getServiceBrokerBinder() {
        return null;
    }

    @Override
    @NonNull
    public final String getEndpointPackageName() {
        String string2 = this.zab;
        if (string2 != null) {
            return string2;
        }
        Preconditions.checkNotNull((Object)this.zad);
        return this.zad.getPackageName();
    }

    @Override
    @Nullable
    public final String getLastDisconnectMessage() {
        return this.zak;
    }

    @Override
    @NonNull
    public final Set<Scope> getScopesForConnectionlessNonSignIn() {
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull ComponentName componentName, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, null, null, (ComponentName)var3_3, (ConnectionCallbacks)var4_4, (OnConnectionFailedListener)var5_5);
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull String packageName, @NonNull String action, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, (String)var3_3, (String)var4_4, null, (ConnectionCallbacks)var5_5, (OnConnectionFailedListener)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private NonGmsServiceBrokerClient(Context context, Looper looper, @Nullable String string2, @Nullable String string3, @Nullable ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        block3: {
            block4: {
                block2: {
                    this.zaj = false;
                    this.zak = null;
                    this.zae = context;
                    this.zag = new zau(looper);
                    this.zaf = connectionCallbacks;
                    this.zah = onConnectionFailedListener;
                    if (string2 == null || string3 == null) break block2;
                    if (componentName != null) break block3;
                    componentName = null;
                    break block4;
                }
                if (componentName == null) break block3;
            }
            this.zab = string2;
            this.zac = string3;
            this.zad = componentName;
            return;
        }
        throw new AssertionError((Object)"Must specify either package or component, but not both");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        block8: {
            this.zad();
            String.valueOf(this.zai);
            if (this.isConnected()) {
                try {
                    this.disconnect("connect() called when already connected");
                }
                catch (Exception exception) {}
            }
            try {
                boolean bl;
                connectionProgressReportCallbacks = new Intent();
                ComponentName componentName = this.zad;
                if (componentName != null) {
                    connectionProgressReportCallbacks.setComponent(componentName);
                } else {
                    connectionProgressReportCallbacks.setPackage(this.zab).setAction(this.zac);
                }
                this.zaj = bl = this.zae.bindService((Intent)connectionProgressReportCallbacks, (ServiceConnection)this, GmsClientSupervisor.getDefaultBindFlags());
                if (bl) break block8;
                this.zai = null;
            }
            catch (SecurityException securityException) {
                this.zaj = false;
                this.zai = null;
                throw securityException;
            }
            this.zah.onConnectionFailed(new ConnectionResult(16));
        }
        String.valueOf(this.zai);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void disconnect() {
        this.zad();
        String.valueOf(this.zai);
        try {
            this.zae.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.zaj = false;
        this.zai = null;
    }

    @Override
    @WorkerThread
    public final void disconnect(@NonNull String string2) {
        this.zad();
        this.zak = string2;
        this.disconnect();
    }

    @Override
    public final void dump(@NonNull String string2, @Nullable FileDescriptor fileDescriptor, @NonNull PrintWriter printWriter, @Nullable String[] stringArray) {
    }

    @Override
    public final void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
    }

    public final void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
        this.zag.post((Runnable)new zacg(this, iBinder));
    }

    public final void onServiceDisconnected(@NonNull ComponentName componentName) {
        this.zag.post((Runnable)new zacf(this));
    }

    @Override
    public final void onUserSignOut(@NonNull BaseGmsClient.SignOutCallbacks signOutCallbacks) {
    }

    @Override
    @WorkerThread
    public final boolean isConnected() {
        this.zad();
        return this.zai != null;
    }

    @Override
    @WorkerThread
    public final boolean isConnecting() {
        this.zad();
        return this.zaj;
    }

    @Override
    public final boolean providesSignIn() {
        return false;
    }

    @Override
    public final boolean requiresAccount() {
        return false;
    }

    @Override
    public final boolean requiresGooglePlayServices() {
        return false;
    }

    @Override
    public final boolean requiresSignIn() {
        return false;
    }

    @Override
    @NonNull
    public final Feature[] getAvailableFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @WorkerThread
    private final void zad() {
        if (Thread.currentThread() != this.zag.getLooper().getThread()) {
            throw new IllegalStateException("This method should only run on the NonGmsServiceBrokerClient's handler thread.");
        }
    }

    final /* synthetic */ void zaa(IBinder iBinder) {
        this.zaj = false;
        this.zai = iBinder;
        String.valueOf(this.zai);
        this.zaf.onConnected(new Bundle());
    }

    final /* synthetic */ void zab() {
        this.zaj = false;
        this.zai = null;
        String.valueOf(this.zai);
        this.zaf.onConnectionSuspended(1);
    }

    public final void zac(@Nullable String string2) {
        this.zal = string2;
    }
}

