/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.moduleinstall;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.moduleinstall.zae;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Class(creator="ModuleInstallStatusUpdateCreator")
public class ModuleInstallStatusUpdate
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ModuleInstallStatusUpdate> CREATOR = new zae();
    @SafeParcelable.Field(id=1, getter="getSessionId")
    private final int zaa;
    @InstallState
    @SafeParcelable.Field(id=2, getter="getInstallState")
    private final int zab;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getBytesDownloaded")
    private final Long zac;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getTotalBytesToDownload")
    private final Long zad;
    @SafeParcelable.Field(id=5, getter="getErrorCode")
    private final int zae;
    @Nullable
    private final ProgressInfo zaf;

    public int getErrorCode() {
        return this.zae;
    }

    @InstallState
    public int getInstallState() {
        return this.zab;
    }

    public int getSessionId() {
        return this.zaa;
    }

    @Nullable
    public ProgressInfo getProgressInfo() {
        return this.zaf;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @SafeParcelable.Constructor
    public ModuleInstallStatusUpdate(@SafeParcelable.Param(id=1) int sessionId, @SafeParcelable.Param(id=2) @InstallState int installState, @Nullable @SafeParcelable.Param(id=3) Long bytesDownloaded, @Nullable @SafeParcelable.Param(id=4) Long totalBytesToDownload, @SafeParcelable.Param(id=5) int errorCode) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaa = var1_1;
        this.zab = var2_2;
        this.zac = var3_3;
        this.zad = var4_4;
        this.zae = var5_5;
        if (var3_3 != null && var4_4 != null && var4_4.longValue() != 0L) {
            this.zaf = new ProgressInfo(var3_3.longValue(), var4_4.longValue());
            return;
        }
        this.zaf = null;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getSessionId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getInstallState());
        SafeParcelWriter.writeLongObject((Parcel)var1_1, (int)3, (Long)this.zac, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)var1_1, (int)4, (Long)this.zad, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)5, (int)this.getErrorCode());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public static class ProgressInfo {
        private final long zaa;
        private final long zab;

        public long getBytesDownloaded() {
            return this.zaa;
        }

        public long getTotalBytesToDownload() {
            return this.zab;
        }

        ProgressInfo(long l, long l2) {
            Preconditions.checkNotZero((long)l2);
            this.zaa = l;
            this.zab = l2;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface InstallState {
        public static final int STATE_UNKNOWN = 0;
        public static final int STATE_PENDING = 1;
        public static final int STATE_DOWNLOADING = 2;
        public static final int STATE_CANCELED = 3;
        public static final int STATE_COMPLETED = 4;
        public static final int STATE_FAILED = 5;
        public static final int STATE_INSTALLING = 6;
        public static final int STATE_DOWNLOAD_PAUSED = 7;
    }
}

