/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.NonGmsServiceBrokerClient;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.zad;
import com.google.android.gms.common.api.zae;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context zab;
    @Nullable
    private final String zac;
    private final Api zad;
    private final Api.ApiOptions zae;
    private final ApiKey zaf;
    private final Looper zag;
    private final int zah;
    @NotOnlyInitialized
    private final GoogleApiClient zai;
    private final StatusExceptionMapper zaj;
    @NonNull
    protected final GoogleApiManager zaa;

    @KeepForSdk
    @NonNull
    public Context getApplicationContext() {
        return this.zab;
    }

    @KeepForSdk
    @NonNull
    public Looper getLooper() {
        return this.zag;
    }

    @KeepForSdk
    @NonNull
    public O getApiOptions() {
        return (O)this.zae;
    }

    @KeepForSdk
    @NonNull
    public GoogleApiClient asGoogleApiClient() {
        return this.zai;
    }

    @Override
    @NonNull
    public final ApiKey<O> getApiKey() {
        return this.zaf;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(2, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@NonNull T methodImpl) {
        void var1_1;
        this.zad(0, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(1, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <L> ListenerHolder<L> registerListener(@NonNull L listener, @NonNull String listenerType) {
        void var2_2;
        return ListenerHolders.createListenerHolder(listener, this.zag, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    protected ClientSettings.Builder createClientSettingsBuilder() {
        void var1_9;
        void var1_5;
        GoogleSignInAccount googleSignInAccount;
        ClientSettings.Builder builder = new ClientSettings.Builder();
        Api.ApiOptions apiOptions = this.zae;
        if (apiOptions instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions).getGoogleSignInAccount()) != null) {
            Account account = googleSignInAccount.getAccount();
        } else {
            Api.ApiOptions apiOptions2 = this.zae;
            if (apiOptions2 instanceof Api.ApiOptions.HasAccountOptions) {
                Account account = ((Api.ApiOptions.HasAccountOptions)apiOptions2).getAccount();
            } else {
                Object var1_15 = null;
            }
        }
        builder.zab((Account)var1_5);
        Api.ApiOptions apiOptions3 = this.zae;
        if (apiOptions3 instanceof Api.ApiOptions.HasGoogleSignInAccountOptions) {
            GoogleSignInAccount googleSignInAccount2 = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions3).getGoogleSignInAccount();
            if (googleSignInAccount2 == null) {
                Set set = Collections.emptySet();
            } else {
                Set<Scope> set = googleSignInAccount2.getRequestedScopes();
            }
        } else {
            Set set = Collections.emptySet();
        }
        builder.zaa((Collection)var1_9);
        builder.zac(this.zab.getClass().getName());
        builder.setRealClientPackageName(this.zab.getPackageName());
        return builder;
    }

    @KeepForSdk
    @NonNull
    protected Task<Boolean> disconnectService() {
        return this.zaa.zan(this);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(2, (TaskApiCall)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(0, (TaskApiCall)var1_1);
    }

    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@NonNull RegistrationMethods<A, ?> methods) {
        Runnable runnable;
        Preconditions.checkNotNull(methods);
        Preconditions.checkNotNull(((RegistrationMethods)((Object)runnable)).register.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(((RegistrationMethods)((Object)runnable)).zaa.getListenerKey(), (Object)"Listener has already been released.");
        RegisterListenerMethod registerListenerMethod = ((RegistrationMethods)((Object)runnable)).register;
        UnregisterListenerMethod unregisterListenerMethod = ((RegistrationMethods)((Object)runnable)).zaa;
        runnable = ((RegistrationMethods)((Object)runnable)).zab;
        return this.zaa.zao(this, registerListenerMethod, unregisterListenerMethod, runnable);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @Deprecated
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@NonNull T registerMethod, @NonNull U unregisterMethod) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(registerMethod);
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotNull(var1_1.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(var2_2.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)Objects.equal(var1_1.getListenerKey(), var2_2.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        zad zad2 = com.google.android.gms.common.api.zad.zaa;
        return this.zaa.zao(this, (RegisterListenerMethod)var1_1, (UnregisterListenerMethod)var2_2, zad2);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        void var1_1;
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey<?>)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey, int methodKey) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zaa.zap(this, (ListenerHolder.ListenerKey)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(1, (TaskApiCall)var1_1);
    }

    @Nullable
    protected String getApiFallbackAttributionTag(@NonNull Context context) {
        return null;
    }

    @KeepForSdk
    @Nullable
    protected String getContextAttributionTag() {
        return this.zac;
    }

    @Deprecated
    @KeepForSdk
    @Nullable
    protected String getContextFeatureId() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((Context)v0, (Activity)v0, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        builder.setLooper(var1_1.getMainLooper());
        this((Activity)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        this((Context)var1_1, null, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this(context, api, options, new Settings.Builder().setMapper(mapper).build())", imports={"com.google.android.gms.common.api.GoogleApi.Settings"})
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        this((Context)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private GoogleApi(@NonNull Context object, @Nullable Activity activity, Api api, Api.ApiOptions apiOptions, Settings settings) {
        void var2_6;
        void var4_8;
        void var1_3;
        void var5_9;
        void var3_7;
        Preconditions.checkNotNull((Object)object, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull((Object)var3_7, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)var5_9, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zab = (Context)Preconditions.checkNotNull((Object)object.getApplicationContext(), (Object)"The provided context did not have an application context.");
        if (Build.VERSION.SDK_INT >= 30 && object != null) {
            String string2 = object.getAttributionTag();
        } else if (object != null) {
            String string3 = this.getApiFallbackAttributionTag((Context)object);
        } else {
            Object var1_5 = null;
        }
        this.zac = var1_3;
        this.zad = var3_7;
        this.zae = var4_8;
        this.zag = var5_9.zab;
        this.zaf = ApiKey.getSharedApiKey(this.zad, this.zae, this.zac);
        this.zai = new zabv(this);
        this.zaa = GoogleApiManager.zak(this.zab);
        this.zah = this.zaa.zaa();
        this.zaj = var5_9.zaa;
        if (var2_6 != null && !(var2_6 instanceof GoogleApiActivity) && Looper.myLooper() == Looper.getMainLooper()) {
            zaae.zad((Activity)var2_6, this.zaa, this.zaf);
        }
        this.zaa.zaz(this);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this(context, api, options, new Settings.Builder().setLooper(looper).setMapper(mapper).build())", imports={"com.google.android.gms.common.api.GoogleApi.Settings"})
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull Looper looper, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var5_5;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setLooper((Looper)var4_4);
        builder.setMapper((StatusExceptionMapper)var5_5);
        this((Context)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    public final int zaa() {
        return this.zah;
    }

    @WorkerThread
    public final Api.Client zab(Looper object, zabq zabq2) {
        ClientSettings clientSettings = ((GoogleApi)this).createClientSettingsBuilder().build();
        Api.ApiOptions apiOptions = ((GoogleApi)this).zae;
        zabq zabq3 = zabq2;
        object = ((Api.AbstractClientBuilder)Preconditions.checkNotNull((Object)((GoogleApi)this).zad.zaa())).buildClient(((GoogleApi)this).zab, (Looper)object, clientSettings, apiOptions, zabq3, zabq3);
        if ((this = ((GoogleApi)this).getContextAttributionTag()) != null && object instanceof BaseGmsClient) {
            ((BaseGmsClient)object).setAttributionTag((String)this);
        }
        if (this != null && object instanceof NonGmsServiceBrokerClient) {
            ((NonGmsServiceBrokerClient)object).zac((String)this);
        }
        return object;
    }

    private final BaseImplementation.ApiMethodImpl zad(int n, @NonNull BaseImplementation.ApiMethodImpl apiMethodImpl) {
        apiMethodImpl.zak();
        this.zaa.zau(this, n, apiMethodImpl);
        return apiMethodImpl;
    }

    public final zact zac(Context context, Handler handler) {
        return new zact(context, handler, this.createClientSettingsBuilder().build());
    }

    private final Task zae(int n, @NonNull TaskApiCall taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StatusExceptionMapper statusExceptionMapper = this.zaj;
        this.zaa.zav(this, n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        return taskCompletionSource.getTask();
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        @NonNull
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        @NonNull
        public final StatusExceptionMapper zaa;
        @NonNull
        public final Looper zab;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        private Settings(StatusExceptionMapper mapper, Account account, Looper looper) {
            void var3_3;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var3_3;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zae zae2) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zaa;
            private Looper zab;

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @KeepForSdk
            @NonNull
            public Builder setLooper(@NonNull Looper looper) {
                void var1_1;
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zab = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @KeepForSdk
            @NonNull
            public Builder setMapper(@NonNull StatusExceptionMapper mapper) {
                void var1_1;
                Preconditions.checkNotNull((Object)mapper, (Object)"StatusExceptionMapper must not be null.");
                this.zaa = var1_1;
                return this;
            }

            @KeepForSdk
            @NonNull
            public Settings build() {
                if (this.zaa == null) {
                    this.zaa = new ApiExceptionMapper();
                }
                if (this.zab == null) {
                    this.zab = Looper.getMainLooper();
                }
                return new Settings(this.zaa, null, this.zab, null);
            }

            @KeepForSdk
            public Builder() {
            }
        }
    }
}

