/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zab;
import com.google.android.gms.signin.SignInOptions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@KeepForSdk
public final class ClientSettings {
    @javax.annotation.Nullable
    private final Account zaa;
    private final Set zab;
    private final Set zac;
    private final Map zad;
    private final int zae;
    @javax.annotation.Nullable
    private final View zaf;
    private final String zag;
    private final String zah;
    private final SignInOptions zai;
    private Integer zaj;

    @KeepForSdk
    public int getGravityForPopups() {
        return this.zae;
    }

    @Nullable
    @KeepForSdk
    public Account getAccount() {
        return this.zaa;
    }

    @KeepForSdk
    @NonNull
    public Account getAccountOrDefault() {
        ClientSettings this_ = this_.zaa;
        if (this_ != null) {
            return this_;
        }
        return new Account("<<default account>>", "com.google");
    }

    @Nullable
    @KeepForSdk
    public View getViewForPopups() {
        return this.zaf;
    }

    @KeepForSdk
    @NonNull
    public static ClientSettings createDefault(@NonNull Context context) {
        Context context2;
        return new GoogleApiClient.Builder(context2).zaa();
    }

    @Deprecated
    @Nullable
    @KeepForSdk
    public String getAccountName() {
        ClientSettings this_ = this_.zaa;
        if (this_ != null) {
            return ((Account)this_).name;
        }
        return null;
    }

    @KeepForSdk
    @NonNull
    public String getRealClientPackageName() {
        return this.zag;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getAllRequestedScopes() {
        return this.zac;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getApplicableScopes(@NonNull Api<?> api) {
        zab zab2;
        if ((zab2 = (zab)((ClientSettings)((Object)this_)).zad.get(zab2)) == null || zab2.zaa.isEmpty()) {
            return ((ClientSettings)((Object)this_)).zab;
        }
        Set this_ = ((ClientSettings)((Object)this_)).zab;
        HashSet<Scope> hashSet = new HashSet<Scope>(this_);
        hashSet.addAll(zab2.zaa);
        return hashSet;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getRequiredScopes() {
        return this.zab;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public ClientSettings(@NonNull Account account, @NonNull Set<Scope> scopes, @NonNull Map<Api<?>, zab> optionalApiSettingsMap, int gravityForPopups, @javax.annotation.Nullable View viewForPopups, @NonNull String realClientPackageName, @NonNull String realClientClassName, @javax.annotation.Nullable SignInOptions signInOptions) {
        this((Account)var1_1, (Set)var2_2, (Map)var3_3, (int)var4_4, (View)var5_5, (String)var6_6, (String)var7_7, (SignInOptions)var8_8, false);
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ClientSettings(@javax.annotation.Nullable Account object, @NonNull Set iterator, @NonNull Map map, int n, @javax.annotation.Nullable View view, @NonNull String string2, @NonNull String string3, @javax.annotation.Nullable SignInOptions signInOptions, boolean bl) {
        this.zaa = object;
        object = iterator == null ? Collections.emptySet() : Collections.unmodifiableSet(iterator);
        this.zab = object;
        if (map == null) {
            map = Collections.emptyMap();
        }
        this.zad = map;
        this.zaf = view;
        this.zae = n;
        this.zag = string2;
        this.zah = string3;
        if (signInOptions == null) {
            signInOptions = SignInOptions.zaa;
        }
        this.zai = signInOptions;
        object = new HashSet(this.zab);
        iterator = this.zad.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zac = Collections.unmodifiableSet(object);
                return;
            }
            object.addAll(((zab)iterator.next()).zaa);
        }
    }

    @NonNull
    public final SignInOptions zaa() {
        return this.zai;
    }

    @Nullable
    public final Integer zab() {
        return this.zaj;
    }

    @Nullable
    public final String zac() {
        return this.zah;
    }

    @NonNull
    public final Map zad() {
        return this.zad;
    }

    public final void zae(@NonNull Integer n) {
        this.zaj = n;
    }

    @KeepForSdk
    public static final class Builder {
        @javax.annotation.Nullable
        private Account zaa;
        private ArraySet zab;
        private String zac;
        private String zad;
        private final SignInOptions zae = SignInOptions.zaa;

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @KeepForSdk
        @NonNull
        public Builder setRealClientPackageName(@NonNull String name) {
            void var1_1;
            this.zac = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public ClientSettings build() {
            return new ClientSettings(this.zaa, (Set)this.zab, null, 0, null, this.zac, this.zad, this.zae, false);
        }

        @CanIgnoreReturnValue
        @NonNull
        public final Builder zaa(@NonNull Collection collection) {
            if (this.zab == null) {
                this.zab = new ArraySet();
            }
            this.zab.addAll(collection);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public final Builder zab(@javax.annotation.Nullable Account account) {
            this.zaa = account;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public final Builder zac(@NonNull String string2) {
            this.zad = string2;
            return this;
        }
    }
}

