/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.moduleinstall.internal;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.OptionalModuleApi;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.moduleinstall.ModuleInstallRequest;
import com.google.android.gms.common.moduleinstall.internal.zab;
import com.google.android.gms.common.moduleinstall.internal.zac;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@KeepForSdk
@SafeParcelable.Class(creator="ApiFeatureRequestCreator")
public class ApiFeatureRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ApiFeatureRequest> CREATOR = new zac();
    private static final Comparator zaa = com.google.android.gms.common.moduleinstall.internal.zab.zaa;
    @SafeParcelable.Field(id=1, getter="getApiFeatures")
    private final List zab;
    @SafeParcelable.Field(id=2, getter="getIsUrgent")
    private final boolean zac;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getFeatureRequestSessionId")
    private final String zad;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getCallingPackage")
    private final String zae;

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zac, this.zab, this.zad, this.zae});
    }

    @KeepForSdk
    @NonNull
    public static ApiFeatureRequest fromModuleInstallRequest(@NonNull ModuleInstallRequest moduleInstallRequest) {
        return ApiFeatureRequest.zaa(moduleInstallRequest.getApis(), true);
    }

    @KeepForSdk
    @NonNull
    public List<Feature> getApiFeatures() {
        return this.zab;
    }

    @SafeParcelable.Constructor
    public ApiFeatureRequest(@SafeParcelable.Param(id=1) @NonNull List list, @SafeParcelable.Param(id=2) boolean bl, @Nullable @SafeParcelable.Param(id=3) String string2, @Nullable @SafeParcelable.Param(id=4) String string3) {
        Preconditions.checkNotNull((Object)list);
        this.zab = list;
        this.zac = bl;
        this.zad = string2;
        this.zae = string3;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.getApiFeatures(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)2, (boolean)this.zac);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zad, (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)this.zae, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ApiFeatureRequest)) {
            return false;
        }
        object = (ApiFeatureRequest)((Object)object);
        return this.zac == ((ApiFeatureRequest)((Object)object)).zac && Objects.equal((Object)this.zab, (Object)((ApiFeatureRequest)((Object)object)).zab) && Objects.equal((Object)this.zad, (Object)((ApiFeatureRequest)((Object)object)).zad) && Objects.equal((Object)this.zae, (Object)((ApiFeatureRequest)((Object)object)).zae);
    }

    static ApiFeatureRequest zaa(List object, boolean bl) {
        TreeSet treeSet = new TreeSet(zaa);
        object = object.iterator();
        while (object.hasNext()) {
            Collections.addAll(treeSet, ((OptionalModuleApi)object.next()).getOptionalFeatures());
        }
        return new ApiFeatureRequest(new ArrayList(treeSet), bl, null, null);
    }
}

