/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import com.google.android.gms.auth.api.signin.zaa;
import com.google.android.gms.auth.api.signin.zab;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Class(creator="GoogleSignInAccountCreator")
public class GoogleSignInAccount
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zaa();
    @VisibleForTesting
    @NonNull
    public static final Clock zaa = DefaultClock.getInstance();
    @Nullable
    @SafeParcelable.Field(id=2, getter="getId")
    private final String zac;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getIdToken")
    private final String zad;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getEmail")
    private final String zae;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getDisplayName")
    private final String zaf;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getPhotoUrl")
    private final Uri zag;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getServerAuthCode")
    private String zah;
    @SafeParcelable.Field(id=8, getter="getExpirationTimeSecs")
    private final long zai;
    @SafeParcelable.Field(id=9, getter="getObfuscatedIdentifier")
    private final String zaj;
    @SafeParcelable.Field(id=10)
    final List zab;
    @Nullable
    @SafeParcelable.Field(id=11, getter="getGivenName")
    private final String zak;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getFamilyName")
    private final String zal;
    private final Set zam = new HashSet();

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static GoogleSignInAccount fromAccountAndScopes(@NonNull Account account, @NonNull Scope scope, Scope ... scopes) {
        Account account2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)account);
        Preconditions.checkNotNull((Object)var1_1);
        HashSet hashSet = new HashSet();
        hashSet.add(var1_1);
        hashSet.addAll(Arrays.asList(var2_2));
        return GoogleSignInAccount.zae(account2, hashSet);
    }

    @KeepForSdk
    @NonNull
    public static GoogleSignInAccount fromAccount(@NonNull Account account) {
        return GoogleSignInAccount.zae(account, (Set)new ArraySet());
    }

    @KeepForSdk
    @NonNull
    public static GoogleSignInAccount createDefault() {
        return GoogleSignInAccount.zae(new Account("<<default account>>", "com.google"), new HashSet());
    }

    @SafeParcelable.Constructor
    GoogleSignInAccount(@SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) @Nullable String string3, @SafeParcelable.Param(id=5) @Nullable String string4, @SafeParcelable.Param(id=6) @Nullable Uri uri, @SafeParcelable.Param(id=7) @Nullable String string5, @SafeParcelable.Param(id=8) long l, @SafeParcelable.Param(id=9) String string6, @SafeParcelable.Param(id=10) List list, @SafeParcelable.Param(id=11) @Nullable String string7, @SafeParcelable.Param(id=12) @Nullable String string8) {
        this.zac = string;
        this.zad = string2;
        this.zae = string3;
        this.zaf = string4;
        this.zag = uri;
        this.zah = string5;
        this.zai = l;
        this.zaj = string6;
        this.zab = list;
        this.zak = string7;
        this.zal = string8;
    }

    @Nullable
    public String getId() {
        return this.zac;
    }

    @Nullable
    public String getIdToken() {
        return this.zad;
    }

    @Nullable
    public String getEmail() {
        return this.zae;
    }

    @Nullable
    public Account getAccount() {
        Object this_ = this_.zae;
        if (this_ == null) {
            return null;
        }
        String string = "com.google";
        return new Account((String)this_, string);
    }

    @Nullable
    public String getDisplayName() {
        return this.zaf;
    }

    @Nullable
    public String getGivenName() {
        return this.zak;
    }

    @Nullable
    public String getFamilyName() {
        return this.zal;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zag;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public GoogleSignInAccount requestExtraScopes(Scope ... scopes) {
        if (scopes != null) {
            void var1_1;
            Collections.addAll(this.zam, var1_1);
        }
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zah;
    }

    @KeepForSdk
    public boolean isExpired() {
        return zaa.currentTimeMillis() / 1000L >= this.zai + -300L;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zab);
    }

    @NonNull
    @KeepForSdk
    public Set<Scope> getRequestedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        hashSet.addAll(this.zam);
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getIdToken(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.getPhotoUrl(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getServerAuthCode(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.zai);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.zaj, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)10, (List)this.zab, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)11, (String)this.getGivenName(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)12, (String)this.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public int hashCode() {
        int n = ((Object)this.getRequestedScopes()).hashCode();
        return (this.zaj.hashCode() + 527) * 31 + n;
    }

    public boolean equals(@Nullable Object obj) {
        GoogleSignInAccount googleSignInAccount;
        if (obj == null) {
            return false;
        }
        if (googleSignInAccount == this) {
            return true;
        }
        if (!(googleSignInAccount instanceof GoogleSignInAccount)) {
            return false;
        }
        googleSignInAccount = googleSignInAccount;
        return googleSignInAccount.zaj.equals(this.zaj) && ((Object)googleSignInAccount.getRequestedScopes()).equals(this.getRequestedScopes());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GoogleSignInAccount zaa(@Nullable String string) throws JSONException {
        void var2_6;
        void var1_13;
        void var1_11;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        string = !TextUtils.isEmpty((CharSequence)(string = jSONObject.optString("photoUrl"))) ? Uri.parse((String)string) : null;
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        boolean bl = false;
        while (var1_11 < n) {
            hashSet.add(new Scope(jSONArray.getString((int)var1_11)));
            ++var1_11;
        }
        String string2 = jSONObject.optString("id");
        if (jSONObject.has("tokenId")) {
            String string3 = jSONObject.optString("tokenId");
        } else {
            Object var1_15 = null;
        }
        if (jSONObject.has("email")) {
            String string4 = jSONObject.optString("email");
        } else {
            Object var2_7 = null;
        }
        String string5 = jSONObject.has("displayName") ? jSONObject.optString("displayName") : null;
        String string6 = jSONObject.has("givenName") ? jSONObject.optString("givenName") : null;
        String string7 = jSONObject.has("familyName") ? jSONObject.optString("familyName") : null;
        GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zab(string2, (String)var1_13, (String)var2_6, string5, string6, string7, (Uri)string, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        string = jSONObject.has("serverAuthCode") ? jSONObject.optString("serverAuthCode") : null;
        googleSignInAccount.zah = string;
        return googleSignInAccount;
    }

    @NonNull
    public static GoogleSignInAccount zab(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Uri uri, @Nullable Long l, @NonNull String string7, @NonNull Set set) {
        return new GoogleSignInAccount(string, string2, string3, string4, uri, null, l, Preconditions.checkNotEmpty((String)string7), new ArrayList((Collection)Preconditions.checkNotNull((Object)set)), string5, string6);
    }

    private static GoogleSignInAccount zae(Account account, Set set) {
        return GoogleSignInAccount.zab(null, null, account.name, null, null, null, null, 0L, account.name, set);
    }

    @NonNull
    public final String zac() {
        return this.zaj;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final String zad() {
        String string;
        JSONObject jSONObject = new JSONObject();
        try {
            string = ((GoogleSignInAccount)((Object)this)).getId();
            if (string != null) {
                jSONObject.put("id", (Object)((GoogleSignInAccount)((Object)this)).getId());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getIdToken()) != null) {
                jSONObject.put("tokenId", (Object)((GoogleSignInAccount)((Object)this)).getIdToken());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getEmail()) != null) {
                jSONObject.put("email", (Object)((GoogleSignInAccount)((Object)this)).getEmail());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getDisplayName()) != null) {
                jSONObject.put("displayName", (Object)((GoogleSignInAccount)((Object)this)).getDisplayName());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getGivenName()) != null) {
                jSONObject.put("givenName", (Object)((GoogleSignInAccount)((Object)this)).getGivenName());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getFamilyName()) != null) {
                jSONObject.put("familyName", (Object)((GoogleSignInAccount)((Object)this)).getFamilyName());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getPhotoUrl()) != null) {
                jSONObject.put("photoUrl", (Object)string.toString());
            }
            if ((string = ((GoogleSignInAccount)((Object)this)).getServerAuthCode()) != null) {
                jSONObject.put("serverAuthCode", (Object)((GoogleSignInAccount)((Object)this)).getServerAuthCode());
            }
            jSONObject.put("expirationTime", ((GoogleSignInAccount)((Object)this)).zai);
            string = "obfuscatedIdentifier";
            Scope[] scopeArray = ((GoogleSignInAccount)((Object)this)).zaj;
            jSONObject.put(string, (Object)scopeArray);
            string = new JSONArray();
            Object object = this = ((GoogleSignInAccount)((Object)this)).zab;
            scopeArray = object.toArray(new Scope[object.size()]);
            Arrays.sort(scopeArray, com.google.android.gms.auth.api.signin.zab.zaa);
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                string.put((Object)scopeArray[i].getScopeUri());
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        {
            jSONObject.put("grantedScopes", (Object)string);
        }
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }
}

