/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zac;
import com.google.android.gms.auth.api.signin.zad;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @NonNull
    public static final GoogleSignInOptions DEFAULT_SIGN_IN;
    @NonNull
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN;
    @NonNull
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR;
    @VisibleForTesting
    @NonNull
    public static final Scope zaa;
    @VisibleForTesting
    @NonNull
    public static final Scope zab;
    @VisibleForTesting
    @NonNull
    public static final Scope zac;
    @VisibleForTesting
    @NonNull
    public static final Scope zad;
    @VisibleForTesting
    @NonNull
    public static final Scope zae;
    @SafeParcelable.VersionField(id=1)
    final int zaf;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList zag;
    @SafeParcelable.Field(id=3, getter="getAccount")
    @Nullable
    private Account zah;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zai;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zaj;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zak;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    @Nullable
    private String zal;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    @Nullable
    private String zam;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList zan;
    @SafeParcelable.Field(id=10, getter="getLogSessionId")
    @Nullable
    private String zao;
    private Map zap;
    private static final Comparator zaq;

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList arrayList, @SafeParcelable.Param(id=3) @Nullable Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) @Nullable String string, @SafeParcelable.Param(id=8) @Nullable String string2, @SafeParcelable.Param(id=9) ArrayList arrayList2, @SafeParcelable.Param(id=10) @Nullable String string3) {
        this(n, arrayList, account, bl, bl2, bl3, string, string2, GoogleSignInOptions.zam(arrayList2), string3);
    }

    private GoogleSignInOptions(int n, ArrayList arrayList, @Nullable Account account, boolean bl, boolean bl2, boolean bl3, @Nullable String string, @Nullable String string2, Map map, @Nullable String string3) {
        this.zaf = n;
        this.zag = arrayList;
        this.zah = account;
        this.zai = bl;
        this.zaj = bl2;
        this.zak = bl3;
        this.zal = string;
        this.zam = string2;
        this.zan = new ArrayList(map.values());
        this.zap = map;
        this.zao = string3;
    }

    @KeepForSdk
    @NonNull
    public ArrayList<Scope> getScopes() {
        return new ArrayList<Scope>(this.zag);
    }

    @NonNull
    public Scope[] getScopeArray() {
        ArrayList arrayList = this.zag;
        return arrayList.toArray(new Scope[arrayList.size()]);
    }

    @KeepForSdk
    @Nullable
    public Account getAccount() {
        return this.zah;
    }

    @KeepForSdk
    public boolean isIdTokenRequested() {
        return this.zai;
    }

    @KeepForSdk
    public boolean isServerAuthCodeRequested() {
        return this.zaj;
    }

    @KeepForSdk
    public boolean isForceCodeForRefreshToken() {
        return this.zak;
    }

    @KeepForSdk
    @Nullable
    public String getServerClientId() {
        return this.zal;
    }

    @KeepForSdk
    @Nullable
    public String getLogSessionId() {
        return this.zao;
    }

    @KeepForSdk
    @NonNull
    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zan;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = this.zaf;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)n);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)2, this.getScopes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getAccount(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.zam, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)9, this.getExtensions(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)10, (String)this.getLogSessionId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            boolean bl;
            int n;
            boolean bl2;
            boolean bl3;
            int n2;
            GoogleSignInOptions googleSignInOptions;
            googleSignInOptions = googleSignInOptions;
            boolean bl4 = this.zan.isEmpty();
            if (!bl4 || !(bl4 = googleSignInOptions.zan.isEmpty())) {
                return false;
            }
            ArrayList arrayList = this.zag;
            int n3 = arrayList.size();
            if (n3 != (n2 = googleSignInOptions.getScopes().size()) || !(bl3 = arrayList.containsAll(googleSignInOptions.getScopes()))) {
                return false;
            }
            Account account = this.zah;
            return (account == null ? (account = googleSignInOptions.getAccount()) == null : (bl2 = account.equals((Object)googleSignInOptions.getAccount()))) && ((n = TextUtils.isEmpty((CharSequence)this.zal)) != 0 ? (n = TextUtils.isEmpty((CharSequence)googleSignInOptions.getServerClientId())) != 0 : (n = this.zal.equals(googleSignInOptions.getServerClientId())) != 0) && (n = this.zak) == (n3 = (int)(googleSignInOptions.isForceCodeForRefreshToken() ? 1 : 0)) && (n = (int)(this.zai ? 1 : 0)) == (n3 = (int)(googleSignInOptions.isIdTokenRequested() ? 1 : 0)) && (n = (int)(this.zaj ? 1 : 0)) == (n3 = (int)(googleSignInOptions.isServerAuthCodeRequested() ? 1 : 0)) && (bl = TextUtils.equals((CharSequence)this.zao, (CharSequence)googleSignInOptions.getLogSessionId()));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.zag;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(((Scope)arrayList2.get(i)).getScopeUri());
        }
        Collections.sort(arrayList);
        HashAccumulator hashAccumulator = new HashAccumulator();
        hashAccumulator.addObject(arrayList);
        hashAccumulator.addObject(this.zah);
        hashAccumulator.addObject(this.zal);
        hashAccumulator.zaa(this.zak);
        hashAccumulator.zaa(this.zai);
        hashAccumulator.zaa(this.zaj);
        hashAccumulator.addObject(this.zao);
        return hashAccumulator.hash();
    }

    static {
        zaa = new Scope("profile");
        zab = new Scope("email");
        zac = new Scope("openid");
        zad = new Scope("https://www.googleapis.com/auth/games_lite");
        zae = new Scope("https://www.googleapis.com/auth/games");
        Builder builder = new Builder();
        builder.requestId();
        builder.requestProfile();
        DEFAULT_SIGN_IN = builder.build();
        Builder builder2 = new Builder();
        builder2.requestScopes(zad, new Scope[0]);
        DEFAULT_GAMES_SIGN_IN = builder2.build();
        CREATOR = new zad();
        zaq = new zac();
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map map, String string3, byte[] byArray) {
        this(3, arrayList, account, bl, bl2, bl3, string, string2, map, string3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GoogleSignInOptions zaa(@Nullable String string) throws JSONException {
        void var2_5;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        Object object = new HashSet();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            object.add(new Scope(jSONArray.getString(i)));
        }
        String string2 = jSONObject.has("accountName") ? jSONObject.optString("accountName") : null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "com.google";
            string2 = new Account(string2, string3);
        } else {
            string2 = null;
        }
        ArrayList arrayList = new ArrayList(object);
        boolean bl = jSONObject.getBoolean("idTokenRequested");
        boolean bl2 = jSONObject.getBoolean("serverAuthRequested");
        boolean bl3 = jSONObject.getBoolean("forceCodeForRefreshToken");
        object = jSONObject.has("serverClientId") ? jSONObject.optString("serverClientId") : null;
        if (jSONObject.has("hostedDomain")) {
            String string4 = jSONObject.optString("hostedDomain");
            return new GoogleSignInOptions(3, arrayList, (Account)string2, bl, bl2, bl3, (String)object, (String)var2_5, new HashMap(), null);
        } else {
            Object var2_6 = null;
        }
        return new GoogleSignInOptions(3, arrayList, (Account)string2, bl, bl2, bl3, (String)object, (String)var2_5, new HashMap(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map zam(@Nullable List iterator) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable = (GoogleSignInOptionsExtensionParcelable)((Object)iterator.next());
                hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
            }
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final String zab() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl;
            JSONArray jSONArray = new JSONArray();
            Object object = this.zag;
            Collections.sort(object, zaq);
            object = ((ArrayList)object).iterator();
            while (bl = object.hasNext()) {
                jSONArray.put((Object)((Scope)object.next()).getScopeUri());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            jSONArray = this.zah;
            if (jSONArray != null) {
                object = "accountName";
                jSONObject.put((String)object, (Object)jSONArray.name);
            }
            jSONObject.put("idTokenRequested", this.zai);
            jSONObject.put("forceCodeForRefreshToken", this.zak);
            jSONObject.put("serverAuthRequested", this.zaj);
            boolean bl2 = TextUtils.isEmpty((CharSequence)this.zal);
            if (!bl2) {
                jSONObject.put("serverClientId", (Object)this.zal);
            }
            if (bl2 = TextUtils.isEmpty((CharSequence)this.zam)) return jSONObject.toString();
            jSONObject.put("hostedDomain", (Object)this.zam);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    final /* synthetic */ ArrayList zad() {
        return this.zag;
    }

    final /* synthetic */ Account zae() {
        return this.zah;
    }

    final /* synthetic */ boolean zaf() {
        return this.zai;
    }

    final /* synthetic */ boolean zag() {
        return this.zaj;
    }

    final /* synthetic */ boolean zah() {
        return this.zak;
    }

    final /* synthetic */ String zai() {
        return this.zal;
    }

    final /* synthetic */ String zaj() {
        return this.zam;
    }

    final /* synthetic */ ArrayList zak() {
        return this.zan;
    }

    final /* synthetic */ String zal() {
        return this.zao;
    }

    @Deprecated
    public static final class Builder {
        private Set zaa = new HashSet();
        private boolean zab;
        private boolean zac;
        private boolean zad;
        @Nullable
        private String zae;
        @Nullable
        private Account zaf;
        @Nullable
        private String zag;
        private Map zah = new HashMap();
        @Nullable
        private String zai;

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            void var1_1;
            Preconditions.checkNotNull((Object)var1_1);
            this.zaa = new HashSet(var1_1.zad());
            this.zab = var1_1.zag();
            this.zac = var1_1.zah();
            this.zad = var1_1.zaf();
            this.zae = var1_1.zai();
            this.zaf = var1_1.zae();
            this.zag = var1_1.zaj();
            this.zah = GoogleSignInOptions.zam(var1_1.zak());
            this.zai = var1_1.zal();
        }

        @NonNull
        public Builder requestId() {
            this.zaa.add(zac);
            return this;
        }

        @NonNull
        public Builder requestEmail() {
            this.zaa.add(zab);
            return this;
        }

        @NonNull
        public Builder requestProfile() {
            this.zaa.add(zaa);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestScopes(@NonNull Scope scope, Scope ... scopes) {
            void var2_2;
            void var1_1;
            this.zaa.add(var1_1);
            this.zaa.addAll(Arrays.asList(var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestIdToken(@NonNull String serverClientId) {
            void var1_1;
            this.zad = true;
            this.zaa((String)var1_1);
            this.zae = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestServerAuthCode(@NonNull String serverClientId) {
            void var1_1;
            this.requestServerAuthCode((String)var1_1, false);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestServerAuthCode(@NonNull String serverClientId, boolean forceCodeForRefreshToken) {
            void var2_2;
            void var1_1;
            this.zab = true;
            this.zaa((String)var1_1);
            this.zae = var1_1;
            this.zac = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAccountName(@NonNull String accountName) {
            void var1_1;
            this.zaf = new Account(Preconditions.checkNotEmpty((String)var1_1), "com.google");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHostedDomain(@NonNull String hostedDomain) {
            void var1_1;
            this.zag = Preconditions.checkNotEmpty((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setLogSessionId(@NonNull String logSessionId) {
            void var1_1;
            this.zai = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addExtension(@NonNull GoogleSignInOptionsExtension extension) {
            void var1_1;
            if (this.zah.containsKey(var1_1.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            List<Scope> list = var1_1.getImpliedScopes();
            if (list != null) {
                this.zaa.addAll(list);
            }
            this.zah.put(var1_1.getExtensionType(), new GoogleSignInOptionsExtensionParcelable((GoogleSignInOptionsExtension)var1_1));
            return this;
        }

        @NonNull
        public GoogleSignInOptions build() {
            Scope scope;
            if (this.zaa.contains(zae) && this.zaa.contains(scope = zad)) {
                this.zaa.remove(scope);
            }
            if (this.zad && (this.zaf == null || !this.zaa.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList(this.zaa), this.zaf, this.zad, this.zab, this.zac, this.zae, this.zag, this.zah, this.zai, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String zaa(String string) {
            Preconditions.checkNotEmpty((String)string);
            String string2 = ((Builder)((Object)string2)).zae;
            boolean bl = string2 != null ? string2.equals(string) : true;
            Preconditions.checkArgument((boolean)bl, (Object)"two different server client ids provided");
            return string;
        }
    }
}

