/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.base.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zaaa;
import com.google.android.gms.common.internal.zaz;
import com.google.android.gms.dynamic.RemoteCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int zaa;
    private int zab;
    private View zac;
    @Nullable
    private View.OnClickListener zad = null;

    /*
     * WARNING - void declaration
     */
    public SignInButton(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SignInButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SignInButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        TypedArray typedArray;
        typedArray = typedArray.getTheme().obtainStyledAttributes((AttributeSet)var2_2, R.styleable.SignInButton, 0, 0);
        try {
            this.zaa = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.zab = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
        SignInButton signInButton = this;
        signInButton.setStyle(this.zaa, signInButton.zab);
    }

    public void setSize(int buttonSize) {
        SignInButton signInButton = this;
        signInButton.setStyle(buttonSize, signInButton.zab);
    }

    /*
     * WARNING - void declaration
     */
    public void setColorScheme(int colorScheme) {
        void var1_1;
        SignInButton signInButton = this;
        signInButton.setStyle(signInButton.zaa, (int)var1_1);
    }

    @Deprecated
    public void setScopes(@NonNull Scope[] scopeArray) {
        SignInButton signInButton = this;
        signInButton.setStyle(this.zaa, signInButton.zab);
    }

    /*
     * WARNING - void declaration
     */
    public void setStyle(int buttonSize, int colorScheme) {
        void var2_2;
        void var1_1;
        this.zaa = var1_1;
        this.zab = var2_2;
        SignInButton signInButton = this;
        signInButton.zaa(signInButton.getContext());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setStyle(int buttonSize, int colorScheme, @NonNull Scope[] scopeArray) {
        void var2_2;
        void var1_1;
        this.setStyle((int)var1_1, (int)var2_2);
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        View view;
        this.zad = view;
        view = this.zac;
        if (view != null) {
            view.setOnClickListener((View.OnClickListener)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        super.setEnabled((boolean)var1_1);
        this.zac.setEnabled((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(@NonNull View view) {
        void var1_1;
        View.OnClickListener onClickListener = this.zad;
        if (onClickListener != null && var1_1 == this.zac) {
            onClickListener.onClick((View)this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zaa(Context context) {
        View view = this.zac;
        if (view != null) {
            this.removeView(view);
        }
        try {
            this.zac = zaz.zaa(context, this.zaa, this.zab);
        }
        catch (RemoteCreator.RemoteCreatorException remoteCreatorException) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            int n = this.zaa;
            int n2 = this.zab;
            zaaa zaaa2 = new zaaa(context, null);
            zaaa2.zaa(context.getResources(), n, n2);
            this.zac = zaaa2;
        }
        SignInButton signInButton = this;
        signInButton.addView(signInButton.zac);
        this.zac.setEnabled(this.isEnabled());
        this.zac.setOnClickListener((View.OnClickListener)this);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

