/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacs;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zao;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal zaa = new zaq();
    private final Object zae = new Object();
    @NonNull
    protected final CallbackHandler zab;
    @NonNull
    protected final WeakReference zac;
    private final CountDownLatch zaf = new CountDownLatch(1);
    private final ArrayList zag = new ArrayList();
    @Nullable
    private ResultCallback zah;
    private final AtomicReference zai = new AtomicReference();
    @Nullable
    private Result zaj;
    private Status zak;
    @KeepName
    private zar resultGuardian;
    private volatile boolean zal;
    private boolean zam;
    private boolean zan;
    @Nullable
    private ICancelToken zao;
    private volatile zacs zap;
    private boolean zaq = false;
    public static final /* synthetic */ int zad;

    @Deprecated
    BasePendingResult() {
        this.zab = new CallbackHandler(Looper.getMainLooper());
        this.zac = new WeakReference<Object>(null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    protected BasePendingResult(@Nullable GoogleApiClient apiClient) {
        void var1_1;
        Looper looper = var1_1 != null ? var1_1.getLooper() : Looper.getMainLooper();
        this.zab = new CallbackHandler(looper);
        this.zac = new WeakReference<void>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    protected BasePendingResult(@NonNull Looper looper) {
        void var1_1;
        this.zab = new CallbackHandler((Looper)var1_1);
        this.zac = new WeakReference<Object>(null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        void var1_1;
        this.zab = (CallbackHandler)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"CallbackHandler must not be null"));
        this.zac = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zaf.getCount() == 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed");
        boolean bl = this.zap == null;
        Preconditions.checkState((boolean)bl, (Object)"Cannot await if then() has been called.");
        try {
            this.zaf.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return (R)this.zaa();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final R await(long l, @NonNull TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed.");
        boolean bl = this.zap == null;
        Preconditions.checkState((boolean)bl, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl2 = this.zaf.await(l, timeUnit);
            if (!bl2) {
                this.forceFailureUnlessReady(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return (R)this.zaa();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@Nullable ResultCallback<? super R> callback) {
        var3_3 = this.zae;
        synchronized (var3_3) {
            if (var1_2 != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var2_4 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                Preconditions.checkState((boolean)(var2_4 ^= true), (Object)"Result has already been consumed.");
                var2_5 = this.zap;
                var2_6 = var2_5 == null;
                Preconditions.checkState((boolean)var2_6, (Object)"Cannot set callbacks if then() has been called.");
                var2_6 = this.isCanceled();
                if (var2_6) {
                    return;
                }
                var2_6 = this.isReady();
                if (var2_6) {
                    this.zab.zaa((ResultCallback)var1_2, this.zaa());
                } else {
                    this.zah = var1_2;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@NonNull ResultCallback<? super R> callback, long time, @NonNull TimeUnit units) {
        var6_5 = this.zae;
        synchronized (var6_5) {
            if (var1_2 != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var5_6 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                Preconditions.checkState((boolean)(var5_6 ^= true), (Object)"Result has already been consumed.");
                var5_7 = this.zap;
                var5_8 = var5_7 == null;
                Preconditions.checkState((boolean)var5_8, (Object)"Cannot set callbacks if then() has been called.");
                var5_8 = this.isCanceled();
                if (var5_8) {
                    return;
                }
                var5_8 = this.isReady();
                if (var5_8) {
                    this.zab.zaa((ResultCallback)var1_2, this.zaa());
                } else {
                    this.zah = var1_2;
                    var1_2 = this.zab;
                    var7_9 = var4_4.toMillis((long)var2_3);
                    v0 = var1_2;
                    v0.sendMessageDelayed(v0.obtainMessage(2, this), var7_9);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void addStatusListener(@NonNull PendingResult.StatusListener statusListener) {
        boolean bl = statusListener != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Callback cannot be null.");
        Object object = this.zae;
        synchronized (object) {
            boolean bl2 = this.isReady();
            if (bl2) {
                statusListener.onComplete(this.zak);
            } else {
                this.zag.add(statusListener);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zam;
            if (bl || (bl = this.zal)) {
                return;
            }
            ICancelToken iCancelToken = this.zao;
            if (iCancelToken != null) {
                try {
                    iCancelToken.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zal(this.zaj);
            this.zam = true;
            BasePendingResult basePendingResult = this;
            basePendingResult.zab((Result)basePendingResult.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isCanceled() {
        Object object = this.zae;
        synchronized (object) {
            return this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> object) {
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed.");
        Object object2 = this.zae;
        synchronized (object2) {
            zacs zacs2 = this.zap;
            boolean bl = zacs2 == null;
            Preconditions.checkState((boolean)bl, (Object)"Cannot call then() twice.");
            ResultCallback resultCallback = this.zah;
            boolean bl2 = resultCallback == null;
            Preconditions.checkState((boolean)bl2, (Object)"Cannot call then() if callbacks are set.");
            bl2 = this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState((boolean)(bl2 ^= true), (Object)"Cannot call then() if result was canceled.");
                this.zaq = true;
                this.zap = new zacs(this.zac);
                object = this.zap.then(object);
                bl2 = this.isReady();
                if (bl2) {
                    this.zab.zaa(this.zap, this.zaa());
                } else {
                    zacs zacs3 = this.zap;
                    this.zah = zacs3;
                }
                return object;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public final void setResult(@NonNull R result) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            boolean bl = this.zan;
            if (!bl && !(bl = this.zam)) {
                this.isReady();
                bl = this.isReady();
                Preconditions.checkState((boolean)(bl ^= true), (Object)"Results have already been set");
                bl = this.zal;
                Preconditions.checkState((boolean)(bl ^= true), (Object)"Result has already been consumed");
                this.zab((Result)var1_2);
                return;
            }
            BasePendingResult.zal((Result)var1_2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public final void forceFailureUnlessReady(@NonNull Status status) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            boolean bl = this.isReady();
            if (bl) return;
            BasePendingResult basePendingResult = this;
            basePendingResult.setResult(basePendingResult.createFailedResult((Status)var1_2));
            this.zan = true;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(@NonNull Status var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    protected final void setCancelToken(@NonNull ICancelToken cancelToken) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            this.zao = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zaj() {
        Object object = this.zae;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zac.get();
            if (googleApiClient != null) {
                boolean bl = this.zaq;
                if (bl) return this.isCanceled();
            }
            this.cancel();
            return this.isCanceled();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zak() {
        boolean bl = !this.zaq ? ((Boolean)zaa.get()).booleanValue() : true;
        this.zaq = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Result zaa() {
        Result result;
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zal;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState((boolean)(bl ^= true), (Object)"Result has already been consumed.");
                Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
                result = this.zaj;
                this.zaj = null;
                this.zah = null;
                this.zal = true;
            }
        }
        object = this.zai.getAndSet(null);
        if (object == null) return (Result)Preconditions.checkNotNull((Object)result);
        ((zact)object).zaa.zab.remove(this);
        return (Result)Preconditions.checkNotNull((Object)result);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zab(Result result) {
        this.zaj = result;
        this.zak = result.getStatus();
        this.zao = null;
        this.zaf.countDown();
        if (this.zam) {
            this.zah = null;
        } else {
            result = this.zah;
            if (result == null) {
                if (this.zaj instanceof Releasable) {
                    this.resultGuardian = new zar(this, null);
                }
            } else {
                CallbackHandler callbackHandler = this.zab;
                callbackHandler.removeMessages(2);
                callbackHandler.zaa((ResultCallback)result, this.zaa());
            }
        }
        ArrayList arrayList = this.zag;
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                arrayList.clear();
                return;
            }
            ((PendingResult.StatusListener)arrayList.get(n2)).onComplete(this.zak);
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zal(@Nullable Result object) {
        if (!(object instanceof Releasable)) return;
        try {
            ((Releasable)object).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(object);
            String.valueOf(string2);
            String string3 = String.valueOf(string2);
            String string4 = "Unable to release ";
            Log.w((String)"BasePendingResult", (String)string4.concat(string3), (Throwable)runtimeException);
            return;
        }
    }

    final /* synthetic */ Result zam() {
        return this.zaj;
    }

    public final void zan(@Nullable zact zact2) {
        this.zai.set(zact2);
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zao {
        public CallbackHandler() {
            super(Looper.getMainLooper());
        }

        public CallbackHandler(@NonNull Looper looper) {
            super(looper);
        }

        public final void handleMessage(@NonNull Message object) {
            switch (object.what) {
                case 2: {
                    ((BasePendingResult)object.obj).forceFailureUnlessReady(Status.RESULT_TIMEOUT);
                    return;
                }
                case 1: {
                    Pair pair = (Pair)object.obj;
                    CallbackHandler callbackHandler = (ResultCallback)pair.first;
                    object = (Result)pair.second;
                    try {
                        callbackHandler.onResult((Result)object);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zal((Result)object);
                        throw runtimeException;
                    }
                }
            }
            int n = object.what;
            int n2 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 34);
            stringBuilder.append("Don't know how to handle message: ");
            stringBuilder.append(n);
            String string2 = stringBuilder.toString();
            object = new Exception();
            Log.wtf((String)"BasePendingResult", (String)string2, (Throwable)object);
        }

        public final void zaa(@NonNull ResultCallback resultCallback, @NonNull Result result) {
            resultCallback = (ResultCallback)Preconditions.checkNotNull((Object)resultCallback);
            CallbackHandler callbackHandler = this;
            callbackHandler.sendMessage(callbackHandler.obtainMessage(1, new Pair((Object)resultCallback, (Object)result)));
        }
    }
}

