/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.api.internal.zacb;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.AttributionSourceWrapper;
import com.google.android.gms.internal.base.zao;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public final class NonGmsServiceBrokerClient
implements Api.Client,
ServiceConnection {
    private static final String zaa = NonGmsServiceBrokerClient.class.getSimpleName();
    @Nullable
    private final String zab;
    @Nullable
    private final String zac;
    @Nullable
    private final ComponentName zad;
    private final Context zae;
    private final ConnectionCallbacks zaf;
    private final Handler zag;
    private final OnConnectionFailedListener zah;
    @Nullable
    private IBinder zai;
    private boolean zaj;
    @Nullable
    private String zak;
    @Nullable
    private String zal;
    @Nullable
    private AttributionSourceWrapper zam;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull String packageName, @NonNull String action, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, (String)var3_3, (String)var4_4, null, (ConnectionCallbacks)var5_5, (OnConnectionFailedListener)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull ComponentName componentName, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, null, null, (ComponentName)var3_3, (ConnectionCallbacks)var4_4, (OnConnectionFailedListener)var5_5);
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private NonGmsServiceBrokerClient(Context context, Looper looper, @Nullable String string2, @Nullable String string3, @Nullable ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        block3: {
            block4: {
                block2: {
                    this.zaj = false;
                    this.zak = null;
                    this.zae = context;
                    this.zag = new zao(looper);
                    this.zaf = connectionCallbacks;
                    this.zah = onConnectionFailedListener;
                    if (string2 == null || string3 == null) break block2;
                    if (componentName != null) break block3;
                    componentName = null;
                    break block4;
                }
                if (componentName == null) break block3;
            }
            this.zab = string2;
            this.zac = string3;
            this.zad = componentName;
            return;
        }
        throw new AssertionError((Object)"Must specify either package or component, but not both");
    }

    public final void onServiceConnected(@NonNull ComponentName object, @NonNull IBinder iBinder) {
        object = new zacb(this, iBinder);
        this.zag.post((Runnable)object);
    }

    public final void onServiceDisconnected(@NonNull ComponentName object) {
        object = new zaca(this);
        this.zag.post((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        block8: {
            this.zae();
            this.zaf("Connect started.");
            if (this.isConnected()) {
                try {
                    this.disconnect("connect() called when already connected");
                }
                catch (Exception exception) {}
            }
            try {
                boolean bl;
                connectionProgressReportCallbacks = new Intent();
                ComponentName componentName = this.zad;
                if (componentName != null) {
                    connectionProgressReportCallbacks.setComponent(componentName);
                } else {
                    connectionProgressReportCallbacks.setPackage(this.zab).setAction(this.zac);
                }
                this.zaj = bl = this.zae.bindService((Intent)connectionProgressReportCallbacks, (ServiceConnection)this, GmsClientSupervisor.getDefaultBindFlags());
                if (bl) break block8;
                this.zai = null;
            }
            catch (SecurityException securityException) {
                this.zaj = false;
                this.zai = null;
                throw securityException;
            }
            this.zah.onConnectionFailed(new ConnectionResult(16));
        }
        this.zaf("Finished connect.");
    }

    @Override
    @WorkerThread
    public final void disconnect(@NonNull String string2) {
        this.zae();
        this.zak = string2;
        this.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void disconnect() {
        this.zae();
        this.zaf("Disconnect called.");
        try {
            this.zae.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.zaj = false;
        this.zai = null;
    }

    @Override
    @WorkerThread
    public final boolean isConnected() {
        this.zae();
        return this.zai != null;
    }

    @Override
    @WorkerThread
    public final boolean isConnecting() {
        this.zae();
        return this.zaj;
    }

    @Override
    public final void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
    }

    @Override
    public final boolean requiresSignIn() {
        return false;
    }

    @Override
    public final void onUserSignOut(@NonNull BaseGmsClient.SignOutCallbacks signOutCallbacks) {
    }

    @Override
    public final boolean requiresAccount() {
        return false;
    }

    @Override
    public final boolean requiresGooglePlayServices() {
        return false;
    }

    @Override
    public final boolean providesSignIn() {
        return false;
    }

    @Override
    @NonNull
    public final Intent getSignInIntent() {
        return new Intent();
    }

    @Override
    public final void dump(@NonNull String string2, @Nullable FileDescriptor fileDescriptor, @NonNull PrintWriter printWriter, @Nullable String[] stringArray) {
    }

    @Override
    @Nullable
    public final IBinder getServiceBrokerBinder() {
        return null;
    }

    @Override
    @NonNull
    public final Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final String getEndpointPackageName() {
        String string2 = this.zab;
        if (string2 != null) {
            return string2;
        }
        ComponentName componentName = this.zad;
        Preconditions.checkNotNull((Object)componentName);
        return componentName.getPackageName();
    }

    @Override
    public final int getMinApkVersion() {
        return 0;
    }

    @Override
    @NonNull
    public final Feature[] getAvailableFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final Set<Scope> getScopesForConnectionlessNonSignIn() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public final String getLastDisconnectMessage() {
        return this.zak;
    }

    @WorkerThread
    @Nullable
    @KeepForSdk
    public IBinder getBinder() {
        this.zae();
        return this.zai;
    }

    @WorkerThread
    private final void zae() {
        NonGmsServiceBrokerClient nonGmsServiceBrokerClient = nonGmsServiceBrokerClient.zag;
        if (Thread.currentThread() != nonGmsServiceBrokerClient.getLooper().getThread()) {
            throw new IllegalStateException("This method should only run on the NonGmsServiceBrokerClient's handler thread.");
        }
    }

    private final void zaf(String string2) {
        string2 = String.valueOf(this.zai);
        String.valueOf(string2);
        String.valueOf(this.zaj);
    }

    public final void zaa(@Nullable String string2) {
        this.zal = string2;
    }

    public final void zab(@Nullable AttributionSourceWrapper attributionSourceWrapper) {
        this.zam = attributionSourceWrapper;
    }

    final /* synthetic */ void zac(IBinder iBinder) {
        this.zaj = false;
        this.zai = iBinder;
        this.zaf("Connected.");
        iBinder = new Bundle();
        this.zaf.onConnected((Bundle)iBinder);
    }

    final /* synthetic */ void zad() {
        this.zaj = false;
        this.zai = null;
        this.zaf("Disconnected.");
        this.zaf.onConnectionSuspended(1);
    }
}

