/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.BroadcastOptions;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zaa;
import com.google.android.gms.common.images.zab;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.images.zaf;
import com.google.android.gms.common.images.zag;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zaj;
import com.google.android.gms.internal.base.zan;
import com.google.android.gms.internal.base.zao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zaa = new Object();
    private static final HashSet zab = new HashSet();
    private static ImageManager zac;
    private final Context zad;
    private final Handler zae;
    private final ExecutorService zaf;
    private final zaj zag;
    private final Map zah;
    private final Map zai;
    private final Map zaj;

    @NonNull
    public static ImageManager create(@NonNull Context context) {
        if (zac == null) {
            Context context2;
            zac = new ImageManager(context2, false);
        }
        return zac;
    }

    private ImageManager(Context context, boolean bl) {
        this.zad = context.getApplicationContext();
        this.zae = new zao(Looper.getMainLooper());
        this.zaf = zan.zaa().zaa(4, 2);
        this.zag = new zaj();
        this.zah = new HashMap();
        this.zai = new HashMap();
        this.zaj = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        this.zaa(new zae((ImageView)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, int resId) {
        void var2_2;
        void var1_1;
        this.zaa(new zae((ImageView)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri, int defaultResId) {
        void var2_2;
        void var1_1;
        void var3_3;
        new zae((ImageView)var1_1, (Uri)var2_2).zab = var3_3;
        this.zaa(new zae((ImageView)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        this.zaa(new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener, @NonNull Uri uri, int defaultResId) {
        void var2_2;
        void var1_1;
        void var3_3;
        new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2).zab = var3_3;
        this.zaa(new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2));
    }

    public final void zaa(zag zag2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zab(this, zag2).run();
    }

    static /* synthetic */ Object zab() {
        return zaa;
    }

    static /* synthetic */ HashSet zac() {
        return zab;
    }

    final /* synthetic */ Context zad() {
        return this.zad;
    }

    final /* synthetic */ Handler zae() {
        return this.zae;
    }

    final /* synthetic */ ExecutorService zaf() {
        return this.zaf;
    }

    final /* synthetic */ zaj zag() {
        return this.zag;
    }

    final /* synthetic */ Map zah() {
        return this.zah;
    }

    final /* synthetic */ Map zai() {
        return this.zai;
    }

    final /* synthetic */ Map zaj() {
        return this.zaj;
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(@NonNull Uri var1, @Nullable Drawable var2, boolean var3);
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zab;
        private final ArrayList zac;

        ImageReceiver(Uri uri) {
            super((Handler)new zao(Looper.getMainLooper()));
            this.zab = uri;
            this.zac = new ArrayList();
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void onReceiveResult(int n, Bundle object) {
            Object object2;
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)object.getParcelable("com.google.android.gms.extra.fileDescriptor");
            if (parcelFileDescriptor != null) {
                object2 = "assetFdStartOffset";
                parcelFileDescriptor = new AssetFileDescriptor(parcelFileDescriptor, object.getLong((String)object2, 0L), object.getLong("assetFdLength", -1L));
            } else {
                parcelFileDescriptor = null;
            }
            object = imageReceiver.ImageManager.this;
            ImageReceiver imageReceiver = imageReceiver.zab;
            object2 = new zaa((ImageManager)object, (Uri)imageReceiver, (AssetFileDescriptor)parcelFileDescriptor);
            ((ImageManager)object).zaf().execute((Runnable)object2);
        }

        public final void zaa(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zac.add(zag2);
        }

        public final void zab(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zac.remove(zag2);
        }

        public final void zac() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)imageReceiver.zab);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)imageReceiver);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageReceiver imageReceiver = imageReceiver.ImageManager.this.zad();
            if (Build.VERSION.SDK_INT < 34) {
                imageReceiver.sendBroadcast(intent);
                return;
            }
            imageReceiver.sendBroadcast(intent, null, BroadcastOptions.makeBasic().setShareIdentityEnabled(true).toBundle());
        }

        final /* synthetic */ ArrayList zad() {
            return this.zac;
        }
    }
}

