/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.zaa;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.server.response.zaj;
import com.google.android.gms.common.server.response.zan;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ShowFirstParty
@KeepForSdk
public abstract class FastJsonResponse {
    @KeepForSdk
    @NonNull
    public abstract Map<String, Field<?, ?>> getFieldMappings();

    @KeepForSdk
    @Nullable
    protected abstract Object getValueObject(@NonNull String var1);

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected boolean isFieldSet(@NonNull Field field) {
        void var1_1;
        if (field.zac == 11) {
            if (var1_1.zad) {
                String cfr_ignored_0 = var1_1.zae;
                throw new UnsupportedOperationException("Concrete type arrays not supported");
            }
            String cfr_ignored_1 = var1_1.zae;
            throw new UnsupportedOperationException("Concrete types not supported");
        }
        return this.isPrimitiveFieldSet(var1_1.zae);
    }

    @KeepForSdk
    protected abstract boolean isPrimitiveFieldSet(@NonNull String var1);

    @KeepForSdk
    protected void setIntegerInternal(@NonNull Field<?, ?> field, @NonNull String string2, int n) {
        throw new UnsupportedOperationException("Integer not supported");
    }

    @KeepForSdk
    protected void setLongInternal(@NonNull Field<?, ?> field, @NonNull String string2, long l) {
        throw new UnsupportedOperationException("Long not supported");
    }

    @KeepForSdk
    protected void setBooleanInternal(@NonNull Field<?, ?> field, @NonNull String string2, boolean bl) {
        throw new UnsupportedOperationException("Boolean not supported");
    }

    @KeepForSdk
    protected void setStringInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable String string3) {
        throw new UnsupportedOperationException("String not supported");
    }

    @KeepForSdk
    protected void setStringsInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<String> arrayList) {
        throw new UnsupportedOperationException("String list not supported");
    }

    @KeepForSdk
    protected void setDecodedBytesInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable byte[] byArray) {
        throw new UnsupportedOperationException("byte[] not supported");
    }

    @KeepForSdk
    protected void setStringMapInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable Map<String, String> map) {
        throw new UnsupportedOperationException("String map not supported");
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeInternal(@NonNull Field field, @NonNull String string2, @NonNull T t) {
        throw new UnsupportedOperationException("Concrete type not supported");
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(@NonNull Field field, @NonNull String string2, @Nullable ArrayList<T> arrayList) {
        throw new UnsupportedOperationException("Concrete type array not supported");
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Field<?, ?> field2 = field;
            Object object = FastJsonResponse.zaD(field2, this.getFieldValue(field2));
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append(string2);
            stringBuilder.append("\":");
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zac) {
                default: {
                    if (field.zab) {
                        object = (ArrayList)object;
                        stringBuilder.append("[");
                        int n = ((ArrayList)object).size();
                        for (int i = 0; i < n; ++i) {
                            Object e;
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            if ((e = ((ArrayList)object).get(i)) == null) continue;
                            FastJsonResponse.zaF(stringBuilder, field, e);
                        }
                        stringBuilder.append("]");
                        continue block5;
                    }
                    FastJsonResponse.zaF(stringBuilder, field, object);
                    continue block5;
                }
                case 8: {
                    stringBuilder.append("\"");
                    stringBuilder.append(Base64Utils.encode((byte[])((byte[])object)));
                    stringBuilder.append("\"");
                    continue block5;
                }
                case 10: {
                    MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)((HashMap)object));
                    continue block5;
                }
                case 9: 
            }
            stringBuilder.append("\"");
            stringBuilder.append(Base64Utils.encodeUrlSafe((byte[])((byte[])object)));
            stringBuilder.append("\"");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        stringBuilder.append("{}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @Nullable
    protected Object getFieldValue(@NonNull Field field) {
        void var1_2;
        String string2 = field.zae;
        String string3 = "get";
        if (var1_2.zag == null) return ((FastJsonResponse)this).getValueObject(string2);
        boolean bl = ((FastJsonResponse)this).getValueObject(string2) == null;
        Object[] objectArray = new Object[]{string2};
        Preconditions.checkState((boolean)bl, (String)"Concrete field shouldn't be value object: %s", (Object[])objectArray);
        boolean cfr_ignored_0 = var1_2.zad;
        try {
            char c = Character.toUpperCase(string2.charAt(0));
            String string4 = string2.substring(1);
            int n = String.valueOf(c).length() + 3 + String.valueOf(string4).length();
            StringBuilder stringBuilder = new StringBuilder(n);
            stringBuilder.append(string3);
            stringBuilder.append(c);
            stringBuilder.append(string4);
            String string5 = stringBuilder.toString();
            return this.getClass().getMethod(string5, new Class[0]).invoke(this, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private final void zaE(Field field, @Nullable Object object) {
        int n = field.zac;
        object = field.zah(object);
        String string2 = field.zae;
        switch (n) {
            case 8: 
            case 9: {
                if (object != null) {
                    this.setDecodedBytesInternal(field, string2, (byte[])object);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 7: {
                this.setStringInternal(field, string2, (String)object);
                return;
            }
            case 6: {
                if (object != null) {
                    this.setBooleanInternal(field, string2, (Boolean)object);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 5: {
                this.zaA(field, string2, (BigDecimal)object);
                return;
            }
            case 2: {
                if (object != null) {
                    this.setLongInternal(field, string2, (Long)object);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 4: {
                if (object != null) {
                    this.zay(field, string2, (Double)object);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 1: {
                this.zat(field, string2, (BigInteger)object);
                return;
            }
            case 0: {
                if (object == null) break;
                this.setIntegerInternal(field, string2, (Integer)object);
                return;
            }
            default: {
                int n2 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 33);
                stringBuilder.append("Unsupported type for conversion: ");
                stringBuilder.append(n);
                throw new IllegalStateException(stringBuilder.toString());
            }
        }
        FastJsonResponse.zaG(string2);
    }

    public final void zaa(@NonNull Field field, int n) {
        if (field.zaj() != null) {
            this.zaE(field, n);
            return;
        }
        Field field2 = field;
        this.setIntegerInternal(field2, field2.zae, n);
    }

    public final void zab(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zas(field2, field2.zae, arrayList);
    }

    public final void zac(@NonNull Field field, @Nullable BigInteger bigInteger) {
        if (field.zaj() != null) {
            this.zaE(field, bigInteger);
            return;
        }
        Field field2 = field;
        this.zat(field2, field2.zae, bigInteger);
    }

    public final void zad(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zau(field2, field2.zae, arrayList);
    }

    public final void zae(@NonNull Field field, long l) {
        if (field.zaj() != null) {
            this.zaE(field, l);
            return;
        }
        Field field2 = field;
        this.setLongInternal(field2, field2.zae, l);
    }

    public final void zaf(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zav(field2, field2.zae, arrayList);
    }

    public final void zag(@NonNull Field field, float f) {
        if (field.zaj() != null) {
            this.zaE(field, Float.valueOf(f));
            return;
        }
        Field field2 = field;
        this.zaw(field2, field2.zae, f);
    }

    public final void zah(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zax(field2, field2.zae, arrayList);
    }

    public final void zai(@NonNull Field field, double d) {
        if (field.zaj() != null) {
            this.zaE(field, d);
            return;
        }
        Field field2 = field;
        this.zay(field2, field2.zae, d);
    }

    public final void zaj(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zaz(field2, field2.zae, arrayList);
    }

    public final void zak(@NonNull Field field, @Nullable BigDecimal bigDecimal) {
        if (field.zaj() != null) {
            this.zaE(field, bigDecimal);
            return;
        }
        Field field2 = field;
        this.zaA(field2, field2.zae, bigDecimal);
    }

    public final void zal(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zaB(field2, field2.zae, arrayList);
    }

    public final void zam(@NonNull Field field, boolean bl) {
        if (field.zaj() != null) {
            this.zaE(field, bl);
            return;
        }
        Field field2 = field;
        this.setBooleanInternal(field2, field2.zae, bl);
    }

    public final void zan(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.zaC(field2, field2.zae, arrayList);
    }

    public final void zao(@NonNull Field field, @Nullable String string2) {
        if (field.zaj() != null) {
            this.zaE(field, string2);
            return;
        }
        Field field2 = field;
        this.setStringInternal(field2, field2.zae, string2);
    }

    public final void zap(@NonNull Field field, @Nullable ArrayList arrayList) {
        if (field.zaj() != null) {
            this.zaE(field, arrayList);
            return;
        }
        Field field2 = field;
        this.setStringsInternal(field2, field2.zae, arrayList);
    }

    public final void zaq(@NonNull Field field, @Nullable byte[] byArray) {
        if (field.zaj() != null) {
            this.zaE(field, byArray);
            return;
        }
        Field field2 = field;
        this.setDecodedBytesInternal(field2, field2.zae, byArray);
    }

    public final void zar(@NonNull Field field, @Nullable Map map) {
        if (field.zaj() != null) {
            this.zaE(field, map);
            return;
        }
        Field field2 = field;
        this.setStringMapInternal(field2, field2.zae, map);
    }

    protected void zas(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("Integer list not supported");
    }

    protected void zat(@NonNull Field field, @NonNull String string2, @Nullable BigInteger bigInteger) {
        throw new UnsupportedOperationException("BigInteger not supported");
    }

    protected void zau(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("BigInteger list not supported");
    }

    protected void zav(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("Long list not supported");
    }

    protected void zaw(@NonNull Field field, @NonNull String string2, float f) {
        throw new UnsupportedOperationException("Float not supported");
    }

    protected void zax(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("Float list not supported");
    }

    protected void zay(@NonNull Field field, @NonNull String string2, double d) {
        throw new UnsupportedOperationException("Double not supported");
    }

    protected void zaz(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("Double list not supported");
    }

    protected void zaA(@NonNull Field field, @NonNull String string2, @Nullable BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal not supported");
    }

    protected void zaB(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("BigDecimal list not supported");
    }

    protected void zaC(@NonNull Field field, @NonNull String string2, @Nullable ArrayList arrayList) {
        throw new UnsupportedOperationException("Boolean list not supported");
    }

    private static final void zaF(StringBuilder stringBuilder, Field field, Object object) {
        int n = field.zaa;
        if (n != 11) {
            if (n == 7) {
                stringBuilder.append("\"");
                stringBuilder.append(JsonUtils.escapeString((String)((String)object)));
                stringBuilder.append("\"");
                return;
            }
            stringBuilder.append(object);
            return;
        }
        Class clazz = field.zag;
        Preconditions.checkNotNull((Object)clazz);
        stringBuilder.append(((FastJsonResponse)clazz.cast(object)).toString());
    }

    @NonNull
    protected static final Object zaD(@NonNull Field field, @Nullable Object object) {
        if (field.zaj() != null) {
            return field.zai(object);
        }
        return object;
    }

    private static final void zaG(String string2) {
        if (Log.isLoggable((String)"FastJsonResponse", (int)6)) {
            int n = String.valueOf(string2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 58);
            stringBuilder.append("Output field (");
            stringBuilder.append(string2);
            stringBuilder.append(") has a null value, but expected a primitive");
            string2 = stringBuilder.toString();
            Log.e((String)"FastJsonResponse", (String)string2);
            return;
        }
    }

    @ShowFirstParty
    @SafeParcelable.Class(creator="FieldCreator")
    @KeepForSdk
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zai;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int zaa;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean zab;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int zac;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean zad;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        @NonNull
        protected final String zae;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int zaf;
        @Nullable
        protected final Class zag;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        @Nullable
        protected final String zah;
        private zan zaj;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        @Nullable
        private final FieldConverter zak;
        public static final zaj CREATOR = new zaj();

        /*
         * Enabled aggressive block sorting
         */
        protected Field(int n, boolean bl, int n2, boolean bl2, @NonNull String string2, int n3, @Nullable Class clazz, @Nullable FieldConverter fieldConverter) {
            this.zai = 1;
            this.zaa = n;
            this.zab = bl;
            this.zac = n2;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n3;
            this.zag = clazz;
            this.zah = clazz == null ? null : clazz.getCanonicalName();
            this.zak = fieldConverter;
        }

        @KeepForSdk
        public int getSafeParcelableFieldId() {
            return this.zaf;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Integer, Integer> forInteger(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<Integer, Integer>(0, false, 0, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Long, Long> forLong(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<Long, Long>(2, false, 2, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Float, Float> forFloat(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<Float, Float>(3, false, 3, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Double, Double> forDouble(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<Double, Double>(4, false, 4, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Boolean, Boolean> forBoolean(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<String, String> forString(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<String, String>(7, false, 7, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<ArrayList<String>, ArrayList<String>> forStrings(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<byte[], byte[]> forBase64(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<byte[], byte[]>(8, false, 8, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            return new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(@NonNull String fieldName, int safeParcelableId, @NonNull Class<T> type) {
            void var2_2;
            void var1_1;
            String string2;
            return new Field(11, false, 11, false, string2, (int)var1_1, (Class)var2_2, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(@NonNull String fieldName, int safeParcelableId, @NonNull Class<T> type) {
            void var2_2;
            void var1_1;
            String string2;
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, (int)var1_1, (Class)var2_2, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field withConverter(@NonNull String outputFieldName, int safeParcelableId, @NonNull FieldConverter<?, ?> converter, boolean inputArrayType) {
            void var1_1;
            String string2;
            void var3_3;
            void var2_2;
            var2_2.zaa();
            var2_2.zab();
            return new Field(7, (boolean)var3_3, 0, false, string2, (int)var1_1, null, (FieldConverter)var2_2);
        }

        public final void writeToParcel(@NonNull Parcel parcel, int n) {
            int n2 = this.zai;
            int n3 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)n2);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.zaa);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)3, (boolean)this.zab);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zac);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.zad);
            SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zae, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.getSafeParcelableFieldId());
            SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zab(), (boolean)false);
            Parcel parcel2 = parcel;
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)this.zae(), (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n3);
        }

        @NonNull
        public final String toString() {
            int n = ((Field)((Object)object)).zai;
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)object).add("versionCode", (Object)n);
            n = ((Field)((Object)object)).zaa;
            Objects.ToStringHelper toStringHelper2 = toStringHelper.add("typeIn", (Object)n);
            n = ((Field)((Object)object)).zab ? 1 : 0;
            Objects.ToStringHelper toStringHelper3 = toStringHelper2.add("typeInArray", (Object)(n != 0));
            n = ((Field)((Object)object)).zac;
            Objects.ToStringHelper toStringHelper4 = toStringHelper3.add("typeOut", (Object)n);
            n = ((Field)((Object)object)).zad ? 1 : 0;
            Objects.ToStringHelper toStringHelper5 = toStringHelper4.add("typeOutArray", (Object)(n != 0)).add("outputFieldName", (Object)((Field)((Object)object)).zae);
            n = ((Field)((Object)object)).zaf;
            Objects.ToStringHelper toStringHelper6 = toStringHelper5.add("safeParcelFieldId", (Object)n).add("concreteTypeName", (Object)((Field)((Object)object)).zab());
            Class clazz = ((Field)((Object)object)).zag;
            if (clazz != null) {
                toStringHelper6.add("concreteType.class", (Object)clazz.getCanonicalName());
            }
            if ((object = ((Field)((Object)object)).zak) != null) {
                Object object = object.getClass().getCanonicalName();
                toStringHelper6.add("converterName", object);
            }
            return toStringHelper6.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable zaa zaa2) {
            this.zai = n;
            this.zaa = n2;
            this.zab = bl;
            this.zac = n3;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n4;
            if (string3 == null) {
                this.zag = null;
                this.zah = null;
            } else {
                this.zag = SafeParcelResponse.class;
                this.zah = string3;
            }
            if (zaa2 == null) {
                this.zak = null;
                return;
            }
            this.zak = zaa2.zab();
        }

        @NonNull
        public final Field zaa() {
            return new Field<I, O>(this.zai, this.zaa, this.zab, this.zac, this.zad, this.zae, this.zaf, this.zah, this.zae());
        }

        @Nullable
        final String zab() {
            Object object = object.zah;
            if (object == null) {
                return null;
            }
            return object;
        }

        public final boolean zac() {
            return this.zak != null;
        }

        public final void zad(zan zan2) {
            this.zaj = zan2;
        }

        @Nullable
        final zaa zae() {
            Object object = object.zak;
            if (object == null) {
                return null;
            }
            return com.google.android.gms.common.server.converter.zaa.zaa((FieldConverter)object);
        }

        @NonNull
        public final FastJsonResponse zaf() throws InstantiationException, IllegalAccessException {
            Object object = this.zag;
            Preconditions.checkNotNull((Object)object);
            if (object == SafeParcelResponse.class) {
                object = this.zah;
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)((Object)this.zaj), (Object)"The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                return new SafeParcelResponse(this.zaj, (String)object);
            }
            return (FastJsonResponse)((Class)object).newInstance();
        }

        @NonNull
        public final Map zag() {
            String string2 = this.zah;
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)((Object)this.zaj));
            return (Map)Preconditions.checkNotNull((Object)this.zaj.zad(string2));
        }

        @NonNull
        public final Object zah(@Nullable Object object) {
            FieldConverter fieldConverter = this.zak;
            Preconditions.checkNotNull((Object)fieldConverter);
            return Preconditions.checkNotNull((Object)fieldConverter.zad(object));
        }

        @NonNull
        public final Object zai(@NonNull Object object) {
            FieldConverter fieldConverter = this.zak;
            Preconditions.checkNotNull((Object)fieldConverter);
            return fieldConverter.zac(object);
        }

        final /* synthetic */ FieldConverter zaj() {
            return this.zak;
        }
    }

    @ShowFirstParty
    public static interface FieldConverter<I, O> {
        public int zaa();

        public int zab();

        @Nullable
        public Object zad(@NonNull Object var1);

        @NonNull
        public Object zac(@NonNull Object var1);
    }
}

