/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.moduleinstall.internal;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.OptionalModuleApi;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.moduleinstall.InstallStatusListener;
import com.google.android.gms.common.moduleinstall.ModuleAvailabilityResponse;
import com.google.android.gms.common.moduleinstall.ModuleInstallClient;
import com.google.android.gms.common.moduleinstall.ModuleInstallIntentResponse;
import com.google.android.gms.common.moduleinstall.ModuleInstallRequest;
import com.google.android.gms.common.moduleinstall.ModuleInstallResponse;
import com.google.android.gms.common.moduleinstall.internal.ApiFeatureRequest;
import com.google.android.gms.common.moduleinstall.internal.zaab;
import com.google.android.gms.common.moduleinstall.internal.zai;
import com.google.android.gms.common.moduleinstall.internal.zaq;
import com.google.android.gms.common.moduleinstall.internal.zar;
import com.google.android.gms.common.moduleinstall.internal.zas;
import com.google.android.gms.common.moduleinstall.internal.zat;
import com.google.android.gms.common.moduleinstall.internal.zau;
import com.google.android.gms.common.moduleinstall.internal.zav;
import com.google.android.gms.common.moduleinstall.internal.zaw;
import com.google.android.gms.common.moduleinstall.internal.zax;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zay
extends GoogleApi
implements ModuleInstallClient {
    private static final Api.ClientKey zac = new Api.ClientKey();
    private static final Api.AbstractClientBuilder zad = new zai();
    private static final Api zae = new Api("ModuleInstall.API", zad, zac);
    public static final /* synthetic */ int zab;

    public zay(Context context) {
        super(context, zae, Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zay(Activity activity) {
        super(activity, zae, Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @Override
    public final Task<ModuleAvailabilityResponse> areModulesAvailable(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult((Object)((Object)new ModuleAvailabilityResponse(true, 0)));
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        builder.setFeatures(zap.zaa);
        builder.setMethodKey(27301);
        builder.setAutoResolveMissingFeatures(false);
        builder.run(new zax(this, (ApiFeatureRequest)((Object)object)));
        return this.doRead(builder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Void> deferredInstall(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult(null);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        builder.setFeatures(zap.zaa);
        builder.setMethodKey(27302);
        builder.setAutoResolveMissingFeatures(false);
        builder.run(new zaq((zay)this, (ApiFeatureRequest)((Object)object)));
        return this.doRead(builder.build());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<ModuleInstallResponse> installModules(ModuleInstallRequest listenerHolder) {
        ApiFeatureRequest apiFeatureRequest = ApiFeatureRequest.fromModuleInstallRequest(listenerHolder);
        InstallStatusListener installStatusListener = ((ModuleInstallRequest)((Object)listenerHolder)).getListener();
        listenerHolder = ((ModuleInstallRequest)((Object)listenerHolder)).getListenerExecutor();
        if (apiFeatureRequest.getApiFeatures().isEmpty()) {
            return Tasks.forResult((Object)((Object)new ModuleInstallResponse(0)));
        }
        if (installStatusListener == null) {
            TaskApiCall.Builder builder = TaskApiCall.builder();
            builder.setFeatures(zap.zaa);
            builder.setAutoResolveMissingFeatures(true);
            builder.setMethodKey(27304);
            builder.run(new zar((zay)this, apiFeatureRequest));
            return this.doRead(builder.build());
        }
        Preconditions.checkNotNull((Object)installStatusListener);
        listenerHolder = listenerHolder == null ? this.registerListener(installStatusListener, InstallStatusListener.class.getSimpleName()) : ListenerHolders.createListenerHolder(installStatusListener, (Executor)((Object)listenerHolder), InstallStatusListener.class.getSimpleName());
        zaab zaab2 = new zaab(listenerHolder);
        AtomicReference atomicReference = new AtomicReference();
        Task task = this;
        zas zas2 = new zas((zay)task, atomicReference, installStatusListener, apiFeatureRequest, zaab2);
        zat zat2 = new zat((zay)this, zaab2);
        RegistrationMethods.Builder builder = RegistrationMethods.builder();
        builder.withHolder(listenerHolder);
        builder.setFeatures(zap.zaa);
        builder.setAutoResolveMissingFeatures(true);
        builder.register(zas2);
        builder.unregister(zat2);
        builder.setMethodKey(27305);
        return task.doRegisterEventListener(builder.build()).onSuccessTask((SuccessContinuation)new zau(atomicReference));
    }

    @Override
    public final Task<ModuleInstallIntentResponse> getInstallModulesIntent(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(true, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult((Object)((Object)new ModuleInstallIntentResponse(null)));
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        builder.setFeatures(zap.zaa);
        builder.setMethodKey(27307);
        builder.run(new zav(this, (ApiFeatureRequest)((Object)object)));
        return this.doRead(builder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Void> releaseModules(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult(null);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        builder.setFeatures(zap.zaa);
        builder.setMethodKey(27303);
        builder.setAutoResolveMissingFeatures(false);
        builder.run(new zaw((zay)this, (ApiFeatureRequest)((Object)object)));
        return this.doRead(builder.build());
    }

    @Override
    public final Task<Boolean> unregisterListener(InstallStatusListener installStatusListener) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey(installStatusListener, InstallStatusListener.class.getSimpleName()), 27306);
    }

    /*
     * Enabled aggressive block sorting
     */
    static final ApiFeatureRequest zad(boolean bl, OptionalModuleApi ... optionalModuleApiArray) {
        Preconditions.checkNotNull((Object)optionalModuleApiArray, (Object)"Requested APIs must not be null.");
        int n = optionalModuleApiArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkArgument(n2 != 0, (Object)"Please provide at least one OptionalModuleApi.");
        n2 = 0;
        while (n2 < n) {
            Preconditions.checkNotNull((Object)optionalModuleApiArray[n2], (Object)"Requested API must not be null.");
            ++n2;
        }
        return ApiFeatureRequest.zaa(Arrays.asList(optionalModuleApiArray), bl);
    }
}

