/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zad;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<DataHolder> CREATOR = new zad();
    @SafeParcelable.VersionField(id=1000)
    final int zaa;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zaf;
    Bundle zab;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zag;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zah;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    @Nullable
    private final Bundle zai;
    int[] zac;
    int zad;
    boolean zae;
    private boolean zaj;
    private static final Builder zak = new zab(new String[0], null);

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) @Nullable Bundle bundle) {
        this.zae = false;
        this.zaj = true;
        this.zaa = n;
        this.zaf = stringArray;
        this.zag = cursorWindowArray;
        this.zah = n2;
        this.zai = bundle;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public DataHolder(@NonNull String[] columns, @NonNull CursorWindow[] windows, int statusCode, @Nullable Bundle metadata) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae = false;
        this.zaj = true;
        this.zaa = 1;
        this.zaf = (String[])Preconditions.checkNotNull((Object)var1_1);
        this.zag = (CursorWindow[])Preconditions.checkNotNull((Object)var2_2);
        this.zah = var3_3;
        this.zai = var4_4;
        this.zaa();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataHolder(@NonNull Cursor cursor, int statusCode, @Nullable Bundle metadata) {
        void var3_5;
        void var2_4;
        CursorWindow cursorWindow;
        CursorWrapper cursorWrapper = new CursorWrapper((Cursor)cursorWindow);
        String[] stringArray = cursorWrapper.getColumnNames();
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n;
            int n2;
            int n3 = cursorWrapper.getCount();
            cursorWindow = cursorWrapper.getWindow();
            if (cursorWindow != null) {
                n2 = cursorWindow.getStartPosition();
                if (n2 == 0) {
                    cursorWindow.acquireReference();
                    cursorWrapper.setWindow(null);
                    arrayList.add(cursorWindow);
                    n = cursorWindow.getNumRows();
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
            while (n < n3 && (n2 = (int)(cursorWrapper.moveToPosition(n) ? 1 : 0)) != 0) {
                CursorWindow cursorWindow2;
                CursorWindow cursorWindow3 = cursorWrapper.getWindow();
                if (cursorWindow3 != null) {
                    cursorWindow3.acquireReference();
                    cursorWrapper.setWindow(null);
                    cursorWindow2 = cursorWindow3;
                } else {
                    int n4 = n;
                    new CursorWindow(false).setStartPosition(n4);
                    cursorWrapper.fillWindow(n4, cursorWindow2);
                }
                if ((n2 = cursorWindow2.getNumRows()) != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition();
                    n = cursorWindow2.getNumRows();
                    n = n2 + n;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            cursorWrapper.close();
            throw throwable;
        }
        cursorWrapper.close();
        ArrayList<CursorWindow> arrayList2 = arrayList;
        this(stringArray, arrayList2.toArray(new CursorWindow[arrayList2.size()]), (int)var2_4, (Bundle)var3_5);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle) {
        this(builder.zab(), DataHolder.zae(builder, -1), n, null);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        String[] stringArray = this.zaf;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringArray((Parcel)parcel, (int)1, (String[])stringArray, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.zag, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)4, (Bundle)this.getMetadata(), (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)this.zaa);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
            return;
        }
    }

    @KeepForSdk
    public int getStatusCode() {
        return this.zah;
    }

    @KeepForSdk
    @Nullable
    public Bundle getMetadata() {
        return this.zai;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasColumn(@NonNull String column) {
        void var1_1;
        return this.zab.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public long getLong(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return this.zag[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int getInteger(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return this.zag[var3_3].getInt((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public String getString(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return this.zag[var3_3].getString((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean getBoolean(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return Long.valueOf(this.zag[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1))) == 1L;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public byte[] getByteArray(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return this.zag[var3_3].getBlob((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasNull(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaf((String)var1_1, (int)var2_2);
        return this.zag[var3_3].isNull((int)var2_2, this.zab.getInt((String)var1_1));
    }

    @KeepForSdk
    public int getCount() {
        return this.zad;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public int getWindowIndex(int row) {
        void var1_1;
        int n = row >= 0 ? (var1_1 < this.zad ? 1 : 0) : 0;
        Preconditions.checkState(n != 0);
        n = 0;
        while (true) {
            block6: {
                int n2;
                block5: {
                    int[] nArray;
                    if (n >= (n2 = (nArray = this.zac).length)) break block5;
                    if (var1_1 >= nArray[n]) break block6;
                    --n;
                }
                if (n == n2) {
                    return n + -1;
                }
                return n;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isClosed() {
        synchronized (this) {
            return this.zae;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void close() {
        synchronized (this) {
            CursorWindow[] cursorWindowArray;
            int n;
            int n2 = this.zae;
            if (n2 != 0) return;
            this.zae = true;
            for (n2 = 0; n2 < (n = (cursorWindowArray = this.zag).length); ++n2) {
                cursorWindowArray[n2].close();
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        block5: {
            int n;
            String string2 = ")";
            String string3 = "Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ";
            try {
                n = this.zaj;
                if (n == 0) break block5;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            n = this.zag.length;
            if (n <= 0) break block5;
            n = this.isClosed() ? 1 : 0;
            if (n != 0) break block5;
            this.close();
            String string4 = "DataBuffer";
            String string5 = this.toString();
            int n2 = String.valueOf(string5).length();
            StringBuilder stringBuilder = new StringBuilder(n2 += 178);
            stringBuilder.append(string3);
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            Log.e((String)string4, (String)stringBuilder.toString());
        }
        super.finalize();
    }

    @KeepForSdk
    @NonNull
    public static Builder builder(@NonNull String[] columns) {
        String[] stringArray;
        return new Builder(stringArray, null, null);
    }

    @KeepForSdk
    @NonNull
    public static DataHolder empty(int statusCode) {
        int n;
        return new DataHolder(zak, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, byte[] byArray) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, byte[] byArray) {
        this(builder.zab(), DataHolder.zae(builder, -1), n, bundle);
    }

    public final void zaa() {
        String[] stringArray;
        int n;
        this.zab = new Bundle();
        for (n = 0; n < (stringArray = this.zaf).length; ++n) {
            this.zab.putInt(stringArray[n], n);
        }
        CursorWindow[] cursorWindowArray = this.zag;
        this.zac = new int[cursorWindowArray.length];
        n = 0;
        for (int i = 0; i < cursorWindowArray.length; ++i) {
            this.zac[i] = n;
            int n2 = n - cursorWindowArray[i].getStartPosition();
            n += cursorWindowArray[i].getNumRows() - n2;
        }
        this.zad = n;
    }

    /*
     * Exception decompiling
     */
    private static CursorWindow[] zae(Builder var0, int var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 18[TRYBLOCK] [18 : 735->757)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void zaf(String string2, int n) {
        Bundle bundle = ((DataHolder)((Object)string3)).zab;
        if (bundle == null || !bundle.containsKey(string2)) {
            String.valueOf(string2);
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException("No such column: ".concat(string3));
        }
        if (((DataHolder)((Object)string3)).isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= ((DataHolder)((Object)string3)).zad) {
            throw new CursorIndexOutOfBoundsException(n, ((DataHolder)((Object)string3)).zad);
        }
    }

    public final float zab(@NonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getFloat(n, this.zab.getInt(string2));
    }

    public final double zac(@NonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getDouble(n, this.zab.getInt(string2));
    }

    public final void zad(@NonNull String string2, int n, int n2, @NonNull CharArrayBuffer charArrayBuffer) {
        this.zaf(string2, n);
        this.zag[n2].copyStringToBuffer(n, this.zab.getInt(string2), charArrayBuffer);
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zaa;
        private final ArrayList zab;
        private final HashMap zac;

        @KeepForSdk
        @NonNull
        public Builder withRow(@NonNull ContentValues values) {
            Iterator iterator;
            Asserts.checkNotNull((Object)values);
            HashMap hashMap = new HashMap(iterator.size());
            for (Map.Entry entry : iterator.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode) {
            void var1_1;
            return new DataHolder(this, (int)var1_1, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode, @NonNull Bundle metadata) {
            void var2_2;
            void var1_1;
            return new DataHolder(this, (int)var1_1, (Bundle)var2_2, -1, null);
        }

        /* synthetic */ Builder(String[] stringArray, String string2, byte[] byArray) {
            this.zaa = (String[])Preconditions.checkNotNull((Object)stringArray);
            this.zab = new ArrayList();
            this.zac = new HashMap();
        }

        @NonNull
        public Builder zaa(@NonNull HashMap hashMap) {
            Asserts.checkNotNull((Object)hashMap);
            this.zab.add(hashMap);
            return this;
        }

        final /* synthetic */ String[] zab() {
            return this.zaa;
        }

        final /* synthetic */ ArrayList zac() {
            return this.zab;
        }
    }
}

