/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.jx;

public class g
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean KC;
    private int KD = -1;
    private ConnectionResult KE;
    private final Handler KF = new Handler(Looper.getMainLooper());
    private final SparseArray<b> KG = new SparseArray();

    public static g a(FragmentActivity fragmentActivity) {
        g g2;
        jx.aU("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            g2 = (g)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (g2 == null || g2.isRemoving()) {
            g2 = new g();
            fragmentManager.beginTransaction().add((Fragment)g2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return g2;
    }

    public GoogleApiClient an(int n2) {
        a a2;
        if (this.getActivity() != null && (a2 = this.ap(n2)) != null) {
            return a2.KH;
        }
        return null;
    }

    public void a(int n2, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        jx.b(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        jx.a(this.KG.indexOfKey(n2) < 0, "Already managing a GoogleApiClient with id " + n2);
        b b2 = new b(googleApiClient, onConnectionFailedListener);
        this.KG.put(n2, (Object)b2);
        if (this.getActivity() != null) {
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void ao(int n2) {
        this.getLoaderManager().destroyLoader(n2);
        this.KG.remove(n2);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.b(this.KD, this.KE);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i2 = 0; i2 < this.KG.size(); ++i2) {
            int n2 = this.KG.keyAt(i2);
            a a2 = this.ap(n2);
            if (a2 != null) {
                b b2 = (b)this.KG.valueAt(i2);
                if (b2.KH != a2.KH) {
                    this.getLoaderManager().restartLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.KC = savedInstanceState.getBoolean("resolving_error", false);
            this.KD = savedInstanceState.getInt("failed_client_id", -1);
            if (this.KD >= 0) {
                this.KE = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.KC);
        if (this.KD >= 0) {
            outState.putInt("failed_client_id", this.KD);
            outState.putInt("failed_status", this.KE.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.KE.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.KC) {
            for (int i2 = 0; i2 < this.KG.size(); ++i2) {
                this.getLoaderManager().initLoader(this.KG.keyAt(i2), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl2 = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl2 = true;
            }
        }
        if (bl2) {
            this.gR();
        } else {
            this.b(this.KD, this.KE);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new a((Context)this.getActivity(), ((b)this.KG.get((int)id)).KH);
    }

    public void a(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.aq(loader.getId());
        } else {
            this.a(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
        if (loader.getId() == this.KD) {
            this.gR();
        }
    }

    a ap(int n2) {
        try {
            return (a)this.getLoaderManager().getLoader(n2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void aq(int n2) {
        if (n2 == this.KD) {
            this.gR();
        }
    }

    private void a(int n2, ConnectionResult connectionResult) {
        if (!this.KC) {
            this.KC = true;
            this.KD = n2;
            this.KE = connectionResult;
            this.KF.post((Runnable)new c(n2, connectionResult));
        }
    }

    private void b(int n2, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        b b2 = (b)this.KG.get(n2);
        if (b2 != null) {
            this.ao(n2);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = b2.KK;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.gR();
    }

    private void gR() {
        this.KC = false;
        this.KD = -1;
        this.KE = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i2 = 0; i2 < this.KG.size(); ++i2) {
            int n2 = this.KG.keyAt(i2);
            a a2 = this.ap(n2);
            if (a2 != null) {
                a2.gS();
            }
            loaderManager.initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.a((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class a
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient KH;
        private boolean KI;
        private ConnectionResult KJ;

        public a(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.KH = googleApiClient;
        }

        public void gS() {
            if (this.KI) {
                this.KI = false;
                if (this.isStarted() && !this.isAbandoned()) {
                    this.KH.connect();
                }
            }
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.KH.registerConnectionCallbacks(this);
            this.KH.registerConnectionFailedListener(this);
            if (this.KJ != null) {
                this.deliverResult(this.KJ);
            }
            if (!(this.KH.isConnected() || this.KH.isConnecting() || this.KI)) {
                this.KH.connect();
            }
        }

        protected void onStopLoading() {
            this.KH.disconnect();
        }

        protected void onReset() {
            this.KJ = null;
            this.KI = false;
            this.KH.unregisterConnectionCallbacks(this);
            this.KH.unregisterConnectionFailedListener(this);
            this.KH.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.KI = false;
            this.a(ConnectionResult.Iu);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.KI = true;
            this.a(result);
        }

        private void a(ConnectionResult connectionResult) {
            this.KJ = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class b {
        public final GoogleApiClient KH;
        public final GoogleApiClient.OnConnectionFailedListener KK;

        private b(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.KH = googleApiClient;
            this.KK = onConnectionFailedListener;
        }
    }

    private class c
    implements Runnable {
        private final int KL;
        private final ConnectionResult KM;

        public c(int n2, ConnectionResult connectionResult) {
            this.KL = n2;
            this.KM = connectionResult;
        }

        @Override
        public void run() {
            if (this.KM.hasResolution()) {
                try {
                    int n2 = g.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)g.this);
                    int n3 = 1 + (1 + n2 << 16);
                    this.KM.startResolutionForResult((Activity)g.this.getActivity(), n3);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    g.this.gR();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.KM.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.KM.getErrorCode(), (Activity)g.this.getActivity(), g.this, 2, g.this);
            } else {
                g.this.b(this.KL, this.KM);
            }
        }
    }
}

