/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zza;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzr;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzHk = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName zzHl = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");

    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope);
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope, extras);
    }

    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, account, scope, new Bundle());
    }

    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.zza(context, account, scope, extras, null);
    }

    public static String zza(Context context, Account account, String string2, Bundle bundle, Boolean bl) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Context context2 = context.getApplicationContext();
        zzx.zzbe("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzI(context2);
        bundle = bundle == null ? new Bundle() : new Bundle(bundle);
        String string3 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string3);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string3);
        }
        if (bl != null) {
            bundle.putBoolean("UseCache", bl.booleanValue());
        }
        zza zza2 = new zza();
        zzm zzm2 = zzm.zzP(context2);
        if (zzm2.zza(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                zzr zzr2 = zzr.zza.zza(zza2.zzhJ());
                Bundle bundle2 = zzr2.zza(account, string2, bundle);
                if (bundle2 == null) {
                    Log.w((String)"GoogleAuthUtil", (String)"Binder call returned null.");
                    throw new GoogleAuthException("ServiceUnavailable");
                }
                String string4 = bundle2.getString("authtoken");
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    String string5 = string4;
                    return string5;
                }
                try {
                    String string6 = bundle2.getString("Error");
                    Intent intent = (Intent)bundle2.getParcelable("userRecoveryIntent");
                    if (GoogleAuthUtil.zzaD(string6)) {
                        throw new UserRecoverableAuthException(string6, intent);
                    }
                    if (GoogleAuthUtil.zzaC(string6)) {
                        throw new IOException(string6);
                    }
                    throw new GoogleAuthException(string6);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
            }
            finally {
                zzm2.zzb(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, callback);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, authority, syncBundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zza(context, account, scope, extras);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.zzh(callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zza(context, account, scope, extras);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new IllegalArgumentException("Authority cannot be empty or null.");
        }
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zza(context, account, scope, extras);
    }

    @Deprecated
    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    public static void clearToken(Context context, String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        block9: {
            Context context2 = context.getApplicationContext();
            zzx.zzbe("Calling this from your main thread can lead to deadlock");
            GoogleAuthUtil.zzI(context2);
            Bundle bundle = new Bundle();
            String string2 = context.getApplicationInfo().packageName;
            bundle.putString("clientPackageName", string2);
            if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
                bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
            }
            zza zza2 = new zza();
            zzm zzm2 = zzm.zzP(context2);
            if (zzm2.zza(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil")) {
                try {
                    zzr zzr2 = zzr.zza.zza(zza2.zzhJ());
                    Bundle bundle2 = zzr2.zza(token, bundle);
                    String string3 = bundle2.getString(zzjo.zzIi);
                    if (!bundle2.getBoolean("booleanResult")) {
                        throw new GoogleAuthException(string3);
                    }
                    break block9;
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
                finally {
                    zzm2.zzb(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil");
                }
            }
            throw new IOException("Could not bind to service with the given context.");
        }
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context ctx, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        zzx.zzb(accountName, (Object)"accountName must be provided");
        zzx.zzbe("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.zzI(context);
        zza zza2 = new zza();
        zzm zzm2 = zzm.zzP(context);
        if (zzm2.zza(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                zzr zzr2 = zzr.zza.zza(zza2.zzhJ());
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(accountName).setEventIndex(eventIndex);
                AccountChangeEventsResponse accountChangeEventsResponse = zzr2.zza(accountChangeEventsRequest);
                List<AccountChangeEvent> list = accountChangeEventsResponse.getEvents();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("remote exception");
            }
            catch (InterruptedException interruptedException) {
                throw new GoogleAuthException("Interrupted");
            }
            finally {
                zzm2.zzb(zzHk, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        zzx.zzb(accountName, (Object)"accountName must be provided");
        zzx.zzbe("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.zzI(context);
        return GoogleAuthUtil.getToken(ctx, accountName, "^^_account_id_^^", new Bundle());
    }

    private static void zzh(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static String zza(Context context, Account account, String string2, Bundle bundle) throws IOException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            return GoogleAuthUtil.getToken(context, account, string2, bundle);
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            GooglePlayServicesUtil.showErrorNotification(n, context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static void zzI(Context context) throws GoogleAuthException {
        try {
            GooglePlayServicesUtil.zzI(context);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static boolean zzaC(String string2) {
        return "NetworkError".equals(string2) || "ServiceUnavailable".equals(string2) || "Timeout".equals(string2);
    }

    private static boolean zzaD(String string2) {
        return "BadAuthentication".equals(string2) || "CaptchaRequired".equals(string2) || "DeviceManagementRequiredOrSyncDisabled".equals(string2) || "NeedPermission".equals(string2) || "NeedsBrowser".equals(string2) || "UserCancel".equals(string2) || "AppDownloadRequired".equals(string2) || zzjo.zzHG.zzhg().equals(string2) || zzjo.zzHH.zzhg().equals(string2) || zzjo.zzHI.zzhg().equals(string2) || zzjo.zzHJ.zzhg().equals(string2) || zzjo.zzHK.zzhg().equals(string2) || zzjo.zzHL.zzhg().equals(string2) || zzjo.zzHE.zzhg().equals(string2);
    }

    private GoogleAuthUtil() {
    }
}

