/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractPendingResult<R extends Result>
implements PendingResult<R> {
    private final Object zzLK = new Object();
    protected final CallbackHandler<R> mHandler;
    private final CountDownLatch zzmx = new CountDownLatch(1);
    private final ArrayList<PendingResult.BatchCallback> zzLL = new ArrayList();
    private ResultCallback<R> zzLM;
    private volatile R zzLN;
    private volatile boolean zzLO;
    private boolean zzLP;
    private boolean zzLQ;
    private ICancelToken zzLR;

    protected AbstractPendingResult(Looper looper) {
        this.mHandler = new CallbackHandler(looper);
    }

    protected AbstractPendingResult(CallbackHandler<R> callbackHandler) {
        this.mHandler = callbackHandler;
    }

    public final boolean isReady() {
        return this.zzmx.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzx.zza(!this.zzLO, (Object)"Result has already been consumed");
        try {
            this.zzmx.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzhR();
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzhQ();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzx.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzx.zza(!this.zzLO, (Object)"Result has already been consumed.");
        try {
            boolean bl = this.zzmx.await(time, units);
            if (!bl) {
                this.zzhS();
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzhR();
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzhQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback) {
        zzx.zza(!this.zzLO, (Object)"Result has already been consumed.");
        Object object = this.zzLK;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzhQ());
            } else {
                this.zzLM = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
        zzx.zza(!this.zzLO, (Object)"Result has already been consumed.");
        zzx.zza(this.mHandler != null, (Object)"CallbackHandler has not been set before calling setResultCallback.");
        Object object = this.zzLK;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzhQ());
            } else {
                this.zzLM = callback;
                this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBatchCallback(PendingResult.BatchCallback callback) {
        zzx.zza(!this.zzLO, (Object)"Result has already been consumed.");
        Object object = this.zzLK;
        synchronized (object) {
            if (this.isReady()) {
                callback.zzl(this.zzLN.getStatus());
            } else {
                this.zzLL.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzLK;
        synchronized (object) {
            if (this.zzLP || this.zzLO) {
                return;
            }
            if (this.zzLR != null) {
                try {
                    this.zzLR.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            AbstractPendingResult.zzb(this.zzLN);
            this.zzLM = null;
            this.zzLP = true;
            this.zza(this.createFailedResult(Status.zzNs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzLK;
        synchronized (object) {
            return this.zzLP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R result) {
        Object object = this.zzLK;
        synchronized (object) {
            if (this.zzLQ || this.zzLP) {
                AbstractPendingResult.zzb(result);
                return;
            }
            zzx.zza(!this.isReady(), (Object)"Results have already been set");
            zzx.zza(!this.zzLO, (Object)"Result has already been consumed");
            this.zza(result);
        }
    }

    protected abstract R createFailedResult(Status var1);

    protected void onResultConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setCancelToken(ICancelToken cancelToken) {
        Object object = this.zzLK;
        synchronized (object) {
            this.zzLR = cancelToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R zzhQ() {
        R r;
        Object object = this.zzLK;
        synchronized (object) {
            zzx.zza(!this.zzLO, (Object)"Result has already been consumed.");
            zzx.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzLN;
            this.zzLN = null;
            this.zzLM = null;
            this.zzLO = true;
        }
        this.onResultConsumed();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhR() {
        Object object = this.zzLK;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(Status.zzNp));
                this.zzLQ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzhS() {
        Object object = this.zzLK;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(Status.zzNr));
                this.zzLQ = true;
            }
        }
    }

    private void zza(R r) {
        this.zzLN = r;
        this.zzLR = null;
        this.zzmx.countDown();
        Status status = this.zzLN.getStatus();
        if (this.zzLM != null) {
            this.mHandler.removeTimeoutMessages();
            if (!this.zzLP) {
                this.mHandler.sendResultCallback(this.zzLM, this.zzhQ());
            }
        }
        for (PendingResult.BatchCallback batchCallback : this.zzLL) {
            batchCallback.zzl(status);
        }
        this.zzLL.clear();
    }

    static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"AbstractPendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.zzhS();
                    return;
                }
            }
            Log.wtf((String)"AbstractPendingResult", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                AbstractPendingResult.zzb(result);
                throw runtimeException;
            }
        }
    }
}

