/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.zza, R extends Result, T extends zza.zza<R, A>> T zza(T var1);

    public <A extends Api.zza, T extends zza.zza<? extends Result, A>> T zzb(T var1);

    public <L> zze<L> zzf(L var1);

    public <C extends Api.zza> C zza(Api.zzc<C> var1);

    public boolean zza(Api<?> var1);

    public boolean zzb(Api<?> var1);

    public boolean zza(Scope var1);

    public Context getContext();

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public PendingResult<Status> clearDefaultAccountAndReconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public int getSessionId();

    public static final class Builder {
        private Account zzFN;
        private final Set<String> zzMe = new HashSet<String>();
        private int zzMf;
        private View zzMg;
        private String zzMh;
        private String zzMi;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzMj = new HashMap();
        private final Map<Api<?>, Boolean> zzMk = new HashMap();
        private FragmentActivity zzMl;
        private int zzMm = -1;
        private OnConnectionFailedListener zzMn;
        private Looper zzMc;
        private Api.zzb<? extends zzur, zzus> zzMo;
        private final Set<ConnectionCallbacks> zzMp = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> zzMq = new HashSet<OnConnectionFailedListener>();
        private zzus.zza zzMr = new zzus.zza();

        public Builder(Context context) {
            this.mContext = context;
            this.zzMc = context.getMainLooper();
            this.zzMh = context.getPackageName();
            this.zzMi = context.getClass().getName();
            this.zzMo = zzup.zzGS;
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzx.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzMp.add(connectedListener);
            zzx.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzMq.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzx.zzb(handler, (Object)"Handler must not be null");
            this.zzMc = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zzMp.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zzMq.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.zzMg = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.zzMe.add(scope.zzio());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.zzMj.put(api, null);
            List<Scope> list = api.zzhU();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.zzMe.add(list.get(i).zzio());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzMj.put(api, options);
            List<Scope> list = api.zzhU();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.zzMe.add(list.get(i).zzio());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzFN = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzMf = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzx.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzMm = clientId;
            this.zzMl = zzx.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzMn = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzMr.zza(serverClientId, callbacks);
            return this;
        }

        public zzf zzhY() {
            return new zzf(this.zzFN, this.zzMe, this.zzMf, this.zzMg, this.zzMh, this.zzMi, this.zzMr.zzsy());
        }

        public GoogleApiClient build() {
            zzx.zzb(!this.zzMj.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzMm >= 0) {
                return this.zzhZ();
            }
            return new zzd(this.mContext, this.zzMc, this.zzhY(), this.zzMo, this.zzMj, this.zzMk, this.zzMp, this.zzMq, -1);
        }

        private GoogleApiClient zzhZ() {
            zzh zzh2 = zzh.zza(this.zzMl);
            GoogleApiClient googleApiClient = zzh2.zzar(this.zzMm);
            if (googleApiClient == null) {
                googleApiClient = new zzd(this.mContext.getApplicationContext(), this.zzMc, this.zzhY(), this.zzMo, this.zzMj, this.zzMk, this.zzMp, this.zzMq, this.zzMm);
            }
            zzh2.zza(this.zzMm, googleApiClient, this.zzMn);
            return googleApiClient;
        }
    }

    public static interface zza {
        public void zzia();

        public void zzib();
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzMs;
            private Set<Scope> zzMe;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzx.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzMs = requiresNewAuthCode;
                this.zzMe = requiredScopes;
            }

            public boolean zzic() {
                return this.zzMs;
            }

            public Set<Scope> zzid() {
                return this.zzMe;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

