/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    private final int zzFG;
    private final Uri zzOL;
    private final int zzli;
    private final int zzlj;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.zzFG = versionCode;
        this.zzOL = url;
        this.zzli = width;
        this.zzlj = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.zze(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.zzFG;
    }

    private static Uri zze(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.zzOL;
    }

    public int getWidth() {
        return this.zzli;
    }

    public int getHeight() {
        return this.zzlj;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.zzli, this.zzlj, this.zzOL.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzOL.toString());
            jSONObject.put("width", this.zzli);
            jSONObject.put("height", this.zzlj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return zzw.equal(this.zzOL, webImage.zzOL) && this.zzli == webImage.zzli && this.zzlj == webImage.zzlj;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzOL, this.zzli, this.zzlj);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }
}

