/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzia;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SafeParcelResponse
extends FastJsonResponse
implements SafeParcelable {
    private final int zzzH;
    private final Parcel zzUN;
    private final int zzUO;
    private final FieldMappingDictionary zzUG;
    private final String mClassName;
    private int zzUP;
    private int zzUQ;
    public static final zze CREATOR = new zze();

    private SafeParcelResponse(SafeParcelable safeParcelable, FieldMappingDictionary dictionary, String className) {
        this.zzzH = 1;
        this.zzUN = Parcel.obtain();
        safeParcelable.writeToParcel(this.zzUN, 0);
        this.zzUO = 1;
        this.zzUG = zzv.zzr(dictionary);
        this.mClassName = zzv.zzr(className);
        this.zzUP = 2;
    }

    public static <T extends FastJsonResponse> SafeParcelResponse zza(T t) {
        String string2 = t.getClass().getCanonicalName();
        FieldMappingDictionary fieldMappingDictionary = SafeParcelResponse.zzb(t);
        return new SafeParcelResponse((SafeParcelable)((Object)t), fieldMappingDictionary, string2);
    }

    private static FieldMappingDictionary zzb(FastJsonResponse fastJsonResponse) {
        FieldMappingDictionary fieldMappingDictionary = new FieldMappingDictionary(fastJsonResponse.getClass());
        SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse);
        fieldMappingDictionary.zzmM();
        fieldMappingDictionary.zzmL();
        return fieldMappingDictionary;
    }

    private static void zza(FieldMappingDictionary fieldMappingDictionary, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!fieldMappingDictionary.zzb(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.zzmy();
            fieldMappingDictionary.zza(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<FastJsonResponse> clazz2 = field.zzmG();
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Could not instantiate an object of type " + field.zzmG().getCanonicalName(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Could not access object of type " + field.zzmG().getCanonicalName(), illegalAccessException);
                }
            }
        }
    }

    SafeParcelResponse(int versionCode, Parcel parcel, FieldMappingDictionary fieldMappingDictionary) {
        this.zzzH = versionCode;
        this.zzUN = zzv.zzr(parcel);
        this.zzUO = 2;
        this.zzUG = fieldMappingDictionary;
        this.mClassName = this.zzUG == null ? null : this.zzUG.zzmO();
        this.zzUP = 2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    public Parcel zzmQ() {
        switch (this.zzUP) {
            case 0: {
                this.zzUQ = zzb.zzM(this.zzUN);
                zzb.zzH(this.zzUN, this.zzUQ);
                this.zzUP = 2;
                break;
            }
            case 1: {
                zzb.zzH(this.zzUN, this.zzUQ);
                this.zzUP = 2;
                break;
            }
        }
        return this.zzUN;
    }

    FieldMappingDictionary zzmR() {
        switch (this.zzUO) {
            case 0: {
                return null;
            }
            case 1: {
                return this.zzUG;
            }
            case 2: {
                return this.zzUG;
            }
        }
        throw new IllegalStateException("Invalid creation type: " + this.zzUO);
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> zzmy() {
        if (this.zzUG == null) {
            return null;
        }
        return this.zzUG.zzbX(this.mClassName);
    }

    @Override
    protected Object zzbT(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    protected boolean zzbU(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public String toString() {
        zzv.zzb(this.zzUG, (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zzmQ();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.zzUG.zzbX(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> hashMap = SafeParcelResponse.zzB(map);
        stringBuilder.append('{');
        int n = zza.zzL(parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            int n2 = zza.zzK(parcel);
            int n3 = zza.zzaV(n2);
            Map.Entry<String, FastJsonResponse.Field<?, ?>> entry = hashMap.get(n3);
            if (entry == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, entry.getKey(), entry.getValue(), parcel, n2);
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new zza.zza("Overread allowed size end=" + n, parcel);
        }
        stringBuilder.append('}');
    }

    private static HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> zzB(Map<String, FastJsonResponse.Field<?, ?>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> entry : map.entrySet()) {
            hashMap.put(entry.getValue().zzmF(), entry);
        }
        return hashMap;
    }

    private void zza(StringBuilder stringBuilder, String string2, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        stringBuilder.append("\"").append(string2).append("\":");
        if (field.zzmI()) {
            this.zza(stringBuilder, field, parcel, n);
        } else {
            this.zzb(stringBuilder, field, parcel, n);
        }
    }

    private void zza(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        switch (field.zzmx()) {
            case 0: {
                int n2 = zza.zzg(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, n2));
                break;
            }
            case 1: {
                BigInteger bigInteger = zza.zzk(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigInteger));
                break;
            }
            case 2: {
                long l = zza.zzi(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, l));
                break;
            }
            case 3: {
                float f = zza.zzl(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, Float.valueOf(f)));
                break;
            }
            case 4: {
                double d = zza.zzm(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, d));
                break;
            }
            case 5: {
                BigDecimal bigDecimal = zza.zzn(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigDecimal));
                break;
            }
            case 6: {
                boolean bl = zza.zzc(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bl));
                break;
            }
            case 7: {
                String string2 = zza.zzo(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, string2));
                break;
            }
            case 8: 
            case 9: {
                byte[] byArray = zza.zzr(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, byArray));
                break;
            }
            case 10: {
                Bundle bundle = zza.zzq(parcel, n);
                HashMap<String, String> hashMap = SafeParcelResponse.zzh(bundle);
                this.zzb(stringBuilder, field, this.zza(field, hashMap));
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown field out type = " + field.zzmx());
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        if (field.zzmD()) {
            stringBuilder.append("[");
            switch (field.zzmx()) {
                case 0: {
                    int[] nArray = zza.zzu(parcel, n);
                    zzhq.zza(stringBuilder, nArray);
                    break;
                }
                case 1: {
                    BigInteger[] bigIntegerArray = zza.zzw(parcel, n);
                    zzhq.zza(stringBuilder, bigIntegerArray);
                    break;
                }
                case 2: {
                    long[] lArray = zza.zzv(parcel, n);
                    zzhq.zza(stringBuilder, lArray);
                    break;
                }
                case 3: {
                    float[] fArray = zza.zzx(parcel, n);
                    zzhq.zza(stringBuilder, fArray);
                    break;
                }
                case 4: {
                    double[] dArray = zza.zzy(parcel, n);
                    zzhq.zza(stringBuilder, dArray);
                    break;
                }
                case 5: {
                    BigDecimal[] bigDecimalArray = zza.zzz(parcel, n);
                    zzhq.zza(stringBuilder, bigDecimalArray);
                    break;
                }
                case 6: {
                    boolean[] blArray = zza.zzt(parcel, n);
                    zzhq.zza(stringBuilder, blArray);
                    break;
                }
                case 7: {
                    String[] stringArray = zza.zzA(parcel, n);
                    zzhq.zza(stringBuilder, stringArray);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                }
                case 11: {
                    Parcel[] parcelArray = zza.zzE(parcel, n);
                    int n2 = parcelArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        parcelArray[i].setDataPosition(0);
                        this.zza(stringBuilder, field.zzmK(), parcelArray[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out.");
                }
            }
            stringBuilder.append("]");
        } else {
            switch (field.zzmx()) {
                case 0: {
                    int n3 = zza.zzg(parcel, n);
                    stringBuilder.append(n3);
                    break;
                }
                case 1: {
                    BigInteger bigInteger = zza.zzk(parcel, n);
                    stringBuilder.append(bigInteger);
                    break;
                }
                case 2: {
                    long l = zza.zzi(parcel, n);
                    stringBuilder.append(l);
                    break;
                }
                case 3: {
                    float f = zza.zzl(parcel, n);
                    stringBuilder.append(f);
                    break;
                }
                case 4: {
                    double d = zza.zzm(parcel, n);
                    stringBuilder.append(d);
                    break;
                }
                case 5: {
                    BigDecimal bigDecimal = zza.zzn(parcel, n);
                    stringBuilder.append(bigDecimal);
                    break;
                }
                case 6: {
                    boolean bl = zza.zzc(parcel, n);
                    stringBuilder.append(bl);
                    break;
                }
                case 7: {
                    String string2 = zza.zzo(parcel, n);
                    stringBuilder.append("\"").append(zzhz.zzbY(string2)).append("\"");
                    break;
                }
                case 8: {
                    byte[] byArray = zza.zzr(parcel, n);
                    stringBuilder.append("\"").append(zzhr.zzg(byArray)).append("\"");
                    break;
                }
                case 9: {
                    byte[] byArray = zza.zzr(parcel, n);
                    stringBuilder.append("\"").append(zzhr.zzh(byArray));
                    stringBuilder.append("\"");
                    break;
                }
                case 10: {
                    Bundle bundle = zza.zzq(parcel, n);
                    Set set = bundle.keySet();
                    int n4 = set.size();
                    stringBuilder.append("{");
                    boolean bl = true;
                    for (String string3 : set) {
                        if (!bl) {
                            stringBuilder.append(",");
                        }
                        bl = false;
                        stringBuilder.append("\"").append(string3).append("\"");
                        stringBuilder.append(":");
                        stringBuilder.append("\"").append(zzhz.zzbY(bundle.getString(string3))).append("\"");
                    }
                    stringBuilder.append("}");
                    break;
                }
                case 11: {
                    Parcel parcel2 = zza.zzD(parcel, n);
                    parcel2.setDataPosition(0);
                    this.zza(stringBuilder, field.zzmK(), parcel2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out");
                }
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zzmC()) {
            this.zzb(stringBuilder, field, (ArrayList)object);
        } else {
            this.zza(stringBuilder, field.zzmw(), object);
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, ArrayList<?> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, field.zzmw(), arrayList.get(i));
        }
        stringBuilder.append("]");
    }

    private void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                break;
            }
            case 7: {
                stringBuilder.append("\"").append(zzhz.zzbY(object.toString())).append("\"");
                break;
            }
            case 8: {
                stringBuilder.append("\"").append(zzhr.zzg((byte[])object)).append("\"");
                break;
            }
            case 9: {
                stringBuilder.append("\"").append(zzhr.zzh((byte[])object));
                stringBuilder.append("\"");
                break;
            }
            case 10: {
                zzia.zza(stringBuilder, (HashMap)object);
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown type = " + n);
            }
        }
    }

    public static HashMap<String, String> zzh(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }
}

