/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzid;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzb {
    private static final Object zzTK = new Object();
    private static zzb zzVc;
    private final List<String> zzVd;
    private final List<String> zzVe;
    private final List<String> zzVf;
    private final List<String> zzVg;
    private static final ComponentName zzVh;
    private zze zzVi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zznb() {
        Object object = zzTK;
        synchronized (object) {
            if (zzVc == null) {
                zzVc = new zzb();
            }
        }
        return zzVc;
    }

    private zzb() {
        if (this.getLogLevel() == zzd.zzVq) {
            this.zzVd = Collections.EMPTY_LIST;
            this.zzVe = Collections.EMPTY_LIST;
            this.zzVf = Collections.EMPTY_LIST;
            this.zzVg = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzVl.get();
        this.zzVd = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzVm.get();
        this.zzVe = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzVn.get();
        this.zzVf = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzVo.get();
        this.zzVg = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzVi = new zze(1024, zzc.zza.zzVp.get());
    }

    private boolean zza(Context context, Intent intent) {
        return false;
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zza(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        this.zza(context, serviceConnection, string2, intent, "BIND");
        return context.bindService(intent, serviceConnection, n);
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, "UNBIND");
        context.unbindService(serviceConnection);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, serviceConnection, string2, intent, "CONNECT");
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, "DISCONNECT");
    }

    private void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent, String string3) {
        ConnectionEvent connectionEvent;
        if (!com.google.android.gms.common.internal.zzd.zzSV) {
            return;
        }
        long l = this.zzb(serviceConnection);
        if (!this.zza(context, string2, intent, l, string3)) {
            return;
        }
        long l2 = System.currentTimeMillis();
        String string4 = null;
        if ((this.getLogLevel() & zzd.zzVu) != 0) {
            string4 = zzid.zzj(3, 5);
        }
        long l3 = 0L;
        if ((this.getLogLevel() & zzd.zzVw) != 0) {
            l3 = Debug.getNativeHeapAllocatedSize();
        }
        if (string3.equals("UNBIND") || string3.equals("DISCONNECT")) {
            connectionEvent = new ConnectionEvent(l2, string3, null, null, null, null, string4, l, SystemClock.elapsedRealtime(), l3);
        } else {
            ServiceInfo serviceInfo = zzb.zzb(context, intent);
            connectionEvent = new ConnectionEvent(l2, string3, zzid.zzW(context), string2, serviceInfo.processName, serviceInfo.name, string4, l, SystemClock.elapsedRealtime(), l3);
        }
        context.startService(new Intent().setComponent(zzVh).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zza(Context context, String string2, Intent intent, long l, String string3) {
        int n = this.getLogLevel();
        if (n == zzd.zzVq || this.zzVi == null) {
            return false;
        }
        if (string3 == "DISCONNECT" || string3 == "UNBIND") {
            return this.zzVi.zzA(l);
        }
        ServiceInfo serviceInfo = zzb.zzb(context, intent);
        if (serviceInfo == null) {
            Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string2, intent.toUri(0)));
            return false;
        }
        String string4 = zzid.zzW(context);
        String string5 = serviceInfo.processName;
        String string6 = serviceInfo.name;
        if (this.zzVd.contains(string4) || this.zzVe.contains(string2) || this.zzVf.contains(string5) || this.zzVg.contains(string6) || string5.equals(string4) && (n & zzd.zzVv) != 0) {
            return false;
        }
        this.zzVi.zza(l);
        return true;
    }

    private static ServiceInfo zzb(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzid.zzj(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzid.zzj(3, 20)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private long zzb(ServiceConnection serviceConnection) {
        return (long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection);
    }

    private int getLogLevel() {
        try {
            return com.google.android.gms.common.internal.zzd.zzSV && zzhc.isInitialized() && zzhc.zzlj() == Process.myUid() ? zzc.zza.zzVk.get() : zzd.zzVq;
        }
        catch (SecurityException securityException) {
            return zzd.zzVq;
        }
    }

    static {
        zzVh = new ComponentName("com.google.android.gms", "com.google.android.gms.common.stats.GmsCoreStatsService");
    }
}

