/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzob;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class zznr {
    private final ByteBuffer zzaNH;

    private zznr(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zznr(ByteBuffer byteBuffer) {
        this.zzaNH = byteBuffer;
    }

    public static zznr zzw(byte[] byArray) {
        return zznr.zzb(byArray, 0, byArray.length);
    }

    public static zznr zzb(byte[] byArray, int n, int n2) {
        return new zznr(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzB(n, 1);
        this.zzf(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzB(n, 5);
        this.zzi(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzB(n, 0);
        this.zzV(l);
    }

    public void zzx(int n, int n2) throws IOException {
        this.zzB(n, 0);
        this.zzjs(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzB(n, 0);
        this.zzam(bl);
    }

    public void zzb(int n, String string) throws IOException {
        this.zzB(n, 2);
        this.zzeA(string);
    }

    public void zza(int n, zzny zzny2) throws IOException {
        this.zzB(n, 2);
        this.zzc(zzny2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzB(n, 2);
        this.zzx(byArray);
    }

    public void zzy(int n, int n2) throws IOException {
        this.zzB(n, 0);
        this.zzjt(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzB(n, 0);
        this.zzW(l);
    }

    public void zzf(double d) throws IOException {
        this.zzab(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzjA(Float.floatToIntBits(f));
    }

    public void zzV(long l) throws IOException {
        this.zzZ(l);
    }

    public void zzjs(int n) throws IOException {
        if (n >= 0) {
            this.zzjy(n);
        } else {
            this.zzZ(n);
        }
    }

    public void zzam(boolean bl) throws IOException {
        this.zzjw(bl ? 1 : 0);
    }

    public void zzeA(String string) throws IOException {
        try {
            int n = zznr.zzjz(string.length());
            int n2 = zznr.zzjz(string.length() * 3);
            if (n == n2) {
                int n3 = this.zzaNH.position();
                this.zzaNH.position(n3 + n);
                zznr.zza((CharSequence)string, this.zzaNH);
                int n4 = this.zzaNH.position();
                this.zzaNH.position(n3);
                this.zzjy(n4 - n3 - n);
                this.zzaNH.position(n4);
            } else {
                this.zzjy(zznr.zza(string));
                zznr.zza((CharSequence)string, this.zzaNH);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new zza(this.zzaNH.position(), this.zzaNH.limit());
        }
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zznr.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zznr.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zznr.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzny zzny2) throws IOException {
        zzny2.zza(this);
    }

    public void zzc(zzny zzny2) throws IOException {
        this.zzjy(zzny2.zzAb());
        zzny2.zza(this);
    }

    public void zzx(byte[] byArray) throws IOException {
        this.zzjy(byArray.length);
        this.zzz(byArray);
    }

    public void zzjt(int n) throws IOException {
        this.zzjy(zznr.zzjB(n));
    }

    public void zzW(long l) throws IOException {
        this.zzZ(zznr.zzac(l));
    }

    public static int zzb(int n, double d) {
        return zznr.zzjx(n) + zznr.zzg(d);
    }

    public static int zzc(int n, float f) {
        return zznr.zzjx(n) + zznr.zzj(f);
    }

    public static int zzd(int n, long l) {
        return zznr.zzjx(n) + zznr.zzX(l);
    }

    public static int zzz(int n, int n2) {
        return zznr.zzjx(n) + zznr.zzju(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zznr.zzjx(n) + zznr.zzan(bl);
    }

    public static int zzj(int n, String string) {
        return zznr.zzjx(n) + zznr.zzeB(string);
    }

    public static int zzb(int n, zzny zzny2) {
        return zznr.zzjx(n) * 2 + zznr.zzd(zzny2);
    }

    public static int zzc(int n, zzny zzny2) {
        return zznr.zzjx(n) + zznr.zze(zzny2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zznr.zzjx(n) + zznr.zzy(byArray);
    }

    public static int zzA(int n, int n2) {
        return zznr.zzjx(n) + zznr.zzjv(n2);
    }

    public static int zze(int n, long l) {
        return zznr.zzjx(n) + zznr.zzY(l);
    }

    public static int zzg(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzX(long l) {
        return zznr.zzaa(l);
    }

    public static int zzju(int n) {
        if (n >= 0) {
            return zznr.zzjz(n);
        }
        return 10;
    }

    public static int zzan(boolean bl) {
        return 1;
    }

    public static int zzeB(String string) {
        int n = zznr.zza(string);
        return zznr.zzjz(n) + n;
    }

    public static int zzd(zzny zzny2) {
        return zzny2.zzAc();
    }

    public static int zze(zzny zzny2) {
        int n = zzny2.zzAc();
        return zznr.zzjz(n) + n;
    }

    public static int zzy(byte[] byArray) {
        return zznr.zzjz(byArray.length) + byArray.length;
    }

    public static int zzjv(int n) {
        return zznr.zzjz(zznr.zzjB(n));
    }

    public static int zzY(long l) {
        return zznr.zzaa(zznr.zzac(l));
    }

    public int zzzN() {
        return this.zzaNH.remaining();
    }

    public void zzzO() {
        if (this.zzzN() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzaNH.hasRemaining()) {
            throw new zza(this.zzaNH.position(), this.zzaNH.limit());
        }
        this.zzaNH.put(by);
    }

    public void zzjw(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzz(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzaNH.remaining() < n2) {
            throw new zza(this.zzaNH.position(), this.zzaNH.limit());
        }
        this.zzaNH.put(byArray, n, n2);
    }

    public void zzB(int n, int n2) throws IOException {
        this.zzjy(zzob.zzC(n, n2));
    }

    public static int zzjx(int n) {
        return zznr.zzjz(zzob.zzC(n, 0));
    }

    public void zzjy(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzjw(n);
                return;
            }
            this.zzjw(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzjz(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzZ(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzjw((int)l);
                return;
            }
            this.zzjw((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzaa(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzjA(int n) throws IOException {
        this.zzjw(n & 0xFF);
        this.zzjw(n >> 8 & 0xFF);
        this.zzjw(n >> 16 & 0xFF);
        this.zzjw(n >> 24 & 0xFF);
    }

    public void zzab(long l) throws IOException {
        this.zzjw((int)l & 0xFF);
        this.zzjw((int)(l >> 8) & 0xFF);
        this.zzjw((int)(l >> 16) & 0xFF);
        this.zzjw((int)(l >> 24) & 0xFF);
        this.zzjw((int)(l >> 32) & 0xFF);
        this.zzjw((int)(l >> 40) & 0xFF);
        this.zzjw((int)(l >> 48) & 0xFF);
        this.zzjw((int)(l >> 56) & 0xFF);
    }

    public static int zzjB(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzac(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

