/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzb<R extends Result>
implements PendingResult<R> {
    private final Object zzYD = new Object();
    protected final zza<R> zzYE;
    private final CountDownLatch zzoR = new CountDownLatch(1);
    private final ArrayList<PendingResult.BatchCallback> zzYF = new ArrayList();
    private ResultCallback<R> zzYG;
    private volatile R zzYH;
    private volatile boolean zzYI;
    private boolean zzL;
    private boolean zzYJ;
    private zzq zzYK;

    protected zzb(Looper looper) {
        this.zzYE = new zza(looper);
    }

    protected zzb(zza<R> zza2) {
        this.zzYE = zzx.zzb(zza2, (Object)"CallbackHandler must not be null");
    }

    public final boolean isReady() {
        return this.zzoR.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzx.zza(!this.zzYI, (Object)"Result has already been consumed");
        try {
            this.zzoR.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzaaE);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzx.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzx.zza(!this.zzYI, (Object)"Result has already been consumed.");
        try {
            boolean bl = this.zzoR.await(time, units);
            if (!bl) {
                this.zzw(Status.zzaaG);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzaaE);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback) {
        zzx.zza(!this.zzYI, (Object)"Result has already been consumed.");
        Object object = this.zzYD;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzYE.zza(callback, this.get());
            } else {
                this.zzYG = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
        zzx.zza(!this.zzYI, (Object)"Result has already been consumed.");
        Object object = this.zzYD;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzYE.zza(callback, this.get());
            } else {
                this.zzYG = callback;
                this.zzYE.zza(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBatchCallback(PendingResult.BatchCallback callback) {
        zzx.zza(!this.zzYI, (Object)"Result has already been consumed.");
        Object object = this.zzYD;
        synchronized (object) {
            if (this.isReady()) {
                callback.onComplete(this.zzYH.getStatus());
            } else {
                this.zzYF.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzYD;
        synchronized (object) {
            if (this.zzL || this.zzYI) {
                return;
            }
            if (this.zzYK != null) {
                try {
                    this.zzYK.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzb.zzc(this.zzYH);
            this.zzYG = null;
            this.zzL = true;
            this.zzb(this.zzb(Status.zzaaH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzYD;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(R r) {
        Object object = this.zzYD;
        synchronized (object) {
            if (this.zzYJ || this.zzL) {
                zzb.zzc(r);
                return;
            }
            zzx.zza(!this.isReady(), (Object)"Results have already been set");
            zzx.zza(!this.zzYI, (Object)"Result has already been consumed");
            this.zzb(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzw(Status status) {
        Object object = this.zzYD;
        synchronized (object) {
            if (!this.isReady()) {
                this.zza(this.zzb(status));
                this.zzYJ = true;
            }
        }
    }

    protected abstract R zzb(Status var1);

    protected void zzmZ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzq zzq2) {
        Object object = this.zzYD;
        synchronized (object) {
            this.zzYK = zzq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzYD;
        synchronized (object) {
            zzx.zza(!this.zzYI, (Object)"Result has already been consumed.");
            zzx.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzYH;
            this.zzYH = null;
            this.zzYG = null;
            this.zzYI = true;
        }
        this.zzmZ();
        return r;
    }

    private void zzb(R r) {
        this.zzYH = r;
        this.zzYK = null;
        this.zzoR.countDown();
        Status status = this.zzYH.getStatus();
        if (this.zzYG != null) {
            this.zzYE.zzna();
            if (!this.zzL) {
                this.zzYE.zza(this.zzYG, this.get());
            }
        }
        for (PendingResult.BatchCallback batchCallback : this.zzYF) {
            batchCallback.onComplete(status);
        }
        this.zzYF.clear();
    }

    static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"AbstractPendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzb<R> zzb2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzb2), l);
        }

        public void zzna() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzb zzb2 = (zzb)msg.obj;
                    zzb2.zzw(Status.zzaaG);
                    return;
                }
            }
            Log.wtf((String)"AbstractPendingResult", (String)"Don't know how to handle this message.");
        }

        protected void zzb(ResultCallback<R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzb.zzc(r);
                throw runtimeException;
            }
        }
    }
}

