/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zznx;

public final class zzmu
extends Drawable
implements Drawable.Callback {
    private int zzais = 0;
    private long zzQj;
    private int mFrom;
    private int zzait;
    private int zzaiu = 255;
    private int zzaiv;
    private int zzaiw = 0;
    private boolean zzail = true;
    private boolean zzaix;
    private zzb zzaiy;
    private Drawable zzaiz;
    private Drawable zzaiA;
    private boolean zzaiB;
    private boolean zzaiC;
    private boolean zzaiD;
    private int zzaiE;

    public zzmu(Drawable drawable, Drawable drawable2) {
        this(null);
        if (drawable == null) {
            drawable = zza.zzaiF;
        }
        this.zzaiz = drawable;
        drawable.setCallback((Drawable.Callback)this);
        this.zzaiy.zzaiI |= drawable.getChangingConfigurations();
        if (drawable2 == null) {
            drawable2 = zza.zzaiF;
        }
        this.zzaiA = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaiy.zzaiI |= drawable2.getChangingConfigurations();
    }

    zzmu(zzb zzb2) {
        this.zzaiy = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zznx.zzrN() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zznx.zzrN() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zznx.zzrN() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaiy.zzaiH | this.zzaiy.zzaiI;
    }

    public void setAlpha(int alpha) {
        if (this.zzaiw == this.zzaiu) {
            this.zzaiw = alpha;
        }
        this.zzaiu = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzaiz.setColorFilter(cf);
        this.zzaiA.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzaiz.getIntrinsicWidth(), this.zzaiA.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzaiz.getIntrinsicHeight(), this.zzaiA.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzaiz.setBounds(bounds);
        this.zzaiA.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaiy.zzaiH = this.getChangingConfigurations();
            return this.zzaiy;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzaiD) {
            this.zzaiE = Drawable.resolveOpacity((int)this.zzaiz.getOpacity(), (int)this.zzaiA.getOpacity());
            this.zzaiD = true;
        }
        return this.zzaiE;
    }

    public boolean canConstantState() {
        if (!this.zzaiB) {
            this.zzaiC = this.zzaiz.getConstantState() != null && this.zzaiA.getConstantState() != null;
            this.zzaiB = true;
        }
        return this.zzaiC;
    }

    public Drawable mutate() {
        if (!this.zzaix && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaiz.mutate();
            this.zzaiA.mutate();
            this.zzaix = true;
        }
        return this;
    }

    public Drawable zzpV() {
        return this.zzaiA;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzait = this.zzaiu;
        this.zzaiw = 0;
        this.zzaiv = durationMillis;
        this.zzais = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzais) {
            case 1: {
                this.zzQj = SystemClock.uptimeMillis();
                bl = false;
                this.zzais = 2;
                break;
            }
            case 2: {
                if (this.zzQj < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzQj) / (float)this.zzaiv;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzais = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzaiw = (int)((float)this.mFrom + (float)(this.zzait - this.mFrom) * f);
            }
        }
        int n = this.zzaiw;
        boolean bl3 = this.zzail;
        Drawable drawable = this.zzaiz;
        Drawable drawable2 = this.zzaiA;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable.draw(canvas);
            }
            if (n == this.zzaiu) {
                drawable2.setAlpha(this.zzaiu);
                drawable2.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable.setAlpha(this.zzaiu - n);
        }
        drawable.draw(canvas);
        if (bl3) {
            drawable.setAlpha(this.zzaiu);
        }
        if (n > 0) {
            drawable2.setAlpha(n);
            drawable2.draw(canvas);
            drawable2.setAlpha(this.zzaiu);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzmu$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzmu$zza zzaiF = new com.google.android.gms.internal.zzmu$zza();
        private static final zza zzaiG = new zza();

        private com.google.android.gms.internal.zzmu$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzaiG;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzaiF;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzaiH;
        int zzaiI;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzaiH = zzb2.zzaiH;
                this.zzaiI = zzb2.zzaiI;
            }
        }

        public Drawable newDrawable() {
            return new zzmu(this);
        }

        public int getChangingConfigurations() {
            return this.zzaiH;
        }
    }
}

