/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzne;

public final class GooglePlayServicesUtil
extends zze {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";

    private GooglePlayServicesUtil() {
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.zza(errorCode, activity, null, requestCode, cancelListener);
    }

    @TargetApi(value=14)
    private static Dialog zza(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzmu.zzaw((Context)activity) && n == 2) {
            n = 42;
        }
        if (GooglePlayServicesUtil.zzd((Context)activity, n)) {
            n = 18;
        }
        AlertDialog.Builder builder = null;
        if (zzne.zzsg()) {
            object = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, object, true);
            string3 = activity.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        object = GooglePlayServicesUtil.zzao((Context)activity);
        builder.setMessage((CharSequence)zzg.zzc((Context)activity, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        string3 = GoogleApiAvailability.getInstance().zza((Context)activity, n, "d");
        zzh zzh2 = fragment == null ? new zzh(activity, (Intent)string3, n2) : new zzh(fragment, (Intent)string3, n2);
        String string4 = zzg.zzh((Context)activity, n);
        if (string4 != null) {
            builder.setPositiveButton((CharSequence)string4, (DialogInterface.OnClickListener)zzh2);
        }
        if ((string2 = zzg.zzg((Context)activity, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, null, requestCode, cancelListener);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        Dialog dialog = GooglePlayServicesUtil.zza(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        GooglePlayServicesUtil.zza(activity, cancelListener, GMS_ERROR_DIALOG, dialog);
        return true;
    }

    @TargetApi(value=11)
    public static void zza(Activity activity, DialogInterface.OnCancelListener onCancelListener, String string2, @NonNull Dialog dialog) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzne.zzsd()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }

    @Deprecated
    public static void showErrorNotification(int errorCode, Context context) {
        if (zzmu.zzaw((Context)context) && errorCode == 2) {
            errorCode = 42;
        }
        if (GooglePlayServicesUtil.zzd(context, errorCode) || GooglePlayServicesUtil.zze(context, errorCode)) {
            GooglePlayServicesUtil.zzam(context);
        } else {
            GooglePlayServicesUtil.zza(errorCode, context);
        }
    }

    private static void zzam(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    @TargetApi(value=21)
    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    @TargetApi(value=21)
    private static void zza(int n, Context context, String string2) {
        int n2;
        Notification.Builder builder;
        Notification notification;
        String string3;
        Resources resources = context.getResources();
        String string4 = GooglePlayServicesUtil.zzao((Context)context);
        String string5 = zzg.zzg(context, n);
        if (string5 == null) {
            string5 = resources.getString(R.string.common_google_play_services_notification_ticker);
        }
        String string6 = zzg.zzc(context, n, string4);
        PendingIntent pendingIntent = GoogleApiAvailability.getInstance().zza(context, n, 0, "n");
        if (zzmu.zzaw((Context)context)) {
            zzx.zzab((boolean)zzne.zzsh());
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)(string5 + " " + string6))).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            if (zzne.zzsd()) {
                builder = new Notification.Builder(context).setSmallIcon(17301642).setContentTitle((CharSequence)string5).setContentText((CharSequence)string6).setContentIntent(pendingIntent).setTicker((CharSequence)string3).setAutoCancel(true);
                if (zzne.zzsl()) {
                    builder.setLocalOnly(true);
                }
                if (zzne.zzsh()) {
                    builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string6));
                    notification = builder.build();
                } else {
                    notification = builder.getNotification();
                }
                if (Build.VERSION.SDK_INT == 19) {
                    notification.extras.putBoolean("android.support.localOnly", true);
                }
            } else {
                builder = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)string3).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string5).setContentText((CharSequence)string6);
                notification = builder.build();
            }
        }
        if (GooglePlayServicesUtil.zzbw((int)n)) {
            n2 = 10436;
            zzafQ.set(false);
        } else {
            n2 = 39789;
        }
        builder = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            builder.notify(string2, n2, notification);
        } else {
            builder.notify(n2, notification);
        }
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static String getErrorString(int errorCode) {
        return zze.getErrorString((int)errorCode);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        return zze.isGooglePlayServicesAvailable((Context)context);
    }

    @Deprecated
    public static Intent zzbv(int n) {
        return zze.zzbv((int)n);
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        return zze.getErrorPendingIntent((int)errorCode, (Context)context, (int)requestCode);
    }

    @Deprecated
    public static boolean isUserRecoverableError(int errorCode) {
        return zze.isUserRecoverableError((int)errorCode);
    }

    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        return zze.getOpenSourceSoftwareLicenseInfo((Context)context);
    }

    public static Resources getRemoteResource(Context context) {
        return zze.getRemoteResource((Context)context);
    }

    public static Context getRemoteContext(Context context) {
        return zze.getRemoteContext((Context)context);
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        return zze.zzd((Context)context, (int)n);
    }

    @Deprecated
    public static boolean zze(Context context, int n) {
        return zze.zze((Context)context, (int)n);
    }

    private static class zza
    extends Handler {
        private final Context zzsa;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzsa = context.getApplicationContext();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zzsa);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zzsa);
                    break;
                }
                default: {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Don't know how to handle this message: " + msg.what));
                }
            }
        }
    }
}

