/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int mSize;
    private int mColor;
    private Scope[] zzafT;
    private View zzafU;
    private View.OnClickListener zzafV = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zza(context, attrs);
        this.setStyle(this.mSize, this.mColor, this.zzafT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.SignInButton, 0, 0);
        try {
            this.mSize = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.mColor = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
            String string = typedArray.getString(R.styleable.SignInButton_scopeUris);
            if (string == null) {
                this.zzafT = null;
            } else {
                String[] stringArray = string.trim().split("\\s+");
                this.zzafT = new Scope[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.zzafT[i] = new Scope(stringArray[i].toString());
                }
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor, this.zzafT);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme, this.zzafT);
    }

    public void setScopes(Scope[] scopes) {
        this.setStyle(this.mSize, this.mColor, scopes);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        this.setStyle(buttonSize, colorScheme, this.zzafT);
    }

    public void setStyle(int buttonSize, int colorScheme, Scope[] scopes) {
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.zzafT = scopes;
        this.zzar(this.getContext());
    }

    private void zzar(Context context) {
        if (this.zzafU != null) {
            this.removeView(this.zzafU);
        }
        try {
            this.zzafU = zzab.zzb(context, this.mSize, this.mColor, this.zzafT);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzafU = SignInButton.zza(context, this.mSize, this.mColor, this.zzafT);
        }
        this.addView(this.zzafU);
        this.zzafU.setEnabled(this.isEnabled());
        this.zzafU.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2, Scope[] scopeArray) {
        zzac zzac2 = new zzac(context);
        zzac2.zza(context.getResources(), n, n2, scopeArray);
        return zzac2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.zzafV = listener;
        if (this.zzafU != null) {
            this.zzafU.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.zzafU.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.zzafV != null && view == this.zzafU) {
            this.zzafV.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

