/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzavx;
    private Bundle zzavy;
    private LinkedList<zza> zzavz;
    private final zzf<T> zzavA = new zzf<T>(){

        public void zza(T t) {
            zza.this.zzavx = t;
            for (zza zza2 : zza.this.zzavz) {
                zza2.zzb(zza.this.zzavx);
            }
            zza.this.zzavz.clear();
            zza.this.zzavy = null;
        }
    };

    public T zztU() {
        return this.zzavx;
    }

    private void zzeJ(int n) {
        while (!this.zzavz.isEmpty() && this.zzavz.getLast().getState() >= n) {
            this.zzavz.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzavx != null) {
            zza2.zzb((LifecycleDelegate)this.zzavx);
            return;
        }
        if (this.zzavz == null) {
            this.zzavz = new LinkedList();
        }
        this.zzavz.add(zza2);
        if (bundle != null) {
            if (this.zzavy == null) {
                this.zzavy = (Bundle)bundle.clone();
            } else {
                this.zzavy.putAll(bundle);
            }
        }
        this.zza(this.zzavA);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle attrs, final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzavx.onInflate(activity, attrs, savedInstanceState);
            }
        });
    }

    public void onCreate(final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzavx.onCreate(savedInstanceState);
            }
        });
    }

    public View onCreateView(final LayoutInflater inflater, final ViewGroup container, final Bundle savedInstanceState) {
        final FrameLayout frameLayout = new FrameLayout(inflater.getContext());
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzavx.onCreateView(inflater, container, savedInstanceState));
            }
        });
        if (this.zzavx == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzg.zzc(context, n, GooglePlayServicesUtil.zzao((Context)context));
        String string3 = zzg.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(GooglePlayServicesUtil.zzbv(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzavx.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzavx.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzavx != null) {
            this.zzavx.onPause();
        } else {
            this.zzeJ(5);
        }
    }

    public void onStop() {
        if (this.zzavx != null) {
            this.zzavx.onStop();
        } else {
            this.zzeJ(4);
        }
    }

    public void onDestroyView() {
        if (this.zzavx != null) {
            this.zzavx.onDestroyView();
        } else {
            this.zzeJ(2);
        }
    }

    public void onDestroy() {
        if (this.zzavx != null) {
            this.zzavx.onDestroy();
        } else {
            this.zzeJ(1);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.zzavx != null) {
            this.zzavx.onSaveInstanceState(outState);
        } else if (this.zzavy != null) {
            outState.putAll(this.zzavy);
        }
    }

    public void onLowMemory() {
        if (this.zzavx != null) {
            this.zzavx.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

