/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzpj;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzapv = new Object();
    private static HashSet<Uri> zzapw = new HashSet();
    private static ImageManager zzapx;
    private static ImageManager zzapy;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzapz;
    private final zzb zzapA;
    private final zzpj zzapB;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzapC;
    private final Map<Uri, ImageReceiver> zzapD;
    private final Map<Uri, Long> zzapE;

    public static ImageManager create(Context context) {
        return ImageManager.zzg(context, false);
    }

    public static ImageManager zzg(Context context, boolean bl) {
        if (bl) {
            if (zzapy == null) {
                zzapy = new ImageManager(context, true);
            }
            return zzapy;
        }
        if (zzapx == null) {
            zzapx = new ImageManager(context, false);
        }
        return zzapx;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzapz = Executors.newFixedThreadPool(4);
        if (bl) {
            this.zzapA = new zzb(this.mContext);
            if (zzs.zzva()) {
                this.zzsZ();
            }
        } else {
            this.zzapA = null;
        }
        this.zzapB = new zzpj();
        this.zzapC = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzapD = new HashMap<Uri, ImageReceiver>();
        this.zzapE = new HashMap<Uri, Long>();
    }

    @TargetApi(value=14)
    private void zzsZ() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.zzapA));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, n);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzbV(n);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        zzc2.zzbV(n);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzdc((String)"ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzapA == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzapA.get(zza2);
        return bitmap;
    }

    @TargetApi(value=11)
    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends LruCache<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzat(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        @TargetApi(value=11)
        private static int zzat(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzs.zzuX() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object object, Object object2) {
            return this.zza((zza.zza)object, (Bitmap)object2);
        }

        protected /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            this.zza(bl, (zza.zza)object, (Bitmap)object2, (Bitmap)object3);
        }
    }

    @TargetApi(value=14)
    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb zzapA;

        public zze(zzb zzb2) {
            this.zzapA = zzb2;
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        public void onLowMemory() {
            this.zzapA.evictAll();
        }

        public void onTrimMemory(int n) {
            if (n >= 60) {
                this.zzapA.evictAll();
            } else if (n >= 20) {
                this.zzapA.trimToSize(this.zzapA.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzqF;
        private boolean zzapJ;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzapJ = bl;
            this.zzqF = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzdc((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzapA != null) {
                if (this.zzapJ) {
                    ImageManager.this.zzapA.evictAll();
                    System.gc();
                    this.zzapJ = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzapA.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzapD.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzqF.countDown();
            Object object = zzapv;
            synchronized (object) {
                zzapw.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzapF;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzapE.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzapB, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzapC.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzapH;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzapH = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzdd((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzapH != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzapH.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzapH.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzapF;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzapF = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzdc((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzapF.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzdc((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzapF.remove(zza2);
        }

        public void zztb() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzapz.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzapI;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.zzapI = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzdc((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzapC.get(this.zzapI));
            if (imageReceiver != null) {
                ImageManager.this.zzapC.remove(this.zzapI);
                imageReceiver.zzc(this.zzapI);
            }
            zza.zza zza2 = this.zzapI.zzapK;
            if (zza2.uri == null) {
                this.zzapI.zza(ImageManager.this.mContext, ImageManager.this.zzapB, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzapI.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzapE.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzapI.zza(ImageManager.this.mContext, ImageManager.this.zzapB, true);
                    return;
                }
                ImageManager.this.zzapE.remove(zza2.uri);
            }
            this.zzapI.zza(ImageManager.this.mContext, ImageManager.this.zzapB);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzapD.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzapD.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzapI);
            if (!(this.zzapI instanceof zza.zzc)) {
                ImageManager.this.zzapC.put(this.zzapI, imageReceiver);
            }
            Object object = zzapv;
            synchronized (object) {
                boolean bl = zzapw.contains(zza2.uri);
                if (!bl) {
                    zzapw.add(zza2.uri);
                    imageReceiver.zztb();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

