/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzpt;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzpt<BatchResult> {
    private int rx;
    private boolean ry;
    private boolean rz;
    private final PendingResult<?>[] rA;
    private final Object zzail = new Object();

    private Batch(List<PendingResult<?>> list, GoogleApiClient googleApiClient) {
        super(googleApiClient);
        this.rx = list.size();
        this.rA = new PendingResult[this.rx];
        if (list.isEmpty()) {
            this.zzc(new BatchResult(Status.sg, this.rA));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PendingResult<?> pendingResult = list.get(i);
            this.rA[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzv(Status status) {
                    Object object = Batch.this.zzail;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.rz = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.ry = true;
                        }
                        Batch.this.rx--;
                        if (Batch.this.rx == 0) {
                            if (Batch.this.rz) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.ry ? new Status(13) : Status.sg;
                                Batch.this.zzc(new BatchResult(status2, Batch.this.rA));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.rA) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.rA);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> rC = new ArrayList();
        private GoogleApiClient hb;

        public Builder(GoogleApiClient googleApiClient) {
            this.hb = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.rC.size());
            this.rC.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.rC, this.hb);
        }
    }
}

