/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzpu;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzvy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzpv
implements zzqm {
    private final Context mContext;
    private final zzqd sX;
    private final Looper zzahv;
    private final zzqf sY;
    private final zzqf sZ;
    private final Map<Api.zzc<?>, zzqf> ta;
    private final Set<zzqy> tb = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze tc;
    private Bundle td;
    private ConnectionResult te = null;
    private ConnectionResult tf = null;
    private boolean tg = false;
    private final Lock th;
    private int ti = 0;

    public static zzpv zza(Context context, zzqd zzqd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzvx, zzvy> zza2, ArrayList<zzpu> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzafz()) {
                zze2 = object;
            }
            if (object.zzafk()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzab.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzanp();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzpu>();
        ArrayList<zzpu> arrayList2 = new ArrayList<zzpu>();
        for (zzpu zzpu2 : arrayList) {
            if (arrayMap5.containsKey(zzpu2.pD)) {
                ((ArrayList)object).add(zzpu2);
                continue;
            }
            if (arrayMap.containsKey(zzpu2.pD)) {
                arrayList2.add(zzpu2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zzpv(context, zzqd2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzg2, zza2, zze2, (ArrayList<zzpu>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zzpv(Context context, zzqd zzqd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzg zzg2, Api.zza<? extends zzvx, zzvy> zza2, Api.zze zze2, ArrayList<zzpu> arrayList, ArrayList<zzpu> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.sX = zzqd2;
        this.th = lock;
        this.zzahv = looper;
        this.tc = zze2;
        this.sY = new zzqf(context, this.sX, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.sZ = new zzqf(context, this.sX, lock, looper, zzc2, map, zzg2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.sY);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.sZ);
        }
        this.ta = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpr.zza<R, A>> T zzc(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzape()) {
                t.zzz(new Status(4, null, this.zzapf()));
                return t;
            }
            return this.sZ.zzc(t);
        }
        return this.sY.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zzd(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzape()) {
                t.zzz(new Status(4, null, this.zzapf()));
                return t;
            }
            return this.sZ.zzd(t);
        }
        return this.sY.zzd(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.ta.get(api.zzanp()).equals(this.sZ)) {
            if (this.zzape()) {
                return new ConnectionResult(4, this.zzapf());
            }
            return this.sZ.getConnectionResult(api);
        }
        return this.sY.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.ti = 2;
        this.tg = false;
        this.zzapa();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.tf = null;
        this.te = null;
        this.ti = 0;
        this.sY.disconnect();
        this.sZ.disconnect();
        this.zzapd();
    }

    @Override
    public boolean isConnected() {
        this.th.lock();
        try {
            boolean bl = this.sY.isConnected() && (this.zzaoz() || this.zzape() || this.ti == 1);
            return bl;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.th.lock();
        try {
            boolean bl = this.ti == 2;
            return bl;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public boolean zza(zzqy zzqy2) {
        this.th.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzaoz()) {
                this.tb.add(zzqy2);
                if (this.ti == 0) {
                    this.ti = 1;
                }
                this.tf = null;
                this.sZ.connect();
                boolean bl = true;
                return true;
            }
        }
        finally {
            this.th.unlock();
        }
        return false;
    }

    @Override
    public void zzaoy() {
        this.sY.zzaoy();
        this.sZ.zzaoy();
    }

    @Override
    public void zzaoc() {
        this.th.lock();
        try {
            boolean bl = this.isConnecting();
            this.sZ.disconnect();
            this.tf = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzahv);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzpv.this.th.lock();
                        try {
                            zzpv.this.zzapb();
                        }
                        finally {
                            zzpv.this.th.unlock();
                        }
                    }
                });
            } else {
                this.zzapd();
            }
        }
        finally {
            this.th.unlock();
        }
    }

    public boolean zzaoz() {
        return this.sZ.isConnected();
    }

    private void zzapa() {
        this.tf = null;
        this.te = null;
        this.sY.connect();
        this.sZ.connect();
    }

    private void zzapb() {
        if (zzpv.zzc(this.te)) {
            if (zzpv.zzc(this.tf) || this.zzape()) {
                this.zzapc();
            } else if (this.tf != null) {
                if (this.ti == 1) {
                    this.zzapd();
                } else {
                    this.zzb(this.tf);
                    this.sY.disconnect();
                }
            }
        } else if (this.te != null && zzpv.zzc(this.tf)) {
            this.sZ.disconnect();
            this.zzb(this.te);
        } else if (this.te != null && this.tf != null) {
            ConnectionResult connectionResult = this.te;
            if (this.sZ.uq < this.sY.uq) {
                connectionResult = this.tf;
            }
            this.zzb(connectionResult);
        }
    }

    private void zzapc() {
        switch (this.ti) {
            case 2: {
                this.sX.zzm(this.td);
            }
            case 1: {
                this.zzapd();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.ti = 0;
    }

    private void zzb(ConnectionResult connectionResult) {
        switch (this.ti) {
            case 2: {
                this.sX.zzd(connectionResult);
            }
            case 1: {
                this.zzapd();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.ti = 0;
    }

    private void zzapd() {
        for (zzqy zzqy2 : this.tb) {
            zzqy2.zzafy();
        }
        this.tb.clear();
    }

    private void zzb(int n, boolean bl) {
        this.sX.zzc(n, bl);
        this.tf = null;
        this.te = null;
    }

    private boolean zzape() {
        return this.tf != null && this.tf.getErrorCode() == 4;
    }

    private boolean zze(zzpr.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzanp();
        zzab.zzb((boolean)this.ta.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.ta.get(zzc2).equals(this.sZ);
    }

    @Nullable
    private PendingIntent zzapf() {
        if (this.tc == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.sX.getSessionId(), (Intent)this.tc.zzaga(), (int)0x8000000);
    }

    private void zzl(Bundle bundle) {
        if (this.td == null) {
            this.td = bundle;
        } else if (bundle != null) {
            this.td.putAll(bundle);
        }
    }

    private static boolean zzc(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.sZ.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.sY.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzqm.zza {
        private zzb() {
        }

        @Override
        public void zzm(@Nullable Bundle bundle) {
            zzpv.this.th.lock();
            try {
                zzpv.this.tf = ConnectionResult.qR;
                zzpv.this.zzapb();
            }
            finally {
                zzpv.this.th.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzpv.this.th.lock();
            try {
                zzpv.this.tf = connectionResult;
                zzpv.this.zzapb();
            }
            finally {
                zzpv.this.th.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzpv.this.th.lock();
            try {
                if (zzpv.this.tg) {
                    zzpv.this.tg = false;
                    zzpv.this.zzb(n, bl);
                    return;
                }
                zzpv.this.tg = true;
                zzpv.this.sY.onConnectionSuspended(n);
            }
            finally {
                zzpv.this.th.unlock();
            }
        }
    }

    private class zza
    implements zzqm.zza {
        private zza() {
        }

        @Override
        public void zzm(@Nullable Bundle bundle) {
            zzpv.this.th.lock();
            try {
                zzpv.this.zzl(bundle);
                zzpv.this.te = ConnectionResult.qR;
                zzpv.this.zzapb();
            }
            finally {
                zzpv.this.th.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzpv.this.th.lock();
            try {
                zzpv.this.te = connectionResult;
                zzpv.this.zzapb();
            }
            finally {
                zzpv.this.th.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzpv.this.th.lock();
            try {
                if (zzpv.this.tg || zzpv.this.tf == null || !zzpv.this.tf.isSuccess()) {
                    zzpv.this.tg = false;
                    zzpv.this.zzb(n, bl);
                    return;
                }
                zzpv.this.tg = true;
                zzpv.this.sZ.onConnectionSuspended(n);
            }
            finally {
                zzpv.this.th.unlock();
            }
        }
    }
}

