/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.lang.ref.WeakReference;

public class zzrc<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> vk = null;
    private zzrc<? extends Result> vl = null;
    private volatile ResultCallbacks<? super R> vm = null;
    private PendingResult<R> vn = null;
    private final Object sJ = new Object();
    private Status vo = null;
    private final WeakReference<GoogleApiClient> sL;
    private final zza vp;
    private boolean vq = false;

    public zzrc(WeakReference<GoogleApiClient> weakReference) {
        zzab.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.sL = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sL.get();
        this.vp = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.sJ;
        synchronized (object) {
            zzab.zza((this.vk == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzab.zza((this.vm == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.vk = resultTransform;
            zzrc<R> zzrc2 = new zzrc<R>(this.sL);
            this.vl = zzrc2;
            this.zzaqs();
            return zzrc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.sJ;
        synchronized (object) {
            zzab.zza((this.vm == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzab.zza((this.vk == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.vm = resultCallbacks;
            this.zzaqs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.sJ;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.vk != null) {
                    zzqw.zzapz().submit(new Runnable((Result)r){
                        final /* synthetic */ Result vr;
                        {
                            this.vr = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzpt.sI.set(true);
                                PendingResult pendingResult = zzrc.this.vk.onSuccess(this.vr);
                                zzrc.this.vp.sendMessage(zzrc.this.vp.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzrc.this.vp.sendMessage(zzrc.this.vp.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzpt.sI.set(false);
                                zzrc.this.zze(this.vr);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzrc.this.sL.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzrc.this);
                                }
                            }
                        }
                    });
                } else if (this.zzaqu()) {
                    this.vm.onSuccess(r);
                }
            } else {
                this.zzac(r.getStatus());
                this.zze((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.sJ;
        synchronized (object) {
            this.vn = pendingResult;
            this.zzaqs();
        }
    }

    private void zzaqs() {
        if (this.vk == null && this.vm == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sL.get();
        if (!this.vq && this.vk != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.vq = true;
        }
        if (this.vo != null) {
            this.zzad(this.vo);
        } else if (this.vn != null) {
            this.vn.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzac(Status status) {
        Object object = this.sJ;
        synchronized (object) {
            this.vo = status;
            this.zzad(this.vo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzad(Status status) {
        Object object = this.sJ;
        synchronized (object) {
            if (this.vk != null) {
                Status status2 = this.vk.onFailure(status);
                zzab.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzac(status2);
            } else if (this.zzaqu()) {
                this.vm.onFailure(status);
            }
        }
    }

    void zzaqt() {
        this.vm = null;
    }

    private boolean zzaqu() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sL.get();
        return this.vm != null && googleApiClient != null;
    }

    private void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzrc.this.sJ;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzrc)zzrc.this.vl).zzac(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzqx) {
                            ((zzrc)zzrc.this.vl).zzac(((zzqx)pendingResult).getStatus());
                        } else {
                            zzrc.this.vl.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

