/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzrf
extends Drawable
implements Drawable.Callback {
    private int wE = 0;
    private long zzczk;
    private int mFrom;
    private int wF;
    private int wG = 255;
    private int wH;
    private int wI = 0;
    private boolean wy = true;
    private boolean wJ;
    private zzb wK;
    private Drawable wL;
    private Drawable wM;
    private boolean wN;
    private boolean wO;
    private boolean wP;
    private int wQ;

    public zzrf(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.wR;
        }
        this.wL = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.wK.wU |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.wR;
        }
        this.wM = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.wK.wU |= drawable3.getChangingConfigurations();
    }

    zzrf(zzb zzb2) {
        this.wK = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzavj() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzavj() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzavj() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.wK.wT | this.wK.wU;
    }

    public void setAlpha(int n) {
        if (this.wI == this.wG) {
            this.wI = n;
        }
        this.wG = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.wL.setColorFilter(colorFilter);
        this.wM.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.wL.getIntrinsicWidth(), this.wM.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.wL.getIntrinsicHeight(), this.wM.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.wL.setBounds(rect);
        this.wM.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.wK.wT = this.getChangingConfigurations();
            return this.wK;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.wP) {
            this.wQ = Drawable.resolveOpacity((int)this.wL.getOpacity(), (int)this.wM.getOpacity());
            this.wP = true;
        }
        return this.wQ;
    }

    public boolean canConstantState() {
        if (!this.wN) {
            this.wO = this.wL.getConstantState() != null && this.wM.getConstantState() != null;
            this.wN = true;
        }
        return this.wO;
    }

    public Drawable mutate() {
        if (!this.wJ && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.wL.mutate();
            this.wM.mutate();
            this.wJ = true;
        }
        return this;
    }

    public Drawable zzarm() {
        return this.wM;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.wF = this.wG;
        this.wI = 0;
        this.wH = n;
        this.wE = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.wE) {
            case 1: {
                this.zzczk = SystemClock.uptimeMillis();
                bl = false;
                this.wE = 2;
                break;
            }
            case 2: {
                if (this.zzczk < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzczk) / (float)this.wH;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.wE = 0;
                }
                f = Math.min(f, 1.0f);
                this.wI = (int)(0.0f + (float)(this.wF - 0) * f);
            }
        }
        int n = this.wI;
        boolean bl3 = this.wy;
        Drawable drawable2 = this.wL;
        Drawable drawable3 = this.wM;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.wG) {
                drawable3.setAlpha(this.wG);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.wG - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.wG);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.wG);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzrf$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzrf$zza wR = new com.google.android.gms.internal.zzrf$zza();
        private static final zza wS = new zza();

        private com.google.android.gms.internal.zzrf$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return wS;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return wR;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int wT;
        int wU;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.wT = zzb2.wT;
                this.wU = zzb2.wU;
            }
        }

        public Drawable newDrawable() {
            return new zzrf(this);
        }

        public int getChangingConfigurations() {
            return this.wT;
        }
    }
}

