/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzc<O extends Api.ApiOptions> {
    private final Context mContext;
    private final zzqo rO;
    private final Api<O> pN;
    private final O rP;
    private final zzpj<O> rQ;
    private final Looper zzahv;
    private final int mId;
    private final zzqc rR;
    private final GoogleApiClient rS;
    private final AtomicBoolean rT = new AtomicBoolean(false);
    private final AtomicInteger rU = new AtomicInteger(0);

    public zzc(@NonNull Context context, Api<O> api, O o, Looper looper) {
        zzab.zzb((Object)context, (Object)"Null context is not permitted.");
        zzab.zzb(api, (Object)"Api must not be null.");
        zzab.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.pN = api;
        this.rP = o;
        this.zzahv = looper;
        this.rO = new zzqo();
        this.rQ = new zzpj<O>(this.pN, this.rP);
        this.rS = new zzqd(this);
        Pair<zzqc, Integer> pair = zzqc.zza(this.mContext, this);
        this.rR = (zzqc)pair.first;
        this.mId = (Integer)pair.second;
    }

    public zzc(@NonNull Context context, Api<O> api, O o) {
        this(context, api, o, Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper());
    }

    public void release() {
        if (this.rT.getAndSet(true)) {
            return;
        }
        this.rO.release();
        this.rR.zzd(this.mId, this.rU.get() > 0);
    }

    private <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzaow();
        this.rR.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzqw<A, TResult> zzqw2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.rR.zza(this, n, zzqw2, taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zza(zzqw<A, TResult> zzqw2) {
        return this.zza(0, zzqw2);
    }

    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zzb(zzqw<A, TResult> zzqw2) {
        return this.zza(1, zzqw2);
    }

    public void zzanx() {
        this.rU.incrementAndGet();
    }

    public void zzany() {
        if (this.rU.decrementAndGet() == 0 && this.rT.get()) {
            this.rR.zzd(this.mId, false);
        }
    }

    public Api<O> zzanz() {
        return this.pN;
    }

    public O zzaoa() {
        return this.rP;
    }

    public zzpj<O> zzaob() {
        return this.rQ;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient zzaoc() {
        return this.rS;
    }

    public Looper getLooper() {
        return this.zzahv;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }
}

