/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzrc;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object wr = new Object();
    private static HashSet<Uri> ws = new HashSet();
    private static ImageManager wt;
    private static ImageManager wu;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService wv;
    private final zzb ww;
    private final zzrc wx;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> wy;
    private final Map<Uri, ImageReceiver> wz;
    private final Map<Uri, Long> wA;

    public static ImageManager create(Context context) {
        return ImageManager.zzg(context, false);
    }

    public static ImageManager zzg(Context context, boolean bl) {
        if (bl) {
            if (wu == null) {
                wu = new ImageManager(context, true);
            }
            return wu;
        }
        if (wt == null) {
            wt = new ImageManager(context, false);
        }
        return wt;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.wv = Executors.newFixedThreadPool(4);
        if (bl) {
            this.ww = new zzb(this.mContext);
            if (zzs.zzavq()) {
                this.zzarn();
            }
        } else {
            this.ww = null;
        }
        this.wx = new zzrc();
        this.wy = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.wz = new HashMap<Uri, ImageReceiver>();
        this.wA = new HashMap<Uri, Long>();
    }

    @TargetApi(value=14)
    private void zzarn() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.ww));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, n);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzfy(n);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        zzc2.zzfy(n);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzhi((String)"ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.ww == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.ww.get(zza2);
        return bitmap;
    }

    @TargetApi(value=11)
    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends LruCache<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzcc(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        @TargetApi(value=11)
        private static int zzcc(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzs.zzavn() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object object, Object object2) {
            return this.zza((zza.zza)object, (Bitmap)object2);
        }

        protected /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            this.zza(bl, (zza.zza)object, (Bitmap)object2, (Bitmap)object3);
        }
    }

    @TargetApi(value=14)
    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb ww;

        public zze(zzb zzb2) {
            this.ww = zzb2;
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        public void onLowMemory() {
            this.ww.evictAll();
        }

        public void onTrimMemory(int n) {
            if (n >= 60) {
                this.ww.evictAll();
            } else if (n >= 20) {
                this.ww.trimToSize(this.ww.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzale;
        private boolean wF;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.wF = bl;
            this.zzale = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzhi((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.ww != null) {
                if (this.wF) {
                    ImageManager.this.ww.evictAll();
                    System.gc();
                    this.wF = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.ww.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.wz.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzale.countDown();
            Object object = wr;
            synchronized (object) {
                ws.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.wB;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.wA.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.wx, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.wy.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor wD;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.wD = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzhj((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.wD != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.wD.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.wD.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> wB;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.wB = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzhi((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.wB.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzhi((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.wB.remove(zza2);
        }

        public void zzarp() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.wv.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza wE;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.wE = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzhi((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.wy.get(this.wE));
            if (imageReceiver != null) {
                ImageManager.this.wy.remove(this.wE);
                imageReceiver.zzc(this.wE);
            }
            zza.zza zza2 = this.wE.wG;
            if (zza2.uri == null) {
                this.wE.zza(ImageManager.this.mContext, ImageManager.this.wx, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.wE.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.wA.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.wE.zza(ImageManager.this.mContext, ImageManager.this.wx, true);
                    return;
                }
                ImageManager.this.wA.remove(zza2.uri);
            }
            this.wE.zza(ImageManager.this.mContext, ImageManager.this.wx);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.wz.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.wz.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.wE);
            if (!(this.wE instanceof zza.zzc)) {
                ImageManager.this.wy.put(this.wE, imageReceiver);
            }
            Object object = wr;
            synchronized (object) {
                boolean bl = ws.contains(zza2.uri);
                if (!bl) {
                    ws.add(zza2.uri);
                    imageReceiver.zzarp();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

